<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>


<script>
edit_inline='0';
delete_inline='0';
</script>


<sec:authorize url="/pages/customer!deleteCustomer.action">
	<script>edit_inline='1';</script>
</sec:authorize>

<sec:authorize url="/pages/customer!deleteCustomer.action">
	<script>delete_inline='1';</script>
</sec:authorize>





<script src="../scripts/itsm/security/customerMain.js?random=<%=new java.util.Date().getTime()%>"></script>

<div style="padding:10px;color:#555555" id="customerMain_loading"><img src="../images/icons/loading.gif" /></div>



<!-- 树形主面板开始-->
<div style="padding:3px;display:none;" id="customerMain_content">

<!-- Customer start -->

<table id="customerGrid"></table>
<div id="customerGridPager"></div>



<div id="customerGridToolbar" style="display: none">
<sec:authorize url="/pages/customer!save.action">
<a class="easyui-linkbutton" plain="true" icon="icon-add" id="addCustomerBtn"><fmt:message key="common.add"/></a>
</sec:authorize>

<sec:authorize url="/pages/customer!merge.action">
<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="editCustomerBtn"><fmt:message key="common.edit"/></a>
</sec:authorize>

<sec:authorize url="/pages/customer!deleteCustomer.action">
<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="deleteCustomerBtn"><fmt:message key="common.delete"/></a> 
</sec:authorize>

<sec:authorize url="/pages/customer!findByCompany.action">
<a class="easyui-linkbutton" plain="true" icon="icon-search" id="searchCustomerBtn"><fmt:message key="common.search"/></a>
</sec:authorize>

&nbsp;&nbsp; | <fmt:message key="label.dc.export"/>：
<select id="customerGrid_export">
<option value="chooseExportType">--<fmt:message key="label.dc.chooseExportStyle"/>--</option>
<option value="view"><fmt:message key="label.dc.exportCurrentView"/></option>
</select>

&nbsp;&nbsp; | <fmt:message key="label.dc.import"/>：
<select id="customerGrid_import" >
<option value="chooseImportType">--<fmt:message key="label.dc.chooseImportStyle"/>--</option>
<option value="excel"><fmt:message key="label.dc.importFromExcel"/></option>
</select>

</div>











<!-- 搜索客户 -->
<div id="searchCustomerGrid" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="false" title="<fmt:message key="title.customer.searchCustomer"/>" style="width: 400px; height:auto">

<form style="margin:0px">

<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">

	<tr>
		<td style="height: 32px">
		<div><fmt:message key="label.customer.customerName"/></div>
		</td>
		<td><input id="searchCustomer_orgName" name="queryDto.orgName" class="input"/></td>
	</tr>

	
	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerPhone"/></td>
		<td><input id="searchCustomer_officePhone" name="queryDto.officePhone" class="input" /></td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerEmail"/></td>
		<td><input id="searchCustomer_email" name="queryDto.email" class="input" /></td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerAddress"/></td>
		<td><input id="searchCustomer_address" name="queryDto.address" class="input"  /></td>
	</tr>
	
	<tr>
		<td style="height: 32px" colspan="2">
		
		<input type="hidden" name="queryDto.companyNo" id="searchCustomerGrid_companyNo">
		<a id="searchCustomerBtn_OK" class="easyui-linkbutton" icon="icon-search"><fmt:message key="common.search"/></a>
		
		</td>
	</tr>
	
</table>
</div>



</form>
</div>



<!-- 新增客户 -->

<div id="addCustomer_win" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.customer.addCustomer"/>" style="width: 400px; height:auto">

<form id="addCustomer_form">

<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">

	<tr>
		<td style="height: 32px">
		<div ><fmt:message key="label.customer.customerName"/></div>
		</td>
		<td>
		<input name="customerDto.orgName" id="add_orgName" class="easyui-validatebox input" required="true" />
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerFax"/></td>
		<td><input name="customerDto.officeFax" id="add_officeFax" class="easyui-validatebox input" validType="phone" /></td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerPhone"/></td>
		<td>
		<input name="customerDto.officePhone" id="add_officePhone" class="easyui-validatebox input" validType="phone"/>
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerEmail"/></td>
		<td><input name="customerDto.email" id="add_email" class="easyui-validatebox input" validType="email"/>
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerAddress"/></td>
		<td>
		<input name="customerDto.address" id="add_addr" class="input" />
		</td>
	</tr>


	<tr>
		<td colspan="2" style="height: 50px">
		<input type="hidden" id="addCustomer_companyNo" name="customerDto.companyNo" value="-1">
		<a id="addCustomerBtn_OK" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="common.save"/></a>
		</td>
	</tr>

</table>
</div>


</form>


</div>

<!-- 新增客户 -->




<!-- 编辑客户 -->

<div id="editCustomer_win" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.customer.editCustomer"/>" style="width: 400px; height:auto">

<form id="editCustomer_form">

<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">

	<tr>
		<td style="height: 32px">
		<div ><fmt:message key="label.customer.customerName"/></div>
		</td>
		<td>
		<input id="editCustomer_orgName" name="customerDto.orgName" class="easyui-validatebox input" required="true" />
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerFax"/></td>
		<td><input id="editCustomer_officeFax" name="customerDto.officeFax" class="easyui-validatebox input" validType="phone" /></td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerPhone"/></td>
		<td>
		<input id="editCustomer_officePhone" name="customerDto.officePhone" class="easyui-validatebox input" validType="phone" />
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerEmail"/></td>
		<td><input id="editCustomer_email" name="customerDto.email" class="easyui-validatebox input" validType="email" />
		</td>
	</tr>

	<tr>
		<td style="height: 32px"><fmt:message key="label.customer.customerAddress"/></td>
		<td>
		<input id="editCustomer_address" name="customerDto.address" class="input" />
		</td>
	</tr>


	<tr>
		<td colspan="2" style="height: 50px">
		<input type="hidden" id="editCustomer_orgNo" name="customerDto.orgNo">
		<input type="hidden" id="editCustomer_companyNo" name="customerDto.companyNo">
		<a id="editCustomerBtn_OK" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="common.save"/></a>
		</td>
	</tr>

</table>

</div>
</form>
</div>

<!-- 导入数据 -->
<div id="importCustomerDataWindow"  class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="label.dc.import"/>" style="width:400px;height:auto">
	<form>
   <div class="lineTableBgDiv" >
    <table  class="lineTable"  width="100%" cellspacing="1"> 
        <tr>
            <td width="100px">
            <fmt:message key="label.dc.filePath"/>
        
            </td>
            <td>
           	<input type="file" name="queryDto.importFile" id="importCustomerFile" onchange="checkFileType(this,'xls')" class="easyui-validatebox input" required="true"/>
            </td>
        </tr>

        <tr>
            <td colspan="2">
                <div style="padding-top:8px;">
                	<a id="customerGrid_doImport" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="label.dc.import"/></a>
                </div>
        </td>
        </tr>
    </table>
    </div>
    </form>
</div>

     <!-- 导出的隐藏信息 -->
    <div style="display: none;" id="exportCustomerWindow">
	   <form action="customer!exportCustomer.action" method="post">
	     <table>
	     <tr>
			<td>			
				<input id="exportCustomer_orgName" name="queryDto.orgName" class="input">
				<input id="exportCustomer_officePhone" name="queryDto.officePhone" class="input">
				<input id="exportCustomer_email" name="queryDto.email" class="input">
				<input id="exportCustomer_address" name="queryDto.address" class="input">
				
				<input id="exportCustomer_sidx" name="sidx" class="input">
				<input id="exportCustomer_sord" name="sord" class="input">
				<input id="exportCustomer_page" name="page" class="input">
				<input id="exportCustomer_rows" name="rows" class="input">
			</td>
		</tr>
	     </table>
	   </form>
    </div>

</div>