<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>

<script src="../scripts/itsm/security/supplierMain.js"></script>


<div style="padding:10px;color:#555555" id="supplierMain_loading"><img src="../images/icons/loading.gif" /></div>




<!-- 树形主面板开始-->
<div style="padding:3px;display:none" id="supplierMain_content">

<table id="supplierGrid"></table>
<div id="supplierGridPager"></div>


<div id="supplierGridToolbar" style="display: none">
<sec:authorize url="/pages/supplier!save.action">
<a class="easyui-linkbutton" plain="true" icon="icon-add" id="addSupplierBtn"><fmt:message key="common.add" /></a>
</sec:authorize>
<sec:authorize url="/pages/supplier!merge.action">
<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="editSupplierBtn"><fmt:message key="common.edit" /></a>
</sec:authorize>
<sec:authorize url="/pages/supplier!deleteSupplier.action">
<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="deleteSupplierBtn"><fmt:message key="common.delete" /></a> 
</sec:authorize>
<sec:authorize url="/pages/supplier!findByCompany.action">
<a class="easyui-linkbutton" plain="true" icon="icon-search" id="searchSupplierBtn"><fmt:message key="common.search" /></a>
</sec:authorize>
</div>






<!-- 搜索供应商 -->
<div id="searchSupplierGrid" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="false" title="<fmt:message key="title.supplier.searchSupplier" />" style="width: 400px; height:auto">

<form>
<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">

 
	<tr>
		<td>
		<div><fmt:message key="label.supplier.supplierName" /></div>
		</td>
		<td>
		<input name="queryDto.orgName" class="input"/>
		</td>
	</tr>

	
	<tr>
		<td><fmt:message key="label.supplier.supplierPhone" /></td>
		<td>
		<input name="queryDto.officePhone" class="input" />
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierEmail" /></td>
		<td>
		<input name="queryDto.email" class="input" />
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierAddress" /></td>
		<td>
		<input name="queryDto.address"  class="input"/>
		</td>
	</tr>
	
	<tr>
		<td colspan="2">
		
		<input type="hidden" name="queryDto.companyNo" id="searchSupplierGrid_companyNo">
		<a id="searchSupplierBtn_OK" class="easyui-linkbutton" icon="icon-search"><fmt:message key="common.search" /></a>
		
		</td>
		
	</tr>
</table>
</div>

</form>
</div>



<!-- 新增供应商 -->

<div id="addSupplier_win" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.supplier.addSupplier" />" style="width: 400px; height:auto">

<form id="addSupplier_form">
<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">
	<tr>
		<td>
		<div ><fmt:message key="label.supplier.supplierName" /></div>
		</td>
		<td>
		<input name="supplierDto.orgName" class="easyui-validatebox input" id="addSupplier_orgName" required="true" />
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierFax" /></td>
		<td><input name="supplierDto.officeFax" class="easyui-validatebox input" id="addSupplier_officeFax" validType="phone"/></td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierPhone" /></td>
		<td>
		<input name="supplierDto.officePhone" class="easyui-validatebox input" id="addSupplier_officePhone" validType="phone"/>
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierEmail" /></td>
		<td><input name="supplierDto.email" class="easyui-validatebox input" id="addSupplier_email" validType="email"/>
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierAddress" /></td>
		<td>
		<input name="supplierDto.address" id="addSupplier_address" class="input" />
		</td>
	</tr>


	<tr>
		<td colspan="2">
		<input type="hidden" id="addSupplierDto_companyNo" name="supplierDto.companyNo" value="-1">
		<a id="addSupplierBtn_OK" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="common.save" /></a>
		</td>
	</tr>

</table>
</div>

</form>

</div>

<!-- 新增供应商 -->




<!-- 编辑供应商 -->

<div id="editSupplier_win" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.supplier.editSupplier" />" style="width: 400px; height:auto">

<form id="editSupplier_form">

<div class="lineTableBgDiv">
	<table style="width:100%" class="lineTable" cellspacing="1">

	<tr>
		<td>
		<div ><fmt:message key="label.supplier.supplierName" /></div>
		</td>
		<td>
		<input id="editSupplier_orgName" name="supplierDto.orgName" class="easyui-validatebox input" required="true" />
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierFax" /></td>
		<td><input id="editSupplier_officeFax" name="supplierDto.officeFax" class="easyui-validatebox input" validType="phone"/></td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierPhone" /></td>
		<td>
		<input id="editSupplier_officePhone" name="supplierDto.officePhone" class="easyui-validatebox input" validType="phone"/>
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierEmail" /></td>
		<td><input id="editSupplier_email" name="supplierDto.email" class="easyui-validatebox input" validType="email" />
		</td>
	</tr>

	<tr>
		<td><fmt:message key="label.supplier.supplierAddress" /></td>
		<td>
		<input id="editSupplier_address" name="supplierDto.address" class="input" />
		</td>
	</tr>


	<tr>
		<td colspan="2">
		<input type="hidden" id="editSupplier_orgNo" name="supplierDto.orgNo">
		<input type="hidden" id="editSupplier_companyNo" name="supplierDto.companyNo">
		<a id="editSupplierBtn_OK" class="easyui-linkbutton" icon="icon-ok"><fmt:message key="common.save" /></a>
		</td>
	</tr>

</table>
</div>

</form>

</div>

<!-- 编辑供应商 -->



</div>

