<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>

<script src="../scripts/itsm/security/user.js?random=<%=new java.util.Date().getTime()%>"></script>

<div class="loading" id="userMain_loading"><img src="../images/icons/loading.gif" /></div>
<div class="content" id="userMain_content">

<div id="userToolbarAct" style="display: none"><sec:authorize url="/pages/user!updateRoleByUserId.action"> <a href="javascript:itsm.security.user.opt_setRole_aff()" title="<fmt:message key="label.user.roleSettings" />"><img src="../images/icons/user.gif" border="0" /></a></sec:authorize>&nbsp;&nbsp;&nbsp;&nbsp;<sec:authorize url="/pages/user!merge.action"><a href="javascript:itsm.security.user.editUser_aff()" title="<fmt:message key="common.edit" />"><img src="../images/icons/edit.gif" border="0"/></a></sec:authorize>&nbsp;&nbsp;&nbsp;<sec:authorize url="/pages/user!delete.action"><a href="javascript:itsm.security.user.opt_delete()" title="<fmt:message key="common.delete" />"><img src="../images/icons/delete.gif" border="0"/></a></sec:authorize></div>

<!-- 数据列表 -->
<div>
	<div style="overflow:hidden">
		<table id="userGrid"></table>
		<div id="userPager"></div>
		<div id="userTopMenu" style="background-color: #EEEEEE; height: 28px;display: none;">
		
		<sec:authorize url="/pages/user!save.action">
			<a class="easyui-linkbutton" plain="true" icon="icon-add" id="link_user_add" href="javascript:itsm.security.user.user_add()"><fmt:message key="common.add" /></a> 
		</sec:authorize>
		
		<sec:authorize url="/pages/user!merge.action">
			<a class="easyui-linkbutton" plain="true" icon="icon-edit" id="link_user_edit"><fmt:message key="common.edit" /></a>
		</sec:authorize> 
		
		<sec:authorize url="/pages/user!delete.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-cancel" id="link_user_delete"><fmt:message key="common.delete" /></a> 
		</sec:authorize>
		
		<sec:authorize url="/pages/user!find.action">
		<a class="easyui-linkbutton" plain="true" icon="icon-search" id="link_user_search"><fmt:message key="common.search" /></a>
		</sec:authorize>
		
		<sec:authorize url="/pages/user!updateRoleByUserId.action"> 
			<a class="easyui-linkbutton" plain="true" icon="icon-roleSet" id="link_user_role"><fmt:message key="label.user.roleSettings" /></a>
		</sec:authorize>
		
		<sec:authorize url="/pages/user!mergeByOrg.action"> 
			<a class="easyui-linkbutton" plain="true" icon="icon-orgSet" id="link_user_org"><fmt:message key="label.user.orgSetting" /></a>
		</sec:authorize>
		
		&nbsp;&nbsp; | <fmt:message key="label.dc.export"/>/<fmt:message key="label.dc.import"/>：
		<select onchange="itsm.security.user.importExportUserData(this.value)" id="exportUserDataDc">
		<option value="chooseExportType">--<fmt:message key="label.dc.chooseExportStyle"/>--</option>
		<option value="view"><fmt:message key="label.dc.exportCurrentView"/></option>
		<option>---------------------</option>
		<option value="chooseImportType">--<fmt:message key="label.dc.chooseImportStyle"/>--</option>
		<option value="excel"><fmt:message key="label.dc.importFromExcel"/></option>
		</select>
		
		
		</div>
	</div>
</div>

<!-- 添加用户 -->
<div id="addUser" title="<fmt:message key="title.user.addOrEditUser" />" class="easyui-window" closed="true" collapsible="false" modal="true" minimizable="false" maximizable="false" collapsible="false" style="width:700px; height:auto;padding:3px">
<div id="userForm">
<form id="addUserForm">
<input type="hidden" name="userDto.userId" value="0" id="userId" />
<div class="easyui-layout" style="width:100%;height:430px">
	<div region="west" split="true" title="<fmt:message key="common.basicInfo" /> " style="width:350px">
	<div class="lineTableBgDiv">
		<table style="width:100%" class="lineTable" cellspacing="1">
	
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.loginName" /></td>
			<td><input name="userDto.loginName" id="loginName" readonly="readonly" class="easyui-validatebox" validType="loginName" required="true" /></td>
			
		</tr>
		<tr id="resetPassword_tr">
			<td><fmt:message key="label.user.loginPassword" /></td>
			<td>[<a id="link_user_password_reset" ><fmt:message key="common.reset" /></a>]</td>
		</tr>
		
		<tr id="password_tr">
			<td class="formTableTd"><fmt:message key="label.user.loginPassword" /></td>
			<td><input type="password" name="userDto.password" id="password" class="easyui-validatebox" required="true"/></td>
		</tr>
		<tr id="rpassword_tr">
			<td class="formTableTd"><fmt:message key="label.user.comfirmLoginPassword" /></td>
			<td><input type="password" id="rpassword" name="rpassword" class="easyui-validatebox" validType="equalTo['password']" required="true"/></td>
		</tr>
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.userLastName" /></td>
			<td><input name="userDto.firstName" id="firstName" class="easyui-validatebox" required="true"/></td>
		</tr>
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.userFirstName" /></td>
			<td><input name="userDto.lastName" id="lastName" class="easyui-validatebox" required="true"/></td>
		</tr>
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.userOwnerOrg" /></td>
			<td>
				<input id="user_orgName" name="orgName" readonly="readonly" class="easyui-validatebox" required="true"  style="cursor:pointer" class="input"/>
				<input type="hidden" name="userDto.orgNo" id="user_orgNo" />
			</td>
		</tr>
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.userTitle" /></td>
			<td><input name="userDto.job" id="job" /></td>
		</tr>
		<tr>
			<td class="formTableTd"><fmt:message key="label.user.userState" /></td>
			<td><input type="radio" name="userDto.userState" id="userState" value="true" checked="checked" /><fmt:message key="common.enable" /> <input type="radio"
				name="userDto.userState" id="userState1" value="false" /><fmt:message key="common.disable" /></td>
		</tr>
	</table>
	</div>
	
	</div>
	<div region="center" title="<fmt:message key="common.detailInfo" />">
		<div id="userOtherInfo" class="easyui-tabs" fit="true" style="width: 100%; height: 100%;" border="none">
		
			<div title="<fmt:message key="title.user.contactInfo" />">
			
			<div class="lineTableBgDiv" style="width:92%" >
			<table style="width:100%" class="lineTable" cellspacing="1">
		
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.email"  /></td>
					<td><input name="userDto.email" id="email" /></td>
				</tr>
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.mobile"/></td>
					<td><input name="userDto.moblie" id="moblie"  class="easyui-validatebox"/></td>
				</tr>
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.phone" /></td>
					<td><input name="userDto.phone" id="phone"  class="easyui-validatebox" /></td>
				</tr>
				
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.fax"/></td>
					<td><input name="userDto.fax" id="fax"   class="easyui-validatebox" /></td>
				</tr>
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.qqOrMsn" /></td>
					<td><input name="userDto.msn" id="msn" /></td>
				</tr>
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.workAddress" /></td>
					<td><input name="userDto.officeAddress" id="officeAddress" /></td>
				</tr>
				<tr>
					<td class="formTableTd"><fmt:message key="label.user.description" /></td>
					<td><textarea name="userDto.description" id="description"  style="height:50px" /></textarea></td>	
				</tr>
			
			</table>
			</div>
			
			
			</div>
			<div title="<fmt:message key="title.user.userRole" />">
				<div id="roleSet" class="lineTableBgDiv" style="width:92%" >
					<table style="width:100%" class="lineTable" cellspacing="1"></table>
				</div>
			</div>
			<div title="<fmt:message key="title.user.costEngineer" />">
			
			<div class="lineTableBgDiv" style="width:92%" >
			
				<table style="width:100%" class="lineTable" cellspacing="1">
					<tr>
						<td class="formTableTd"><fmt:message key="label.user.costEngineer" /></td>
						<td><input name="userDto.userCost" value="0.00" id="userCost" class="easyui-numberbox" min="0"  precision="2" />&nbsp;
						(<span id="userCost_currency"></span>/<fmt:message key="label.sla.hour" />)
						</td>
					</tr>
					
				</table>
			</div>
			</div>
		</div>
	</div>
	
	<div region="south" style="height:60px;padding:10px">
		<a class="easyui-linkbutton" icon="icon-save" id="link_user_save" href="javascript:itsm.security.user.addUser()"><fmt:message key="common.save" /></a>
	</div>
	
	
</div>
</form>
</div>
</div>



<!-- 搜索用户 -->
<div id="searchUser" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="false" title="<fmt:message key="title.user.searchUser" />" style="width:400px;height:auto">
	<form>
		<div class="lineTableBgDiv">
			<table style="width:100%" class="lineTable" cellspacing="1">
				<tr>
					<td><fmt:message key="label.orgSettings.ownerOrg" /></td>
					<td>
						<input id="user_search_orgName" style="width:96%" readonly />
						<input type="hidden" name="userQueryDto.orgNo" id="user_search_orgNo" />
					</td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.loginName" /></td>
					<td><input name="userQueryDto.loginName" style="width:96%" /></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.userLastName" /></td>
					<td><input name="userQueryDto.firstName" style="width:96%" /></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.userFirstName" /></td>
					<td><input name="userQueryDto.lastName" style="width:96%" /></td>
				</tr>
				<tr>
					<td><fmt:message key="label.user.email" /></td>
					<td><input name="userQueryDto.email" style="width:96%" /></td>
				</tr>
				<tr>
					<td colspan="2">
					<input type="hidden" name="userQueryDto.limit" id="limit" value="45" />
					<a class="easyui-linkbutton" icon="icon-search" id="user_link_search"><fmt:message key="common.search" /></a>
					</td>
				</tr>
			</table>
		</div>
	</form>
</div>

<!-- 角色设置 -->
<div id="roleSet-win" title="<fmt:message key="label.user.roleSettings" />" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" style="width:400px;height:auto">
<form>
	<div id="roleSetInfo" class="lineTableBgDiv">
		<table style="width:100%" class="lineTable" cellspacing="1"></table>
		
		
		<div style="background:#fff;padding-top:10px;padding-bottom:10px">
		<a class="easyui-linkbutton" plain=false icon="icon-save" id="link_roleSet_save"><fmt:message key="common.save" /></a>
		</div>

		
	</div>
</form>

</div>



<!-- 组织设置 -->
<div id="orgSet-win" class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.user.userOwnerOrgSetting" />" style="width:400px; height:auto">
	
	
	
		
	<div id="orgSetInfo" style="text-align:center" class="lineTableBgDiv">
		<form style="margin:0px">
		
			<table style="width:100%" class="lineTable" cellspacing="1">
			
			<tr>
			<td style="width:35%;height:32px">
			<fmt:message key="label.user.userOwnerOrg" />
			</td>
			<td style="width:65%">
			<input id="orgName1" name="orgName1" style="width:96%;cursor:pointer" readonly/>
			<input type="hidden" name="orgNo1" id="orgNo1" />
			<input type="hidden" name="userId1" id="userId1" />
			</td>
			</tr>
			
			<tr>
			<td style="text-align:left;height:32px" colspan="2">
			<a class="easyui-linkbutton" plain=false icon="icon-save" id="link_orgSet_save"><fmt:message key="common.save" /></a> 
			</td>
	
			</tr>
			
			</table>
			
			
			
		</form>
		
		
		
	</div>
</div>





<!-- 新增、编辑机构树-->
<div id="userAddEditOrgTree" class="easyui-window"   closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="title.user.selectOrg" />" style="width:400px;height:380px;padding:5px">
    
    
    
    <div id="userAddEditOrgTreeDiv"></div>
    <div class="easyui-layout" style="width:380px;height:340px;display: none;">
		
		<div region="west" split="true" style="width:350px;">
		 
		</div>
		

		<div region="center" border="false" style="display: none">
		
		<div id="selectOrg" class="easyui-tabs" fit="true" style="width:300px; height:200" >
		
		
			
			<div title="<fmt:message key="title.user.selectCustomer" />">
				<div style="width:100%;padding-top:3px" align="center">
				<table id="userAddEditOrgTree_CustomerGrid"></table>
				<div id="userAddEditOrgTree_CustomerGridPager"></div>
				
				</div>
			
			</div>
			
			
			
			<div title="<fmt:message key="title.user.selectSupplier" />">
			
			<div style="width:100%;padding-top:3px" align="center">
				<table id="userAddEditOrgTree_SupplierGrid"></table>
				<div id="userAddEditOrgTree_SupplierPager"></div>
			</div>
			
			</div>

		
		</div>
		
		</div>
		
	</div>
    
    
   
    
</div>




<!-- 选择组 -->
<div id="userGroup_win" class="easyui-window" closed="true" modal="true"  title="<fmt:message key="title.request.chooseGroup" />" minimizable="false" maximizable="false" collapsible="false" style="width:420px;height:400px;padding:5px;">
<div id="userGroupTree"></div>
</div>













<!-- 导入数据 -->
<div id="importUserDataWindow"  class="easyui-window" closed="true" collapsible="false" minimizable="false" maximizable="false" modal="true" title="<fmt:message key="label.dc.import"/>" style="width:400px;height:auto">
	<form>
   <div class="lineTableBgDiv" >
    <table  class="lineTable"  width="100%" cellspacing="1"> 
        <tr>
            <td width="100px">
            <fmt:message key="label.dc.filePath"/>
        
            </td>
            <td>
           	<input type="file" class="easyui-validatebox input" required="true" id="importUserFile" name="userQueryDto.importFile" onchange="checkFileType(this,'xls')"/>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div style="padding-top:8px;">
                	<a id="searchUserBtn" class="easyui-linkbutton" onclick="itsm.security.user.importUserExcel()" icon="icon-ok"><fmt:message key="label.dc.import"/></a>
                </div>
        </td>
        </tr>
    </table>
    </div>
    </form>
</div>
     <!-- 导出隐藏信息 -->
    <div style="display: none;" id="exportUserWindow">
	   <form action="user!exportUser.action" method="post">
	     <table>
	     <tr>
			<td>						
				<input id="exportUser_loginName" name="userQueryDto.loginName" class="input">
				<input id="exportUser_firstName" name="userQueryDto.firstName" class="input">
				<input id="exportUser_lastName" name="userQueryDto.lastName" class="input">
				<input id="exportUser_email" name="userQueryDto.email" class="input">
				
				<input id="exportUser_sidx" name="sidx" class="input">
				<input id="exportUser_sord" name="sord" class="input">
				<input id="exportUser_page" name="page" class="input">
				<input id="exportUser_rows" name="rows" class="input">
			</td>
		</tr>
	     </table>
	   </form>
    </div>

</div>
