<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ include file="../language.jsp" %>

<script src="../scripts/itsm/snmp/networkManage.js?random=<%=new java.util.Date().getTime()%>"></script>

<div style="padding:3px">
<div class="easyui-layout" fit="true">

<div region="west" split="true" title="<fmt:message key="title.snmp.systemDescription"/>" style="width:300px; padding: 5px;">
	<div id="system">
		<table width="100%" >
			<tr style="display: none">
				<td colspan="2">
					<a class="easyui-linkbutton" icon="icon-reload" id="reload_snmpTrapTest_button"><fmt:message key="label.snmp.startListener"/></a>
					<a class="easyui-linkbutton" icon="icon-reload" id="reload_sendTrap_button"><fmt:message key="label.snmp.sendTrap"/></a>
				</td>
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.connectionState"/></td>
				<td>
					<span id="snmpTestResult_yes" style="color:green;"></span>
					<span id="snmpTestResult_no" style="color: red;"></span>
				</td>
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.currentServer"/></td>
				<td><span id="locHostIp"></span></td>
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemDescription"/></td>
				<td><input name="sysdescr" id="sysdescr" /></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemOID"/></td>
				<td><input name="sysObjectID" id="sysObjectID"/></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemStartTime"/></td>
				<td><input name="sysUpTime" id="sysUpTime" /></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemContactor"/></td>
				<td><input name="sysContact" id="sysContact" /></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemName"/></td>
				<td><input name="sysName" id="sysName" /></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemAddress"/></td>
				<td><input name="sysLocation" id="sysLocation" /></td>	
			</tr>
			<tr>
				<td><fmt:message key="label.snmp.systemServiceCount"/></td>
				<td><input name="sysService" id="sysService"/></td>	
			</tr>
			<tr>
				<td colspan="2" align="right">
				<a class="easyui-linkbutton" icon="icon-reload" id="reload_system_button"><fmt:message key="common.refresh"/></a></td>
			</tr>
		</table>
	</div>
</div>

<div region="center" id="regCenter">
	<div id="sysProperties" class="easyui-tabs" fit="true">
		<div title="<fmt:message key="title.snmp.process"/>" id="process" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_hrSWRunTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="hrSWRunTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.installSoftwares"/>" id="installSoft" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_hrSWInstalledTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="hrSWInstalledTable"></div>
		
		</div>
		<div title="<fmt:message key="title.snmp.service"/>" style="padding: 5px" id="service">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_svSvcTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="svSvcTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.save"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_hrStorage_button"><fmt:message key="common.refresh"/></a></div>
			<div id="hrStorage"></div>
		</div>
		<div title="<fmt:message key="title.snmp.device"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_hrDervice_button"><fmt:message key="common.refresh"/></a></div>
			<div id="hrDervice"></div>
		</div>
		<div title="<fmt:message key="title.snmp.ICMPCount"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_icmp_button"><fmt:message key="common.refresh"/></a></div>
			<div id="icmp"></div>
		</div>
		<div title="<fmt:message key="title.snmp.TCPCount"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_tcp_button"><fmt:message key="common.refresh"/></a></div>
			<div id="tcp"></div>
		</div>
		<div title="<fmt:message key="title.snmp.UDPCount"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_udp_button"><fmt:message key="common.refresh"/></a></div>
			<div id="udp"></div>
		</div>
		<div title="<fmt:message key="title.snmp.SNMPCount"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_snmp_button"><fmt:message key="common.refresh"/></a></div>
			<div id="snmp"></div>
		</div>
		<div title="<fmt:message key="title.snmp.IPAddress"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_ipAddrTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="ipAddrTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.IPRouting"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_ipRouteTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="ipRouteTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.IPMedia"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_ipNetToMediaTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="ipNetToMediaTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.IPCount"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_ipStat_button"><fmt:message key="common.refresh"/></a></div>
			<div id="ipStat"></div>
		</div>
		
		<div title="<fmt:message key="title.snmp.Interface"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_interfaces_button"><fmt:message key="common.refresh"/></a></div>
			<div id="interfaces"></div>
		</div>
		<div title="<fmt:message key="title.snmp.TCPTable"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_tcpTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="tcpTable"></div>
		</div>
		<div title="<fmt:message key="title.snmp.UDPTable"/>" style="padding: 5px">
			<div class="topOperation">
			<a class="easyui-linkbutton" icon="icon-reload" id="reload_udpTable_button"><fmt:message key="common.refresh"/></a></div>
			<div id="udpTable"></div>
		</div>
		
	</div>

</div>


<div region="north" title='<fmt:message key="title.snmp.serverList"/>'split="true" style="height: 200px;">
	<div style="padding: 3px;background-color: #EEEEEE;">
		<span id="scanResult"></span>
		<sec:authorize url="/pages/snmp!scanIp.action">
			<a class="easyui-linkbutton"  icon="icon-search" id="scanIp"><fmt:message key="itsm.snmp.scanServer"/></a>
		</sec:authorize>
		
		<sec:authorize url="/pages/snmp!save.action">
			<a class="easyui-linkbutton"  icon="icon-add" id="add_client"><fmt:message key="itsm.snmp.addServer"/></a>
		</sec:authorize>
		
		<sec:authorize url="/pages/snmp!delete.action">
			<a class="easyui-linkbutton"  icon="icon-cancel" id="delete_client"><fmt:message key="itsm.snmp.deleteServer"/></a>
		</sec:authorize>
			
			<a class="easyui-linkbutton"  icon="icon-reload" id="reload_list"><fmt:message key="itsm.snmp.refreshServer"/></a>
		
	</div>
	<br>
	<table id="client">
	</table>
</div>



<div id="add_client_win" title="<fmt:message key="itsm.snmp.addServer"/>" class="easyui-window" closed="true" collapsible="false" modal="false" minimizable="false" maximizable="false" style="width:300px; height: 150px;padding: 5px;">
		<form>
		<table width="100%">
			<tr>
				<td><fmt:message key="itsm.snmp.serverName"/></td>
				<td><input name="lanIpDTO.hostName" id="client_hostName" /></td>
			</tr>
			<tr>
				<td><fmt:message key="itsm.snmp.serverIP"/>(*)</td>
				<td><input name="lanIpDTO.ipAddress" id="client_ipAddress" />
				<span style="color: red;" id="client_ipAddress_check"></span></td>
			</tr>
			<tr>
				<td colspan="2">
					<br>
					<a class="easyui-linkbutton"  icon="icon-save" id="link_button_client_add"><fmt:message key="common.save"/></a>
				</td>
			</tr>
		</table>
		</form>
	</div>
	
	
	
</div>

</div>