/**
 * 打开Tab，存在则选择
 * @param title
 * @param url
 */
function openTab(title,url){
	
	if ($('#itsmMainTab').tabs('exists',title)){
		
		$('#itsmMainTab').tabs('select',title);
		
	}else {
		$('#itsmMainTab').tabs('add',{
			title:title,
			cache:"false",
 			href:url,
			closable:true
		});
	}

}

/**
 * 关闭选项卡再重新打开.
 * @param title
 * @param url
 */
function refreshTab(title,url){
	
	if ($('#itsmMainTab').tabs('exists',title)){
		
		$('#itsmMainTab').tabs('close',title);
	} 
	
	$('#itsmMainTab').tabs('add',{
		title:title,
		cache:"false",
		href:url,
		closable:true
	});
}

/**
 * 关闭选项卡.
 * @param title
 */
function closeTab(title){
	
	if ($('#itsmMainTab').tabs('exists',title)){
		$('#itsmMainTab').tabs('close',title);
	} 
}


/**
 * 
 * @param title
 * @param method
 */
function selectTab(title,method){
	
	if ($('#itsmMainTab').tabs('exists',title)){
		
		$('#itsmMainTab').tabs('select',title);
		
		method();
		
	} 
}

/**
 * 改变窗口大小时，刷新Tab
 */
function refreshWindow(){
	
	$('.easyui-window').window('close');
	$('#itsmMainTab').tabs('getSelected').panel('refresh');
	
}



/**
 * 打开Tab，存在则选择
 * @param title
 * @param url
 */
function openTabCallback(title,url,callBack){
	
	if ($('#itsmMainTab').tabs('exists',title)){
		
		$('#itsmMainTab').tabs('select',title);
		
		callBack();

	}else {
		
		$('#itsmMainTab').tabs('add',{
			title:title,
			cache:"false",
 			href:url,
			closable:true
		});
	}

}