
function msgAlert(msg,type){
	
	$.messager.alert(i18n['msg_msg'],'<br/>'+msg,type);
	
}

function msgShow(msg,type){

	$.messager.show({
		title:i18n['msg_msg'],
		msg:'<br/>'+msg,
		showType:type
	});
	
	
}

function showAndHidePanel(showId,hiddenId){
	
	 $(hiddenId).hide();
	 $(showId).show();
}

function loadTreeView(treeId,queryUrl,selectNodeMethod){
	
	
	$(treeId).jstree({
		json_data: {
			ajax: {url :queryUrl,cache: false}
		},
		plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]

	})
	.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
	.bind('select_node.jstree',selectNodeMethod);
	
}

//打开进程窗口
function startProcess(){

	$('#processWindow').window('open');
}

//关闭
function endProcess(){
	$('#processWindow').window('close');
}

//设置容器高度
function setPanelHeight(panelId){
	
	var height=document.getElementById("regCenter").style.height;
	height=height.substring(0,height.length-2);
	document.getElementById(panelId).style.height=height-35+"px";
}

//刷新JSTREE
function refreshTree(treeId){
	
	$(treeId).bind('loaded.jstree', function(e,data){data.inst.open_all(-1);}).jstree('refresh',-1); 
}

/**
 * 获取可操作项HTML.
 * @param sec_edit
 * @param sec_delete
 * @returns HTMLStr
 */
function actionFormat(sec_edit,sec_delete){
	
	var HTMLStr='';
	if(sec_edit=='1'){
		HTMLStr+='<a href="javascript:[edit]"><img src="../images/icons/edit.gif"/></a>';
	}
	if(sec_delete=='1'){
		HTMLStr+='<a href="javascript:[delete]" style="margin-left:8px"><img src="../images/icons/delete.gif"/></a>';
	}

	
	return HTMLStr;
}


//验证

$.extend($.fn.validatebox.defaults, {

	required:false,validType:null,missingMessage:i18n['validate_notNull'],invalidMessage:null

});

function DateComparison(date1,date2){
	return Date.parse(date1.replace(/-/g,"/"))<=Date.parse(date2.replace(/-/g,"/"));
}

$.extend($.fn.validatebox.defaults.rules, { 
	
	
	
	email: { 
        validator: function(value){ 
        	
        	var ck=/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/;
        	
        	return ck.test(value);
        }, 
        message: i18n['validate_email']
    },
	
    phone: { 
        validator: function(value){ 
        	
        	var ck  =/^((\+?[0-9]{2,4}\-[0-9]{3,4}\-)|([0-9]{3,4}\-))?([0-9]{5,8})(\-[0-9]+)?$/;
        	return ck.test(value);
        	//return true;
        }, 
        message: i18n['validate_mobile_fax']
    },
    mob:{
    		validator: function(value){ 
    			var ck = /^1[3,5,8,9]\d{9}$/;
    			return ck.test(value);
    		}, 
        message: i18n['validate_mobile_no']  
    },
    money:{
			validator: function(value){ 
				var ck = /^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$/;
				return ck.test(value);
			}, 
	    message: i18n['validate_price']
    },
    count:{
			validator: function(value){ 
				var ck = /^[0-9]*[1-9][0-9]*$/;
				return ck.test(value);
			}, 
			message: i18n['validate_integer'] 
    },
    
    /**验证两个日期比较*/
    DateComparison: {
        validator: function (value, param) {
        	var date1=$('#'+param[0]).val();
        	var date2=value;
        	return DateComparison(date1,date2);
//        	return true;
        },
        message:i18n['error_dateComparison']
    },
	CHS: {
	    validator: function (value, param) {
	        return /^[\u0391-\uFFE5]+$/.test(value);
	    },
	    message: i18n['validate_chinese_letters']
	},
	ZIP: {
	    validator: function (value, param) {
	        return /^[1-9]\d{5}$/.test(value);
	    },
	    message:i18n['validate_ZIPCode']
	},
	QQ: {
	    validator: function (value, param) {
	        return /^[1-9]\d{4,10}$/.test(value);
	    },
	    message: i18n['validate_qq']
	},
	mobile: {
	    validator: function (value, param) {
	    	
	    	var ck = /^1[3,5,8,9]\d{9}$/;
			return ck.test(value);

	    },
	    message: i18n['error_mobile']
	},
	loginName: {
	    validator: function (value, param) {
	        return /^[a-zA-Z0-9][a-zA-Z0-9_/@.-]*$/.test(value);
	    },
	    message: i18n['error_loginName']
	},
	safepass: {
	    validator: function (value, param) {
	        return safePassword(value);
	    },
	    message: i18n['validate_password']
	},
	
	equalTo: {
	    validator: function (value, param) {
	        return value == $('#'+param[0]).val();
	    },
	    message: i18n['error_equalTo']
	},
	number: {
	    validator: function (value, param) {
	        return /^\d+$/.test(value);
	    },
	    message: i18n['validate_number']
	},
	idcard: {
	    validator: function (value, param) {
	        return idCard(value);
	    },
	    message:i18n['validate_IDCard']
	},
	
	persent:{
		
		 validator: function (value) {
		        return value<=100;
		    },
		    message:i18n['validate_persent']
	}


});