$package("itsm.change");
/**  
* @fileOverview 变更管理
* @author tan
* @version 1.0
*/  
/**  
* @author tan  
* @constructor Change  
* @description 变更主列表管理页面
* @since version 1.0  
*/

$import("itsm.config.dataDictionary.dataDictionaryUtil");

itsm.change.change=function(){
	this.loadCIListFalg="0";
	this.htmlId='';
	/**
	 * @description 關聯配置項的ID集合
	 */
	var ciIds='';
	return {
		/**
		 * @description 变更列表
		 */
		changeList:function(){
		
		
		 	var _url='change!findPagerChange.action';
			var _postData={};
			
			if(change_fullSearchFlag=="yes"){//全文检索				
				_url="change!fullSearch.action";
				var fullSearchQueryString=$('#fullSearchKeyWord').val();	  
				$.extend(_postData, {'compassQueryDTO.alias':'Changes','compassQueryDTO.queryString':fullSearchQueryString});			
			}
		
			var params = $.extend({},jqGridParams, {	
				url:_url,
				caption:i18n['title_changeList'],
				postData:_postData,
				colNames:[i18n['title_snmp_id'],i18n['number'],i18n['title'],i18n['category'],i18n['status'],i18n['title_technician'],i18n['priority'],i18n['common_createTime'],i18n['title_creator'],i18n['operateItems']],
				colModel:[
			   		{name:'eno',width:60,sortable:true},
			   		{name:'changeNo',width:150},
			   		{name:'etitle',width:150,formatter:itsm.change.change.changeTitleUrlFrm},
			   		{name:'categoryName',width:150,sortable:false},
			   		{name:'statusName',width:150,sortable:false},
			   		{name:'technicianName',width:150,sortable:false},
			   		{name:'priorityName',width:150,sortable:false},
			   		{name:'createTime',width:150,formatter:timeFormatter,sortable:false},
			   		{name:'creator',width:150,sortable:false},
			   		{name:'act',align:'center',sortable:false,formatter:itsm.change.change.changeActFormatter}
			   	],
			   	ondblClickRow:function(rowId){itsm.change.change.viewChangeInfo(rowId)},
				jsonReader: $.extend(jqGridJsonReader, {id: "eno"}),
				sortname:'eno',
				pager:'#changePager'
			});
			$("#changeGrid").jqGrid(params);
			$("#changeGrid").navGrid('#changePager',navGridParams);
			//列表操作项
			$("#t_changeGrid").css(jqGridTopStyles);
			$("#t_changeGrid").append($('#changeGridToolbar').html());
			//自适应大小
			setGridWidth("#changeGrid","regCenter",10);
			
			change_fullSearchFlag="no";
		},
		/**
		 * @description 变更标题连接
		 */
		changeTitleUrlFrm:function(cellvalue, options, rowObject){
			return '<a href="javascript:itsm.change.change.viewChangeInfo('+rowObject.eno+')">'+cellvalue+'</a>'
			
		},
		/**
		 * @description 操作项
		 */
		changeActFormatter:function(){
			return $('#changeActFormatterDiv').html();
		},
		/**
		 * @description 变更添加
		 */
		changeAddLink:function(){
			itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeAdd.jsp?',i18n['titie_change_add']);
		},
		
		/**
		 * @description 变更详细
		 */
		changeDetails_aff:function(){
			checkBeforeEditGrid('#changeGrid',itsm.change.change.changeDetailsOpt);
		},
		
		changeDetailsOpt:function(rowData){
			itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+rowData.eno,i18n['title_changeInfo']);
		},
		/**
		 * @description 变更编辑
		 */
		changeEditLink:function(rowData){
			itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeEdit.jsp?eno='+rowData.eno,i18n['titie_change_edit']);
		},
		
		/**
		 * @description 编辑
		 */
		change_edit_aff:function(){
			checkBeforeEditGrid('#changeGrid',itsm.change.change.changeEditLink);
		},
		
		/**
		 * @description 删除
		 */
		change_delete_aff:function(){
			checkBeforeDeleteGrid('#changeGrid', itsm.change.change.deleteChange);
		},
		
		/**
		 * @description 执行删除
		 */
		deleteChange:function(rowIds) {
			var _param = $.param({'ids':rowIds},true);
			
			startProcess();
			$.post("change!deleteChange.action", _param, function(){
				
				//重新统计
				itsm.change.changeStats.countChange();
				endProcess();
				$('#changeGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'info');
			}, "json");
		},
		/**
		 * @description 变更详细
		 */
		viewChangeInfo:function(id){
			itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+id,i18n['title_changeInfo']);
		},
		
		/**
		 * @description 根据状态查询
		 */
		getChangeByChangeStatus:function(statusNo){
			$('#statusSearchId').val(statusNo);
			var sdata = $('#statusSearchForm form').getForm();
			var postData = $("#changeGrid").jqGrid("getGridParam", "postData");     
			$.extend(postData, sdata);
			$("#changeGrid").jqGrid('setGridParam',{page:1,url:'change!findPagerChange.action'}).trigger('reloadGrid');
		},
		
		/**
		 * @description 变更搜索
		 */
		openChangeSearchWin:function(){
			
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#change_search_priority');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('changeStatus','#change_search_state');
			$('#change_search_win').window('open');
		},
		
		/**
		 * @description 变更搜索操作
		 */
		changeSearchOpt:function(){
			var _url = 'change!findPagerChange.action';	
			var sdata = $('#change_search_win form').getForm();
			var postData = $("#changeGrid").jqGrid("getGridParam", "postData");     
			$.extend(postData, sdata);
			$('#changeGrid').jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
		},
		
		
		/**
		 * @description 关联配置项
		 */
		
		changeRelatedCIWin:function(id){
			htmlId=id;
			itsm.change.change.selectCiTree();
			if(loadCIListFalg=="0"){
				itsm.change.change.selectCIList();
				loadCIListFalg="1";
			}
			
			$('#change_relatedCI_win_add').window('open');
	
		},
		/**
		 * @description 配置项分類树
		 */
		selectCiTree:function(){
			$("#change_add_relatedCI_tree").jstree({
				"json_data":{
				    ajax: {url : "configuration!getConfigurationCategoryTree.action",cache:false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]
				})
				.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
				.bind('select_node.jstree',itsm.change.change.selectCiTree_selectNode);
			
		},
		/**
		 * @description 配置項分類樹節點事件
		 */
		selectCiTree_selectNode:function(e,data){
			var id=data.rslt.obj.attr('cno');
			var name=data.rslt.obj.attr('cname');
			var categoryType=data.rslt.obj.attr('categoryType');
			if(id=="1"){
				id=0;
			}
			$("#changeAddCiGrid").jqGrid('setGridParam',{page:1,url:'ci!cItemsFind.action?ciQueryDTO.categoryNo='+id}).trigger('reloadGrid');
		},
		/**
		 * @description 配置項列表
		 */
		selectCIList:function(){
			var params = $.extend({},jqGridParams,{
				caption:i18n['ci_configureItemList'],
				url:'ci!cItemsFind.action',
				colNames:['ID',i18n['category'],i18n['number'],i18n['name'],i18n['status'],i18n['operateItems']],
				colModel:[
						  {name:'ciId',width:30},
						  {name:'categoryName',width:100},
						  {name:'cino',width:100},
						  {name:'ciname',width:150},
						  {name:'status',width:60},
						  {name:'act',width:60,sortable:false,align:'center',formatter:itsm.change.change.selectCiOkActFormatter}
						  ],
				toolbar: [false,"top"],
				jsonReader: $.extend(jqGridJsonReader,{id: "ciId"}),
				sortname:'ciId',
				pager:'#changeAddCiPager'
			});
			$("#changeAddCiGrid").jqGrid(params);
			$("#changeAddCiGrid").navGrid('#changeAddCiPager',navGridParams);
		},
		/**
		 * @description 格式化操作項操作按鈕
		 */
		selectCiOkActFormatter:function(cell,opt,data){
			return $('#selectCICheckDiv_add').html();
		},
		
		/**
		 * @description 选中的配置项
		 */
		check_add_change_ci:function(selectMethod){
			var rowIds = $('#changeAddCiGrid').getGridParam('selarrrow');
			if(rowIds==''){
				
				msgAlert(i18n['msg_atLeastChooseOneData'],'info');
			}
			else{
				selectMethod(rowIds);
			}
		},
		
		/**
		 * @description 选中的配置项
		 */
		
		add_change_ci_aff:function(){
			itsm.change.change.check_add_change_ci(itsm.change.change.add_change_ci_opt);
		},
		
		/**
		 * @description 把選中的配置項添加到table并顯示
		 */
		add_change_ci_opt:function(rowIds){
			ciIds='';
			for(var i=0;i<rowIds.length;i++){
				var rowData=$("#changeAddCiGrid").getRowData(rowIds[i]);
				if ( $("#"+htmlId+" #tr-"+rowData.ciId).length==0 ) {
					$('<tr id="tr-'+rowData.ciId+'"><td align="center">'+rowData.cino+'</td><td align="center"><input type="hidden" name="changeDTO.cis" value='+rowData.ciId+' /><a href=javascript:itsm.common.utility.tabUtility.reOpenTab("ci!findByciId.action?ciEditId='+rowData.ciId+'","'+i18n['ci_configureItemInfo']+'")>'+rowData.ciname+'</a></td><td align="center">'+rowData.categoryName+'</td><td align="center">'+rowData.status+'</td><td align="center"><a onclick=itsm.change.change.removeEx('+rowData.ciId+',"'+htmlId+'")>['+i18n['deletes']+']</a></td></tr>').appendTo('#'+htmlId+' table');
				}	
			}
			$('#change_relatedCI_win_add').window('close');
			
		},
		/**
		 * @description 刪除關聯配置項元素行
		 * @param id:要刪除所在TABLE ID
		 */
		removeEx:function(id,htmlId1){
			htmlId=htmlId1;
			msgShow(i18n['deleteSuccess'],'info');
			$('#'+htmlId+' #tr-'+id).remove();
			var ciIds1='';
			var ss1 = ciIds.split(",");
			for(var i=0;i<ss1.length;i++){
				if(ss1[i]==id){
				}else{
					if(ciIds1==''){
						ciIds1=ss1[i]
					}else{
						ciIds1=ciIds1+","+ss1[i]
					}
				}	
			}
			ciIds=ciIds1;
		},
		
		/**
		 * 导出数据到Excel
		 */
		exportChangeData:function(){
			var extype=$("#exportChangeData").val();
			if(extype=="view"){
				itsm.change.change.exportChangeView();
			}
			if(extype=="all"){
				
				msgAlert(i18n["msg_dc_comfirmExport"],"question");
			}
		},
	
		exportChangeView:function(){	
			var sdata = $('#change_search_win form').getForm();
			var chData = $("#changeGrid").jqGrid("getGridParam", "postData");   		
			for(i in sdata)
			{    	   		
				if(sdata[i]!=""&&sdata[i]!=null){
					if(i=='queryDTO.changeNo')$('#exportChange_changeNo').val(sdata[i]); 
					if(i=='queryDTO.changeTitle')$('#exportChange_changeTitle').val(sdata[i]);
					if(i=='queryDTO.statusName')$('#exportChange_statusName').val(sdata[i]);
					if(i=='queryDTO.priorityName')$('#exportChange_priorityName').val(sdata[i]);
					}
			}
			 
			$('#exportChange_sidx').val(chData.sidx);
			$('#exportChange_sord').val(chData.sord);
			$('#exportChange_page').val(chData.page);
			$('#exportChange_rows').val(chData.rows);
	       
			$("#exportChangeWindow form").submit();
			
		},
	
	
		init:function(){
			
			 $("#changeManage_loading").hide();
			 $("#changeManage_panel").show();
			
			
		 	itsm.change.change.changeList();
			
			//页面事件
			$('#change_add_but').click(itsm.change.change.changeAddLink);
			$('#change_edit_but').click(itsm.change.change.change_edit_aff);
			$('#change_delete_but').click(itsm.change.change.change_delete_aff);
			$('#change_search_but').click(itsm.change.change.openChangeSearchWin);
			$('#doSearchChangeBut').click(itsm.change.change.changeSearchOpt);
			
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('changeStatus','#changeStatusQuery');
			
			$('#searchChange_categoryName').click(function(){//选择分类
        		itsm.config.categoryManage.eventCategoryTree.changeCategory('#searchChange_categoryName','#searchChange_categoryNo');
        	});
	
			
		}	
	}

}();

$(document).ready(itsm.change.change.init);