$package("itsm.change")
/**  
* @fileOverview 变更添加
* @author tan
* @version 1.0
*/  
/**  
* @author tan  
* @constructor Change Add  
* @description 变更添加
* @since version 1.0 
*/
$import("itsm.change.changeStats");
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.config.categoryManage.eventCategoryTree");
$import("itsm.security.organizationTreeUtil");
$import("itsm.security.userUtil");
$import("itsm.cm.configureItemUtil");
$import("itsm.problem.problemDetails");



itsm.change.changeAdd=function(){
	/**
	 * @description 变更action
	 */
	this.changeOpt='saveChange';
	var assigneeGroupNo;
	var assigneeGroupName;
	
	return {
		/**
		 * @description 变更添加
		 */
		changeAddOpt:function(){
			if($('#changeAddDiv').form('validate')){
				var frm = $('#changeAddDiv form,#changeRelatedCIShow form').serialize();
				var url = 'change!'+changeOpt+'.action';
				startProcess();
				$.post(url,frm, function(data){
					endProcess();
					//关闭新增TAB
					closeTab(i18n['titie_change_add']);
					itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+data,i18n['title_changeInfo']);
					$('#changeGrid').trigger('reloadGrid');
					msgShow(i18n['saveSuccess'],'show');
					itsm.change.changeStats.countChange();

					itsm.problem.problemDetails.getRelatedChange();//刷新问题关联变更tab
					
				});
			}
		},
		
		/**
		 * @description 选择技术员
		 */
		selectTheTechnician:function(){	
			itsm.security.userUtil.selectUser('#change_add_technicianName','#change_add_technicianNo','','loginName');
		},
		
		/**
		 * @description 选择变更分类.
		 */
		selectChangeCategory:function(){
			
			itsm.config.categoryManage.eventCategoryTree.showSelectTree('#change_category_select_win'
					,'#addChangeCategoryTree'
					,'Change'
					,'#change_add_categoryName'
					,'#change_add_categoryNo');
			
		},


		/**
		 * @description 服务目录
		 */
		changeEffectServiceWin:function(){
			$('#changeEffectServiceShow tbody').html('');
			$.post('sd!findAllServiceDirectory.action',function(data){
				if(data!=null){
					if(data.length>0){
						for(var i=0;i<data.length;i++){
							$('<tr><td><input type="checkbox" name="changeDTO.serviceDirectory" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#changeEffectServiceShow table');
						}
					}
				}
			})
			$('#change_effectService_win').window('open');
		},
		
		
		
		/**
		 * 加载关联请求，关联变更.
		 */
		initRelatedRequestsAndProblems:function(){
			
			$('#relatedReuqestAndProblem_hidden').html('');
			
			if(pnos!="" && pnos!=null){
				
				if(pnos.indexOf(",")==-1){	
					
					
					itsm.change.changeAdd.findSubmitProblem(pnos);//查找问题
					
					$('<input type="hidden" name="changeDTO.problemNos" value="'+pnos+'">').appendTo("#relatedReuqestAndProblem_hidden");	
				}else{
					var arr=pnos.split(',');
					for(var i=0;i<arr.length;i++){
						$('<input type="hidden" name="changeDTO.problemNos" value="'+arr[i]+'">').appendTo("#relatedReuqestAndProblem_hidden");
					}
				}
			}
			
			if(enos!="" && enos!=null){
				if(enos.indexOf(",")==-1){	
					itsm.change.changeAdd.findSubmitRequest(enos);//查找请求
					$('<input type="hidden" name="changeDTO.requestNos" value="'+enos+'">').appendTo("#relatedReuqestAndProblem_hidden");
				}else{				
					var arr2=enos.split(',');
					for(var ii=0;ii<arr2.length;ii++){	
						$('<input type="hidden" name="changeDTO.requestNos" value="'+arr2[ii]+'">').appendTo("#relatedReuqestAndProblem_hidden");
					}
				}
			}
		},
		
		
		/**
		 * 查找问题信息.
		 */
		
		findSubmitProblem:function(eno){
			
			if(eno!=null && eno!=''){
				
				$.post('problem!problemEdit.action','eno='+eno,function(data){
					if(data!=null){
						$('#add_changeTitle').val(data.etitle);
						$('#add_changeDesc').val(data.edesc);
					}
				});
			
			}
		},
		
		
		/**
		 * 查找请求信息
		 */
		findSubmitRequest:function(eno){
			
			if(eno!=null && eno!=''){
			
				$.post('request!showRequestInfo.action','eno='+eno,function(data){
					if(data!=null){
						$('#add_changeTitle').val(data.etitle);
						$('#add_changeDesc').val(data.edesc);
					}
				});
			
			}
		},
		
		
		
		/**
		 * 变更指派组.
		 */
		change_selectAssginGroup:function(orgNoPut,orgNamePut){
			
			itsm.security.organizationTreeUtil.showAll_2('#changeAssginGroup_win','#change_assginGroupTree',orgNamePut,orgNoPut);
		},
		
		
		init:function(){
			
			showAndHidePanel("#changeAdd_panel","#changeAdd_loading");	
			
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#change_add_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#change_add_seriousness');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#change_add_priority');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('changeStatus','#change_add_status');
			
			//页面事件
			$('#changeAdd_save_but').click(itsm.change.changeAdd.changeAddOpt);
			
			itsm.change.changeAdd.changeEffectServiceWin();
			
			//绑定
			$('#addchange_add_ref_ci_btn').click(function(){
				itsm.cm.configureItemUtil.selectCISM('#changeRelatedCIShow');
				
			});
			
			/**
			 * 加载关联请求，关联变更.
			 */
			setTimeout(function(){
				itsm.change.changeAdd.initRelatedRequestsAndProblems();
			},0);
			
			
			
		}	
	}

}();

$(document).ready(itsm.change.changeAdd.init);