$package("itsm.change");
/**  
* @fileOverview 变更审批管理主函数
* @author tan
* @version 1.0
*/  
/**  
* @author tan  
* @constructor 变更审批管理主函数
* @description 变更审批管理主函数
* @since version 1.0 
*/ 
itsm.change.changeApproval=function(){
	this.loadCabMemberFlag="0";
	this.cabId;
	return{
		/**
		 * @description 审批状态
		 */
		agreedFormatter:function(cellvalue, options, rowObject){
			if(cellvalue==null){
				return ""
			}else if(cellvalue){
				return i18n['title_agree']
			}else{
				return i18n['title_refused']
			}	
		},
		/**
		 * @description 变更审批列表
		 */
		changeApprovalGrid:function(){
			var params = $.extend({},jqGridParams, {	
				url:'change!findAllApporveComment.action?acDTO.eno='+$('#changeInfo_eno').val(),
				caption:i18n['title_changeApproveMemberList'],
				colNames:['ID',i18n['title_approveMember'],i18n['title_comments'],i18n['title_approverResult'],i18n['time'],i18n['operateItems']],
				colModel:[
				    {name:'acId',align:'left',width:45},
				    {name:'approver',align:'left',width:180},
			   		{name:'comment',align:'left',width:120},
			   		{name:'agreed',width:150,formatter:itsm.change.changeApproval.agreedFormatter},
			   		{name:'approverTime',width:150,formatter:timeFormatter},
			   		{name:'act', width:80,align:'center',formatter:itsm.change.changeApproval.approvalActFormatter}
				],	
				toolbar: [true,"top"],
				jsonReader: $.extend(jqGridJsonReader,{id: "acId"}),
				sortname:'acId',
				pager:'#changeApprovalPager'
			});
			$("#changeApprovalGrid").jqGrid(params);
			$("#changeApprovalGrid").navGrid('#changeApprovalPager',navGridParams);
			//列表操作项
			$("#t_changeApprovalGrid").css(jqGridTopStyles);
			$("#t_changeApprovalGrid").append($('#approvalGridToolbar').html());
			changeInfoGrids.push('#changeApprovalGrid');
		},
		
		approvalActFormatter:function(cell,opt,data){
			return $('#approvalActFormatterDiv').html();
		},
		/**
		 * @description 选择CAB成员窗口
		 */
		
		selectCabMemberWin:function(){
			$('#cabMemberOption').html('');
			
			
			var url = 'cab!findPagerCAB.action';
			var cabIdFlag="0";
			$.post(url,'rows=1000',function(res)
			{
				if(res.data!=null){
					if(res.data.length>0){
						for(var i=0;i<res.data.length;i++){
							if(cabIdFlag=="0"){
								cabId=res.data[i].cabId;
								cabIdFlag="1";
							}
							$('<option value="'+res.data[i].cabId+'">'+res.data[i].cabName+'</option>').appendTo('#cabMemberOption');
						}
					}
				}
			});
			if(loadCabMemberFlag=="0"){
				
				loadCabMemberFlag="1"
			}
			setTimeout(function(){itsm.change.changeApproval.changeInfoCabMemberGrid(cabId)},500)
			$('#selectCABMember').window('open');
		},
		
		selectChange:function(value){
			$("#selectCABMemberGrid").jqGrid('setGridParam',{page:1,url:'cab!findCABMember.action?cabId='+value}).trigger('reloadGrid');
		},
		
		/**
		 * @description CAB成员列表
		 */
		changeInfoCabMemberGrid:function(cabId){
			if($("#selectCABMemberGrid").html()==''){
				var params = $.extend({},jqGridParams, {	
					url:'cab!findCABMember.action?cabId='+cabId,
					caption:i18n['title_cabMember_list'],
					colNames:[i18n['number'],i18n['title_cab_approvalMember'],i18n['title_cab_delegateMember'],i18n['description'],i18n['operateItems'],'',''],
					colModel:[
				   		{name:'cabMemberId',width:40},
				   		{name:'approvalMember',width:100},
				   		{name:'delegateMember',width:80},
				   		{name:'desc',width:100},
				   		{name:'act',width:50,align:'center',formatter:itsm.change.changeApproval.changeInfoCabMemberActFormatter},
				   		{name:'approvalMemberId',hidden:true},
				   		{name:'delegateMemberId',hidden:true}
				   	],		
					jsonReader: $.extend(jqGridJsonReader, {id: "cabMemberId"}),
					sortname:'cabMemberId',
					toolbar:[true,"top"],
					pager:'#selectCABMemberPager'
				});
				$("#selectCABMemberGrid").jqGrid(params);
				$("#selectCABMemberGrid").navGrid('#selectCABMemberPager',navGridParams);
				//列表操作项
				$("#t_selectCABMemberGrid").css(jqGridTopStyles);
				$("#t_selectCABMemberGrid").append($('#selectCABMemberToolBar').html());
			}else{
				$("#selectCABMemberGrid").trigger('reloadGrid');
			}
	
		},
		changeInfoCabMemberActFormatter:function(cell,opt,data){
			return $('#selectApprovalCheck').html();
		},
	
		/**@description 删除审批人员*/
		deleteApproval_aff:function()
		{
			checkBeforeDeleteGrid('#changeApprovalGrid', itsm.change.changeApproval.deleteApproval_opt);
		},
		deleteApproval_opt:function(ids){
			var _params = $.param({'ids':ids},true);
			$.post("change!deleteApproveComment.action", _params+'&acDTO.eno='+$('#changeInfo_eno').val(), function(){
				$('#changeApprovalGrid').trigger('reloadGrid');	
			}, "json");
		},
		/**
		 * @description 选定变更审批人同
		 */
		select_approval_aff:function(){
			checkBeforeEditGrid('#selectCABMemberGrid', itsm.change.changeApproval.add_approval_opt);
		},
		
		/**
		 * @description 变更审批人保存
		 */
		add_approval_opt:function(rowIds) {
			$.post("change!addApproveComment.action",'acDTO.approverNo='+rowIds.approvalMemberId+'&acDTO.alternateNo='+rowIds.delegateMemberId+'&acDTO.eno='+$('#changeInfo_eno').val(), function(){
				$('#selectCABMember').window('close');
				$('#changeApprovalGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'info');
			}, "json");
		},
	
		init:function(){
			
		}
	}
}();
$(document).ready(itsm.change.changeApproval.init);