$package("itsm.change");
/**  
* @fileOverview 变更编辑
* @author tan
* @version 1.0
*/  
/**  
* @author tan  
* @constructor Change Edit  
* @description 变更编辑
* @since version 1.0 
*/ 
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.config.categoryManage.eventCategoryTree");
$import("itsm.security.organizationTreeUtil");
$import("itsm.security.userUtil");
$import("itsm.cm.configureItemUtil");


itsm.change.changeEdit=function(){
	
	var assigneeGroupNo;
	var assigneeGroupName;
	this.rowHTML='<tr id="ref_ci_CIID">'+
	'<td align="center">CINO</td>'+
	'<td align="center"><input type="hidden" name="changeDTO.cis" value="CIID" />'+
	'<a href=javascript:itsm.common.utility.tabUtility.reOpenTab("ci!findByciId.action?ciEditId=CIID","CIDETAIL_TITLE")>CINAME</a>'+
	'</td>'+
	'<td align="center">CATEGORYNAME</td>'+
	'<td align="center">CISTATUS</td>'+
	'<td align="center"><a onclick=itsm.cm.configureItemUtil.removeRow("#ref_ci_CIID")>DELETE</a></td>'+
	'</tr>';
	return {
		
		changeSetInput:function(value,inputId){
			if(value!=null)
				$(inputId).val(value);
			else
				$(inputId).val('');
		},
		/**
		 * @description 加载变更编辑数据
		 */
		loadChangeEdit:function(){
			$.post('change!changeEdit.action','queryDTO.eno='+eno,function(data){
				if(data!=null){
					$('#edit_changeEno').val(data.eno);
					$('#edit_changeNo').val(data.changeNo);
					$('#edit_changeTitle').val(data.etitle);
					itsm.change.changeEdit.changeSetInput(data.edesc,'#edit_changeDesc');
					itsm.change.changeEdit.changeSetInput(data.technicianNo,'#change_edit_technicianNo');
					
					itsm.change.changeEdit.changeSetInput(data.technicianName,'#change_edit_technicianName');
					itsm.change.changeEdit.changeSetInput(data.categoryNo,'#change_edit_categoryNo');
					itsm.change.changeEdit.changeSetInput(data.categoryName,'#change_edit_categoryName');
					itsm.change.changeEdit.changeSetInput(timeFormatter(data.planStartTime),'#change_edit_planStartTime');
					itsm.change.changeEdit.changeSetInput(timeFormatter(data.planEndTime),'#change_edit_planEndTime');
					//itsm.change.changeEdit.changeSetInput(data.creator,'#edit_creator');
					itsm.change.changeEdit.changeSetInput(data.orgNo,'#change_edit_orgNo');
					itsm.change.changeEdit.changeSetInput(data.orgName,'#change_edit_orgName');
					itsm.change.changeEdit.changeSetInput(data.statusNo,'#edit_statusNo');
					itsm.change.changeEdit.changeSetInput(data.priorityNo,'#change_edit_priority');
					itsm.change.changeEdit.changeSetInput(data.effectRangeNo,'#change_edit_effectRange');
					itsm.change.changeEdit.changeSetInput(data.seriousnessNo,'#change_edit_seriousness');

					if(data.cigDTO!=null){
						htmlId='changeEditRelatedCIShow';
						var cigDTO=data.cigDTO
						for(var i=0;i<cigDTO.length;i++){
							var status='';
							if(cigDTO[i].status!=null)
								status=cigDTO[i].status
								
								
							var newRowHTML=rowHTML.replace(/CIID/g,cigDTO[i].ciId)
							.replace(/CINO/g,cigDTO[i].cino)
							.replace(/CIDETAIL_TITLE/g,i18n['ci_configureItemInfo'])
							.replace(/CINAME/g,cigDTO[i].ciname)
							.replace(/CATEGORYNAME/g,cigDTO[i].category)
							.replace(/CISTATUS/g,cigDTO[i].status)
							.replace(/DELETE/g,i18n['deletes'])
							.replace(/null/g,'');
							
							$(newRowHTML).appendTo('#changeEditRelatedCIShow table');
						}
					}
					itsm.change.changeEdit.changeEditEffectServiceWin(data.sdgDTO);
					
				}
			})
		},
		
		/**
		 * @description 服务目录
		 */
		changeEditEffectServiceWin:function(data1){
			$('#changeEditEffectServiceShow tbody').html('');
			$.post('sd!findAllServiceDirectory.action',function(data){
				if(data!=null && data.length>0){
					for(var i=0;i<data.length;i++){
						if(data1!=null && data1.length>0){
							var result=false;
							for(var j=0;j<data1.length;j++){
								if(data1[j].serviceDirectoryId==data[i].serviceDirectoryId){
									result=true;
								}
							}
							if(result){
								$('<tr><td><input type="checkbox" name="changeDTO.serviceDirectory" value='+data[i].serviceDirectoryId+' checked /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#changeEditEffectServiceShow table');
							}else{
								$('<tr><td><input type="checkbox" name="changeDTO.serviceDirectory" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#changeEditEffectServiceShow table');
							}
						}else{
							$('<tr><td width="30%"><input type="checkbox" name="changeDTO.serviceDirectory" value='+data[i].serviceDirectoryId+' /></td><td>'+data[i].serviceDirectoryName+'</td></tr>').appendTo('#changeEditEffectServiceShow table');
						}
					}
				}
			})
		},
		/**
		 * @description 选择变更分类.
		 */
		selectEditChangeCategory:function(){
			
		
			itsm.config.categoryManage.eventCategoryTree.showSelectTree('#change_edit_category_select_win'
					,'#editChangeCategoryTree'
					,'Change'
					,'#change_edit_categoryName'
					,'#change_edit_categoryNo');
		},
		
		
		
		
		/**
		 * @description 选择技术员
		 */
		selectEditTechnician:function(){	
			itsm.security.userUtil.selectUser('#change_edit_technicianName','#change_edit_technicianNo','','loginName');
		},
		
		
		
		

		/**
		 * @description 变更编辑
		 */
		changeEditOpt:function(){
			if($('#changeEditDiv').form('validate')){
				var frm = $('#changeEditDiv form,#changeEditRelatedCIShow form').serialize();
				var url = 'change!editChangeBaseInfo.action';
				$.post(url,frm, function(){
					closeTab(i18n['titie_change_edit']);
					itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+eno,i18n['title_changeInfo']);
					$('#changeGrid').trigger('reloadGrid');
					msgShow(i18n['editSuccess'],'show');
					itsm.change.changeStats.countChange();
					
				});
			}
			
		},
		
		
		/**
		 * 选择指派组.
		 */
		change_edit_selectAssginGroup:function(){
			
			itsm.security.organizationTreeUtil.showAll_2('#changeAssginGroup_edit_win','#change_edit_assginGroupTree','#change_edit_orgName','#change_edit_orgNo');	
		
		},
		
		
		/**
		 * @description 返回变更列表
		 */
		returnChangeList:function(){
			itsm.common.utility.tabUtility.addTab(i18n['title_changeManage'],'../pages/change/change.jsp');
		},
		init:function(){
			
			showAndHidePanel("#changeEdit_panel","#changeEdit_loading");	
			
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('effectRange','#change_edit_effectRange');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('seriousness','#change_edit_seriousness');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('priority','#change_edit_priority');
			itsm.config.dataDictionary.dataDictionaryUtil.loadOptionsByCode('changeStatus','#change_edit_status');
			
			
			
			$('#changeAdd_edit_but').click(itsm.change.changeEdit.changeEditOpt);
			
			//绑定
			$('#editchange_add_ref_ci_btn').click(function(){
				
				itsm.cm.configureItemUtil.selectCISM('#changeEditRelatedCIShow');
				
			});
			setTimeout(function(){
				itsm.change.changeEdit.loadChangeEdit();
			},0)
			
			
			
		}	
	}
}();

$(document).ready(itsm.change.changeEdit.init);
