$package("itsm.change")
/**  
* @fileOverview 变更详细主函数
* @author tan
* @version 1.0
*/  
/**  
* @author tan  
* @constructor 变更详细主函数
* @description 变更详细主函数
* @since version 1.0 
*/ 
$import("itsm.change.changeApproval");
$import("itsm.change.relatedRequest");
$import("itsm.change.changeTask");
$import("itsm.security.userUtil");
$import("itsm.change.changeEventCost");
$import("itsm.tools.eventAttachment");
$import("itsm.change.changeProblem");




itsm.change.changeInfo=function(){
	//加载标识
	this.loadChangeTaskFlag="0";
	this.loadRelatedRequestFlag="0";
	this.loadWorkDetailsFlag="0";
	this.loadChangeApprovalFlag="0";
	this.optLogHtml;
	this.loadAttachementTag="0";
	this.loadRelatedProblem="0";
	//变更详细页面数据列表集合
	this.changeInfoGrids=[];
	return {
		changeTabClick:function(){
	        $('#changeInfoTab').tabs({
	            onSelect:itsm.change.changeInfo.changeTabClickEvents
	        });
		},
		changeTabClickEvents:function(title){
			if(title==i18n["title_request_task"]){
				if(loadChangeTaskFlag=="0"){
					var changeEventTask=new eventTask($('#changeInfo_eno').val(),'change');
					changeEventTask.eventTaskGrid();
					loadChangeTaskFlag="1";
				}	
			}
			if(title==i18n['title_relatedRequest']){
				if(loadRelatedRequestFlag=="0"){
					itsm.change.relatedRequest.relatedRequestList();
					loadRelatedRequestFlag="1";
				}	
			}
			
			if(title==i18n['title_request_timeDetail']){
				if(loadWorkDetailsFlag=="0"){
					var changeEventCost=new eventCost($('#changeInfo_eno').val(),'change');
					changeEventCost.eventCostGrid();
					loadWorkDetailsFlag="1";
				}	
			}
			if(title==i18n['title_changeApproval']){
				if(loadChangeApprovalFlag=="0"){
					itsm.change.changeApproval.changeApprovalGrid();
					loadChangeApprovalFlag="1";
				}	
			}
			if(title==i18n['title_request_history']){
				var changeHistoryRecord=new historyRecord('changeHistoryRecord',$('#changeInfo_eno').val(),'itsm.change');
				changeHistoryRecord.showHistoryRecord();
			}
			
			if(title==tab_relatedProblem && loadRelatedProblem=="0"){
				itsm.change.changeProblem.showGrid('#changeRelatedProblemGrid',$('#changeInfo_eno').val());
				loadRelatedProblem="1"
			}
			
			if(title==i18n['title_changePlan']){
				
				
			}
			
			
			if(title==i18n["attachment"]){
				
				if(loadAttachementTag=="0"){
					itsm.tools.eventAttachment.showEventAttachment('show_change_effectAttachment',$('#changeInfo_eno').val(),'itsm.change');
					loadAttachementTag="1";
				}
				
			}
		},
		
	
		

		
		/**
		 * 变更计划编辑显示与隐藏
		 */
		showOrHidd:function(id1,id2){
			$("#"+id1).attr("class","hidd");
			$("#"+id2).attr("class","show");
		},
		/**
		 * 变更计划保存
		 */
		changePlanSave:function(name,id1,id2,info,text){
			var frm = $('#'+name+' form,#changePlan_comm form').serialize();
			var url = 'change!editChange.action';
			$.post(url,frm, function(){
				itsm.change.changeInfo.showOrHidd(id1,id2);
				$('#'+info).html($('#'+text).val());
			});
		},
		
		/**
		 * @description 打开动作窗口
		 */
		openChangeActionWin:function(div){
			$('#'+div).window('open');
		},
		/**
		 * 指派技术员操作
		 */
		assingeeTechnician_opt:function(){
			
			if($('#assingeeTechnician_win').form('validate')){
				var frm = $('#assingeeTechnician_win form,#changeActionComm form').serialize();
				startProcess();
				$.post('change!changeAction.action',frm+'&historyRecordDto.logDetails='+$('#assingeeTechnician_remark').val(), function(){
					endProcess();
					$('#assingeeTechnician_win').window('close');
					itsm.change.changeInfo.reOpenChangeInfo();
					msgShow(i18n['saveSuccess'],'show');
				});
			}
		},
		
		/**
		 * 制定变更计划操作
		 */
		startChangePlan_opt:function(){
			var frm = $('#startChangePlan_win form,#changeActionComm form').serialize();
			startProcess();
			$.post('change!changeAction.action',frm+'&historyRecordDto.logDetails='+$('#startChangePlan_remark').val(), function(){
				endProcess();
				$('#startChangePlan_win').window('close');
				itsm.change.changeInfo.reOpenChangeInfo();
				msgShow(i18n['saveSuccess'],'show');
			});
		},
		
		/**
		 * 提交审批
		 */
		submitApprover_opt:function(){
			var frm = $('#submitApprover_win form,#changeActionComm form').serialize();
			
			$.post('change!changeApproveMemberExist.action','changeDTO.eno='+$('#changeInfo_eno').val(),function(data){
				if(data){
					startProcess();
					$.post('change!changeAction.action',frm+'&historyRecordDto.logDetails='+$('#submitApprover_remark').val(), function(){
						endProcess();
						$('#submitApprover_win').window('close');
						itsm.change.changeInfo.reOpenChangeInfo();
						msgShow(i18n['saveSuccess'],'show');
					});
				}else{
					msgAlert(i18n['err_changeApproverNotNull'],'info');
				}
			});
		},
		
		
		/**
		 * 成员审批变更窗口
		 */
		memberApprover_win:function(pid){
			
			$.post('upload!getCurrentPiMyTask.action?processId='+pid,function(data){
				if(data!=null){
					$('#memberApprover_taskId').val(data[0].id);
					$('#memberApprover_approver').val(data[0].assignee);
					$('#memberApprover_win').window('open');
				}else{
					
				}
			})
		},
	
		/**
		 * 成员审批变更
		 */
		memberApprover_opt:function(agreed){
			var logDetails='';
			if(agreed=='true'){
				logDetails='&historyRecordDto.logDetails='+i18n['title_agree']
			}
			if(agreed=='false'){
				logDetails='&historyRecordDto.logDetails='+i18n['title_refused']
			}
			logDetails=logDetails+'<br>'+$('#memberApprover_comment').val();
			var frm = $('#memberApprover_win form,#changeActionComm form').serialize();
			startProcess();
			$.post('change!changeAction.action',frm+'&acDTO.agreed='+agreed+logDetails, function(){
				endProcess();
				$('#memberApprover_win').window('close');
				itsm.change.changeInfo.reOpenChangeInfo();
				msgShow(i18n['saveSuccess'],'show');
			});
		},
		
		
		
		/**
		 * 实施完成操作
		 */
		implementComplete_opt:function(){
			var frm = $('#implementComplete_win form,#changeActionComm form').serialize();
			startProcess();
			$.post('change!changeAction.action',frm+'&historyRecordDto.logDetails='+$('#implementComplete_remark').val(), function(){
				endProcess();
				$('#implementComplete_win').window('close');
				itsm.change.changeInfo.reOpenChangeInfo();
				msgShow(i18n['saveSuccess'],'show');
			});
		},
		
		
		/**
		 * 变更复审操作
		 */
		review_opt:function(action){
			var logDetails='';
			if(action=='close'){
				logDetails='&historyRecordDto.logDetails='+i18n['title_changeComplete']
			}
			if(action=='goBack'){
				logDetails='&historyRecordDto.logDetails='+i18n['title_backImplementComplete']
			}
			logDetails=logDetails+'<br>'+$('#review_remark').val();
			var frm = $('#review_win form,#changeActionComm form').serialize();
			startProcess();
			$.post('change!changeAction.action',frm+'&changeDTO.action='+action+logDetails, function(){
				endProcess();
				$('#review_win').window('close');
				itsm.change.changeInfo.reOpenChangeInfo();
				msgShow(i18n['saveSuccess'],'show');
			});
		},
		
		/**
		 * 重新打开详细信息页面.
		 */
		reOpenChangeInfo:function(){
			itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+$('#changeInfo_eno').val(),i18n['title_changeInfo']);
		},
		
		
		
		
		//数据列表伸展
	
		changeInfoPanelCollapseAndExpand:function(){
			
			 $(changeInfoGrids).each(function(i, g) {
			      setGridWidth(g, 'changeInfoTab', 10);
			 });
		},
		//数据列表自动伸展
		fitChangeInfoGrids:function(){
			
			$('#changeInfo_west,#changeInfo_center').panel({
				onCollapse:itsm.change.changeInfo.changeInfoPanelCollapseAndExpand,
				onExpand:itsm.change.changeInfo.changeInfoPanelCollapseAndExpand
			});
		},
		
		change_uploadifyUpload:function(){
			$('#change_effect_file').uploadifyUpload();
		},


		
		
		
		
		init:function(){
			showAndHidePanel("#changeInfo_panel","#changeInfo_loading");
			itsm.change.changeInfo.changeTabClick();
			
			
			
			
			
			$('#fullsearch_change_related_event_btn').click(function(){
				
				itsm.compass.fullSearch.openFullsearchWindow(queryString,'change');		
			});
			
			
			
			setTimeout(function(){
				//getUploader('上传文件文本ID','上传后返回的信息字符串','显示上传成功的附件','');
				getUploader('#change_effect_file','#change_effect_attachmentStr','#change_effect_success_attachment','change_effect_fileQueue', function(){
					itsm.tools.eventAttachment.saveEventAttachment('show_change_effectAttachment',$('#changeInfo_eno').val(),'itsm.change','change_effect_attachmentStr');
				});
			},0);
			
		
			setTimeout(itsm.change.changeInfo.fitChangeInfoGrids,0);
			
			$('#change_assignee_technicianName').click(function(){itsm.security.userUtil.selectUser('#change_assignee_technicianName','#change_assignee_technicianNo','','loginName')})
			
			$('#changeInfo_edit_but').click(function(){
				itsm.common.utility.tabUtility.reOpenTab('../pages/change/changeEdit.jsp?eno='+$('#changeInfo_eno').val(),i18n['titie_change_edit']);
			});
		}	
	}
}();

$(document).ready(itsm.change.changeInfo.init);