$package("itsm.change");
/**  
* @fileOverview 变更关联问题
* @author Van 
* @version 1.0
*/  
/**  
* @author Van  
* @constructor Van
* @description 变更关联问题
* @since version 1.0  
*/ 

$import('itsm.problem.problemUtil');

itsm.change.changeProblem=function(){
	

	return{
		
		/**
		 * @description 关联请求列表
		 */
		showGrid:function(grid,eno){
			
			
			var t_grid=grid.replace('#',"#t_");
			var grid_pager=grid+'Pager';
			var grid_toolbar=grid+'Toolbar';
			
			var params = $.extend({},jqGridParams, {
	                url: 'change!getChangeRelatedProblem.action?eno='+eno,
	                caption:i18n['problem_grid'],
	                colNames:[i18n['problem_code'],i18n['title'],i18n['category'],i18n['title_request_assignTo'],i18n['priority'],i18n['problem_reporter'],i18n['problem_reportTime'],i18n['status'],''],
	                colModel:[ {name:'problemNo',width:10},
	                           {name:'etitle',width:20},
	                           {name:'categoryName',width:10,align:'center'},
	                           {name:'assignName',width:10,align:'center'},
	                           {name:'priorityName',width:10,align:'center'},
	                           {name:'CreatedByName',width:10,align:'center'},
	                           {name:'createdOn',width:10,align:'center',formatter:timeFormatter},
	                           {name:'statusName',width:10,align:'center'},
	                           {name:'eno',hidden:true}
	                           ],
	                jsonReader: $.extend({},jqGridJsonReader, {
	                    id: "eno"
	                }),
	                sortname: 'eno',
	                ondblClickRow:function(rowId){
	                	refreshTab(i18n['probelm_detail'],'problem!findProblemById.action?eno='+rowId);
	                },
	                pager:grid_pager
	            });
	            $(grid).jqGrid(params);
	            $(grid).navGrid(grid_pager, navGridParams);
	            //列表操作项
	            $(t_grid).css(jqGridTopStyles);
	            $(t_grid).append($(grid_toolbar).html());

			
			$(grid+'_add').click(function(){//添加关联问题
				itsm.problem.problemUtil.openSelectWindow(function(rowIds){
					itsm.change.changeProblem.addRelatedProblem(grid,rowIds,eno);
				});
			});
			
			//移除关联问题
			$(grid+'_remove').click(function(){
				
				itsm.change.changeProblem.removeRelatedProblem(grid,eno);
			});
			
			//全文检索
			$(grid+'_fullsearch').click(function(){
				
				itsm.problem.problemUtil.fullsearchOpenwindow(queryString,function(rowIds){
					itsm.change.changeProblem.addRelatedProblem(grid,rowIds,eno);
				});
				
			});
			
		
			
			
			
		},
		
		/**
		 * @description 移除关联请求
		 */
		removeRelatedProblem:function(grid,eno){
			checkBeforeDeleteGrid(grid, function(rowIds){
				var _param = $.param({'ids':rowIds,'eno':eno},true);
				$.post("change!deleteChangeRelatedProblem.action", _param, function(){
					$(grid).trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'info');
				}, "json");
				
			});
		},
		
		/**
		 * @description 选定选中的问题
		 */
		addRelatedProblem:function(grid,rowIds,eno){
			
			var _param = $.param({'ids':rowIds,'eno':eno},true);
			$.post('change!addChangeRelatedProblem.action',_param,function(){
				msgShow(i18n['saveSuccess'],'show');
				$(grid).trigger('reloadGrid');
			});
		}
		
	};
}();