$package("itsm.change");
/**  
* @fileOverview 关联请求管理
* @author Tan 
* @version 1.0
*/  
/**  
* @author Tan  
* @constructor Van
* @description 关联请求管理
* @since version 1.0  
*/ 
$import('itsm.request.requestUtil');

itsm.change.relatedRequest=function(){
	
	this.changeRelatedRequest_changeNo=$('#changeInfo_eno').val();
	
	return{
		
		/**
		 * @description 关联请求列表
		 */
		relatedRequestList:function(){
	
			var params=$.extend({},jqGridParams,{
				caption:i18n['title_relatedReuqestList'],
				url:'change!getChangeRelatedRequest.action?eno='+$('#changeInfo_eno').val(),
				colNames:['',i18n['common_id'],i18n['common_title'],i18n['category'],i18n['requester'],i18n['title_request_assignToTC'],i18n['priority'],i18n['common_state'],i18n['common_createTime'],i18n['title_request_SLAState']],
				colModel:[
				          {name:'eno',width:40},
						  {name:'requestCode',width:70},
						  {name:'etitle',width:100},
						  {name:'ecategoryName',width:50,align:'center',sortable:false},
						  {name:'createdByName',width:40,align:'center',sortable:false},
						  {name:'assigneeName',width:55,align:'center',sortable:false},
						  {name:'priorityName',width:35,align:'center',sortable:false},
						  {name:'statusName',width:35,align:'center',sortable:false},
						  {name:'createdOn',width:80,align:'center',formatter:timeFormatter,sortable:false},
						  {name:'slaState',width:50,align:'center',sortable:false}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "eno"}),
				sortname:'eno',
				pager:'#relatedRequestPager'
			});
			$("#relatedRequestGrid").jqGrid(params);
			$("#relatedRequestGrid").navGrid('#relatedRequestPager',navGridParams);
			//列表操作项
			$("#t_relatedRequestGrid").css(jqGridTopStyles);
			$("#t_relatedRequestGrid").append($('#relatedRequestGridToolbar').html());
			changeInfoGrids.push('#relatedRequestGrid');
			
			
			$('#relatedRequestGrid_add').click(function(){//添加关联请求
				itsm.request.requestUtil.openSelectWindow(function(rowIds){
					itsm.change.relatedRequest.addRelatedRequest(rowIds);
				});
			});
			
			//移除关联请求
			$('#relatedRequestGrid_remove').click(itsm.change.relatedRequest.removeRelatedRequest);
			
			
			$('#change_relatedRequestGrid_fullsearch').click(function(){//搜索类似的请求
				
				itsm.request.requestUtil.fullsearchOpenwindow(queryString,function(rowIds){
					itsm.change.relatedRequest.addRelatedRequest(rowIds);
				});
			});
			
			
			
		},
		
		/**
		 * @description 移除关联请求
		 */
		removeRelatedRequest:function(){
			checkBeforeDeleteGrid('#relatedRequestGrid', function(rowIds){
				var _param = $.param({'ids':rowIds,'eno':changeRelatedRequest_changeNo},true);
				$.post("change!deleteChangeRelatedRequest.action", _param, function(){
					$('#relatedRequestGrid').trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'info');
				}, "json");
				
			});
		},
		
		/**
		 * @description 选定选中的请求
		 */
		addRelatedRequest:function(rowIds){
			
			var _param = $.param({'ids':rowIds,'eno':changeRelatedRequest_changeNo},true);
				$.post('change!addChangeRelatedRequest.action',_param,function(){
					msgShow(i18n['saveSuccess'],'show');
					$('#relatedRequestGrid').trigger('reloadGrid');
				});
		}
		
	}
}();