 /**  
 * @fileOverview 配置项分类树
 * @author tan
 * @version 1.0  
 */  

 /**  
 * @author tan  
 * @constructor CategoryTree
 * @description 配置项分类树
 * @since version 1.0 
 */  

$package('itsm.cm');

itsm.cm.ciCategoryTree=function(){

	return {
		/**
		 * @description 配置项分类树结构
		 */
		configureItemTree:function(treeWin1,treeDiv1,sid1,sname1){
			treeWin=treeWin1;
			treeDiv=treeDiv1;
			sid=sid1;
			sname=sname1;
			$('#'+treeWin1).window('open');
			$("#"+treeDiv1).jstree({
				"json_data":{
				    ajax: {url : "configuration!getConfigurationCategoryTree.action"}
				},
				"plugins" : ["themes", "json_data", "ui", "crrm", "cookies", "types", "hotkeys"]
				})
				.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
				.bind('select_node.jstree',function(e, data){
					var cno=data.rslt.obj.attr('cno');
					if(cno=='1'){}
					else{
						$("#"+sid1).val(data.rslt.obj.attr('cno'));
						$("#"+sname1).val(data.rslt.obj.attr('cname'));
						$('#'+treeWin1).window('close');
					}
				});
	
		},
		
		autoUpdateEavAttrCiCategoryTree:function(treeWin,treeDiv,categoryNoId,categoryNameId,showAttrId){
			$('#'+treeWin).window('open');
			$("#"+treeDiv).jstree({
				"json_data":{
				    ajax: {url : "configuration!getConfigurationCategoryTree.action"}
				},
				"plugins" : ["themes", "json_data", "ui", "crrm", "cookies", "types", "hotkeys"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e, data){
				var cno=data.rslt.obj.attr('cno');
				$("#"+categoryNoId).val(data.rslt.obj.attr('cno'));
				$("#"+categoryNameId).val(data.rslt.obj.attr('cname'));
				itsm.cm.ciCategoryTree.showAttributet(data.rslt.obj.attr('categoryType'),showAttrId);
				$('#'+treeWin).window('close');
			});
			
		},
		
		
		showAttributet:function(eavId,showAttrId){
			$('#'+showAttrId+' table').html('');
			$('#ciNotExtendedInfo').html('');
			if(!isNaN(eavId)){
				$.post('ci!attributeList.action','eavNo='+eavId,function(data){
					if(data!=null && data.length>0){
						for(var i=0;i<data.length;i++){

							if(data[i].attrType=="String")	
								$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-datebox' /></td></tr>")
							else if(data[i].attrType="Date")	
								$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-datebox' /></td></tr>")
							else if(data[i].attrType="Integer")
								$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-numberbox' min='0' maxlength='9' /></td></tr>")
							else if(data[i].attrType="Double")	
								$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-numberbox' precision='3' /></td></tr>")
							else if(data[i].attrType="Lob")
								$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><textarea  style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] ></textarea></td></tr>")
						}
					}else{
						$('#'+showAttrId+' table').append("<tr><td style=color:red >"+i18n['label_notExtendedInfo']+"</td></tr>")
					}
				})
			}else{
				$('#'+showAttrId+' table').append("<tr><td style=color:red >"+i18n['label_notExtendedInfo']+"</td></tr>")
			}
		},
		defaultShowAttributet:function(ciCategoryId,showAttrId){
			if(ciCategoryId!=null && ciCategoryId!=''){
				$('#'+showAttrId+' table').html('');
				
				$.post('configuration!findCICategoryById.action','categoryNo='+ciCategoryId,function(data){
					if(data!=null && data.categoryType!=null){
						if(!isNaN(data.categoryType)){
							$.post('ci!attributeList.action','eavNo='+data.categoryType,function(data){
								if(data!=null && data.length>0){
									for(var i=0;i<data.length;i++){

										if(data[i].attrType=="String")	
											$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-datebox' /></td></tr>")
										else if(data[i].attrType="Date")	
											$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-datebox' /></td></tr>")
										else if(data[i].attrType="Integer")
											$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-numberbox' min='0' maxlength='9' /></td></tr>")
										else if(data[i].attrType="Double")	
											$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><input style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] class='easyui-numberbox' precision='3' /></td></tr>")
										else if(data[i].attrType="Lob")
											$('#'+showAttrId+' table').append("<tr><td>"+data[i].attrAsName+"</td><td><textarea  style=width:85% name=ciDto.attrVals['"+data[i].attrName+"'] ></textarea></td></tr>")
									}
								}else{
									$('#'+showAttrId+' table').append("<tr><td style=color:red >"+i18n['label_notExtendedInfo']+"</td></tr>")
								}
							})
						} 
					}
				});
			}
			
			
		},
		/**
		 * @description 清空选择
		 */
		cleanSelect:function(treeWin1,sid1,sname1){
			$('#'+sid1).val('');
			$('#'+sname1).val('');
			$('#'+treeWin1).window('close');
		}
	}
}();