$package("itsm.cm"); 

/**  
 * @fileOverview 配置项列表主函数
 * @author yctan
 * @version 1.0  
 */  
 /**  
 * @author yctan  
 * @constructor 配置项列表主函数
 * @description 配置项列表主函数
 * @date 2010-11-17
 * @since version 1.0 
 */  


$import('itsm.cm.ciCategoryTree');
$import("itsm.security.userUtil");
itsm.cm.configureItem=function(){
	 
	var _categoryNo=""; 
	var _categoryName=""; 
	return{
		/**@description 配置项*/
		ciNameUrlFrm:function(cellvalue, options, rowObject){
			return '<a href="JavaScript:itsm.cm.configureItem.configureInfo('+rowObject.ciId+')">'+cellvalue+'</a>'
			
		},
		/**@description 配置项列表*/	
		createList:function(){
			var params = $.extend({},jqGridParams,{
				caption:i18n['ci_configureItemList'],
				url:'ci!cItemsFind.action?ciQueryDTO.poNo=',
				colNames:['ID',i18n['category'],i18n['lable_ci_assetNo'],i18n['name'],i18n['productType'],i18n['serialNumber'],i18n['status'],i18n['use'],i18n['location'],i18n['barcode'],i18n['brands'],i18n['supplier'],i18n['purchaseDate'],i18n['arrivalDate'],i18n['purchaseNo'],i18n['owner'],i18n['lifeCycle'],i18n['warrantyDate'],i18n['warningDate'],i18n['operateItems']],
				colModel:[
						  {name:'ciId',width:20},
						  {name:'categoryName',width:80,sortable:false},
						  {name:'cino',width:80},
						  {name:'ciname',width:120,formatter:itsm.cm.configureItem.ciNameUrlFrm},
						  {name:'model',width:80},
						  {name:'serialNumber',width:80},
						  {name:'status',width:45},
						  {name:'userName',width:45},
						  {name:'loc',width:80},
						  {name:'barcode',hidden:true},
						  {name:'brandName',width:45,hidden:true},
						  {name:'supplierName',hidden:true,width:50},
						  {name:'buyDate',width:65,formatter:timeFormatter},
						  {name:'arrivalDate',width:35,formatter:timeFormatter,hidden:true},
						  {name:'poNo',width:50,hidden:true},
						  {name:'owner',width:50,hidden:true},
						  {name:'lifeCycle',width:50,hidden:true},
						  {name:'warranty',width:50,hidden:true},
						  {name:'warningDate',width:35,formatter:timeFormatter,hidden:true},
						  {name:'act', width:80,sortable:false,align:'center',formatter:itsm.cm.configureItem.configureItemGridFormatter}
						  ],
				ondblClickRow:function(rowId){itsm.cm.configureItem.configureInfo(rowId)},
				jsonReader: $.extend(jqGridJsonReader, {id: "ciId"}),
				sortname:'ciId',
				pager:'#ciPager'
			});
			$("#configureGrid").jqGrid(params);
			$("#configureGrid").navGrid('#ciPager',navGridParams);
			//列表操作项
			$("#t_configureGrid").css(jqGridTopStyles);
			$("#t_configureGrid").append($('#CIGridToolbar').html());
			setGridWidth("#configureGrid","regCenter",9);

		},	
		/**@description 动作格式化*/	
		configureItemGridFormatter:function(){
			return $('#configureItemFrmBarDiv').html();
		},
		/**@description 刷新相应的配置项分类列*/	
		refreshCIGrid:function(categoryNo,name,categoryType){
			
			resetForm('#configureSearchForm');
			$('#ci_s_categoryNo').val(categoryNo);
			$('#ci_s_categoryName').val(name);
			
			itsm.cm.configureItem.assyCISearch();
			
		},
		/**@description 新增页面*/	
		addConfigureItem:function(){
			var ci_s_categoryName_v=encodeURIComponent($('#ci_s_categoryName').val());
			itsm.common.utility.tabUtility.reOpenTab('ci!configureItemAdd.action?+categoryName='+ci_s_categoryName_v+'&categoryType='+_categoryType+'&categoryNo='+$('#ci_s_categoryNo').val(),i18n['ci_addConfigureItem']);
		},
		
		/**
		 * @description 判断是否选择要编辑的数据
		 */
		editConfigureItem_toolbar_edit_aff:function(){
			checkBeforeEditGrid('#configureGrid', itsm.cm.configureItem.editConfigureItem);
		},
		
		/**@description 打开编辑页页面*/
		editConfigureItem:function(rowData){
			itsm.common.utility.tabUtility.reOpenTab('ci!configureItemEdit.action?ciEditId='+rowData.ciId+'&categoryType='+_categoryType,i18n['ci_editConfigureItem']);
		},
		/**@description 判断是否要删除数据*/
		configureItem_toolbar_delete_aff:function()
		{
			checkBeforeDeleteGrid('#configureGrid', itsm.cm.configureItem.delConfigureItem);
		},
		/**@description 删除并刷新列表*/
		delConfigureItem:function(ids){
			var _params = $.param({'ids':ids},true);
			$.post("ci!cItemsDel.action", _params, function(data){
				
				msgShow(i18n['deleteSuccess'],'show');
				$('#configureGrid').trigger('reloadGrid');
			}, "json");
		},
					
		/**
		 * @description 判断是否选择要查看详细的配置项数据
		 */
		showConfigureItem__edit_aff:function(){
			checkBeforeEditGrid('#configureGrid', itsm.cm.configureItem.showConfigureItem);
		},
		/**
		 * @description 配置项详细页面
		 */
		showConfigureItem:function(rowData){
			itsm.cm.configureItem.configureInfo(rowData.ciId);
		},
		/**@description 打开详细信息页面*/
		configureInfo:function(ciId){
			itsm.common.utility.tabUtility.reOpenTab('ci!findByciId.action?categoryType='+_categoryType+'&ciEditId='+ciId,i18n['ci_configureItemInfo']);
		},		
		/**@description 状态 ,品牌,位置,供应商下拉框数据*/
		ci_s_selectData:function(){
			$('#ci_s_statusAdd,#ci_s_brandAdd,#ci_s_locAdd,#ci_s_providerAdd').html('');
			$.post("ci!findStaLocBraSupList.action", function(data) {
	            $.each(data.dictionaryItemsStatusList,function(i,item){
	                $("<option value='"+item.dcode+"'>"+item.dname+"</option>").appendTo('#ci_s_statusAdd');
	            });
	            $.each(data.dictionaryItemsBrandList,function(i,item){
	                $("<option value='"+item.dcode+"'>"+item.dname+"</option>").appendTo('#ci_s_brandAdd');
	            });
	            $.each(data.dictionaryItemsLocList,function(i,item){
	                $("<option value='"+item.dcode+"'>"+item.dname+"</option>").appendTo('#ci_s_locAdd');
	            });
	            $.each(data.dictionaryItemsProviderList,function(i,item){
	                $("<option value='"+item.dcode+"'>"+item.dname+"</option>").appendTo('#ci_s_providerAdd');
	            });
	        },"json");	
		},
		/**@description 打开搜索窗口*/
		searchConfigureItemWin:function(){
			itsm.cm.configureItem.ci_s_selectData();
			$('#configureSearchWin').window('open');
		},
		
		/**@description 组合搜索*/
		assyCISearch:function(){
			var s_configName=$('#ci_s_categoryName').val();
			var sdata=$('#configureSearchWin form').getForm();
			var postData = $("#configureGrid").jqGrid("getGridParam", "postData");
			$.extend(postData,sdata);  
			var _url = 'ci!cItemsFind.action';		
			$('#configureGrid').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
			return false;
		},
		
		/**
		 * 导出数据到Excel
		 */
		exportConfigureData:function(){
			var extype=$("#exportConfigureData").val();
			if(extype=="view"){
				itsm.cm.configureItem.exportConfigureView();
			}
			if(extype=="all"){
				msgAlert(i18n["msg_dc_comfirmExport"],"question");
			}
		},
		exportConfigureView:function(){
			var sdata = $('#configureSearchWin form').getForm();
			var confData = $("#configureGrid").jqGrid("getGridParam", "postData");
			$('#exportConf_sidx').val(confData.sidx);
			$('#exportConf_sord').val(confData.sord);
			$('#exportConf_page').val(confData.page);
			$('#exportConf_rows').val(confData.rows);
			$("#configureSearchWin form").submit();
		},
	
		//初始化数据
		init:function(){
			
			 $("#configureItem_loading").hide();
			 $("#configureItem_content").show();
			
			//配置项列表
			itsm.cm.configureItem.createList();
			
			$('#search_useName').click(function(){itsm.security.userUtil.selectUser('#search_useName','','','fullName')});
			$('#search_owner').click(function(){itsm.security.userUtil.selectUser('#search_owner','','','fullName')});
		}
	};
 }();
 //加载初始化数据
 $(document).ready(itsm.cm.configureItem.init);