$package("itsm.cm") 
/**  
 * @fileOverview 配置项添加
 * @author tan 
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor configureItemAdd
 * @description 配置项添加
 * @date 2010-11-17
 * @since version 1.0 
 */
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.security.userUtil");

itsm.cm.configureItemAdd=function(){

	
	return{
		
		/**@description 保存到数据库*/
		saveConfigureItem:function(){
			if($('#configureItemAdd_panel form').form('validate')){
				var ci_add_cino=$.trim($('#ci_add_cino').val());
				var _params = $('#configureItemAdd_panel form').serialize();
				$.post('ci!existCIByCiNo.action','ciQueryDTO.cino='+ci_add_cino,function(data){
					if(data){
						msgAlert(i18n['err_ciNoExist'],'info');
					}else{
						$.post('ci!cItemSave.action', _params, function(){
							closeTab(i18n['ci_addConfigureItem']);	
							selectTab(i18n['ci_configureItemAdmin'],function(){
								$('#configureGrid').trigger('reloadGrid');
							});
							$('#configureGrid').trigger('reloadGrid');
							msgShow(i18n['saveSuccess'],'show');
						})
					}
				});
			}
	
		},
		/**@description 配置项分类选择窗口打开*/
		focusInit:function(){
			configureItemTree();
			$('#configureItemAddCategory').window('open');
		},

		
		/**
		 * @description 选择请求者.
		 */
		selectCICreator:function(userName){
			itsm.security.userUtil.selectUser(userName,'','','fullName');

		},
		
		returnConfigureItemList:function(){
			itsm.common.utility.tabUtility.addTab(i18n['ci_configureItemAdmin'],'../pages/cm/configureItem.jsp');
		},
		
		//初始化数据
		init:function(){
			
			$("#configureItemAdd_loading").hide();
			$("#configureItemAdd_panel").show();
			
			//实例化附加上传
			setTimeout(function(){
				getUploader('#addConfigureItem_uploadAttachments','#addConfigureItem_attachments','#addConfigureItem_uploadedAttachments','addConfigureItem_fileQueue');
			},0)
			
			$('#ci_add_useName').click(function(){itsm.security.userUtil.selectUser('#ci_add_useName','','','fullName')});
			$('#ci_add_owner').click(function(){itsm.security.userUtil.selectUser('#ci_add_owner','','','fullName')});
			
			//新增
			$('#itemAddSave').click(function(){
				itsm.cm.configureItemAdd.saveConfigureItem();
			});
			itsm.cm.ciCategoryTree.defaultShowAttributet($('#ci_add_categoryNo').val(),'ci_add_eavAttributet');
			
		}
	};
 }(); 
 //加载初始化数据
 $(document).ready(itsm.cm.configureItemAdd.init);