$package('itsm.cm');
/**  
 * @fileOverview 配置项分类树.
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 
 * @description 配置项分类树主函数.
 * @date 2010-04-28
 * @since version 1.0 
 * @returns
 * @param select
 */
$import("itsm.cm.configureItem");
itsm.cm.configureItemCategory=function(){
	return {
		
		/** @description 显示配置项分类树*/
		showConfigureItemCategory:function(){
			$("#configureItemCategoryTree").jstree({
				"json_data":{
				    ajax: {url : "configuration!getConfigurationCategoryTree.action",cache: false}
				},
				"plugins" : ["themes", "json_data", "ui", "crrm", "cookies", "types", "hotkeys"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',itsm.cm.configureItemCategory.configureItemCategoryTree_selectNode);
		},
		
		/**@description 配置项树 */
		configureItemCategoryTree_selectNode:function(e, data){
			
			var _parent = data.inst._get_parent();
			var _categoryNo=data.rslt.obj.attr('cno');
			var _categoryName=data.rslt.obj.attr('cname');
			var categoryType=data.rslt.obj.attr('categoryType');
			
			var url='../pages/cm/configureItem.jsp?id='+_categoryNo+'&categoryType='+_categoryName;
			if(_parent==-1){
				_categoryNo='';
				_categoryName='';
				url='../pages/cm/configureItem.jsp'
			}

			
			$('#ci_s_categoryNo').val(_categoryNo);
			$('#ci_s_categoryName').val(_categoryName);

			
			if ($('#itsmMainTab').tabs('exists',i18n['ci_configureItemAdmin']))
			{
				$('#itsmMainTab').tabs('select',i18n['ci_configureItemAdmin']);
				itsm.cm.configureItem.refreshCIGrid(_categoryNo,_categoryName,categoryType);
			} 
			else 
			{
				$('#itsmMainTab').tabs('add',{
					title:i18n['ci_configureItemAdmin'],
					cache:"false",
		 			href:url,
					closable:true
				});
			}
		}
	}
	
}();
