$package("itsm.cm") 
/**  
 * @fileOverview 配置项添加
 * @author tan 
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor configureItemAdd
 * @description 配置项添加
 * @date 2010-11-17
 * @since version 1.0 
 */
$import("itsm.config.dataDictionary.dataDictionaryUtil");
$import("itsm.security.userUtil");

itsm.cm.configureItemEdit=function(){
	//加载标识
	this.loadAttachmentFlag="0";
	
	return{
		
		editConfigureItems:function(){
			
			if($('#configureItemEdit_form').form('validate')){
				
				var _params = $('#configureItemEdit_panel form').serialize();
				$.post('ci!cItemUpdate.action',_params,function(data){
					closeTab(i18n['ci_editConfigureItem']);
					selectTab(i18n['ci_configureItemAdmin'],function(){
						$('#configureGrid').trigger('reloadGrid');
					});
					msgShow(i18n['editSuccess'],'show');
					
				});
			}	
		},
		/**@description 配置项分类选择窗口打开*/
		focusInit:function(){
			configureItemTree();
			$('#configureItemEditCategory').window('open');
		},
		tabClick:function(){
			
	        $('#configureItemEditSlarule').tabs({
	            onSelect:itsm.cm.configureItemEdit.tabClickEvents  
	        });
		},
		
		/**@description 点击tab后，根据tab标题加载不同的数据*/
		tabClickEvents:function(title){
			if(title==i18n['attachment']){
				if(loadAttachmentFlag=="0"){
					itsm.cm.configureItemEdit.getCiAttachmentByCiId($('#editCiId').val());
				}
			}
		},
		/**@description 查找配置项附件信息*/
		getCiAttachmentByCiId:function (ciId)
		{
			$('#editConfigureItem_oldUploadedAttachments').html('');
			if(ciId==undefined){}else{
				var url = 'ci!getAttachmentByCiId.action?ciEditId='+ciId;
				$.post(url,function(res)
				{
					var arr=res;
					if(arr!=null){
						for(var i=0;i<arr.length;i++){
							var file=arr[i].url;
							var fileName=file.substring(file.lastIndexOf("/")+1);
							var fileFix=fileName.substring(fileName.indexOf("."));
							var iconUrl="<img src='../images/attachicons/";
							if(fileFix==".rar"){
								iconUrl=iconUrl+"rar.gif'";
							}
							if(fileFix==".zip"){
								iconUrl=iconUrl+"zip.gif'";
							}
							if(fileFix==".gif"||fileFix==".jpg"||fileFix==".bmp"||fileFix==".png"){
								iconUrl=iconUrl+"image.gif'";
							}
							if(fileFix==".doc"||fileFix==".docx"||fileFix==".xls"||fileFix==".ppt"){
								iconUrl=iconUrl+"msoffice.gif'";
							}
							if(fileFix==".pdf"){
								iconUrl=iconUrl+"pdf.gif'";
							}
							if(fileFix==".swf"){
								iconUrl=iconUrl+"flash.gif'";
							}
							else{
								iconUrl=iconUrl+"unknown.gif'";
							}
							iconUrl=iconUrl+" width='14px' height='14px'/>&nbsp;";
							$('#editConfigureItem_oldUploadedAttachments').append("<span id=att_"+arr[i].aid+">"+iconUrl+"<a target='_blank' href=attachment!download.action?downloadAttachmentId="+arr[i].aid+">"+arr[i].attachmentName+"</a>&nbsp;&nbsp;<a href=JavaScript:itsm.cm.configureItemAdd.deleteAttachement('editConfigureItem_oldUploadedAttachments','"+ciId+"','"+arr[i].aid+"')>"+i18n['deletes']+"</a><br/></span>");
			
						}
					}
				});
				}
		},
		/**@description 删除附件*/
		deleteAttachement:function(id,kid,aid){
			var _url = "ci!deleteAttachement.action?ciEditId="+kid+"&aid="+aid;
			$.post(_url,function(){
				$('#att_'+aid).remove();
				msgShow(i18n['deleteSuccess'],'show');
			});
		},
		/**
		 * @description 选择请求者.
		 */
		selectCICreator:function(userName){
			itsm.security.userUtil.selectUser(userName,'','','fullName');

		},
		
		returnConfigureItemList:function(){
			itsm.common.utility.tabUtility.addTab(i18n['ci_configureItemAdmin'],'../pages/cm/configureItem.jsp');
		},
		
		//初始化数据
		init:function(){
			
			$("#configureItemEdit_loading").hide();
			$("#configureItemEdit_panel").show();
			
			//实例化附加上传
			setTimeout(function(){
				getUploader('#editConfigureItem_uploadAttachments','#editConfigureItem_attachments','#editConfigureItem_oldUploadedAttachments','editConfigureItem_fileQueue');
			},0)

			itsm.cm.configureItemEdit.tabClick();
			$('#ci_edit_useName').click(function(){itsm.security.userUtil.selectUser('#ci_edit_useName','','','fullName')});
			$('#ci_edit_owner').click(function(){itsm.security.userUtil.selectUser('#ci_edit_owner','','','fullName')});
			
//			$('#ci_categoryName').click(itsm.cm.configureItemAdd.focusInit);
//			//新增
//			$('#itemAddSave').click(function(){
//				itsm.cm.configureItemAdd.saveConfigureItem();
//			});
			//编辑
			$('#itemEditSave').click(function(){
				itsm.cm.configureItemEdit.editConfigureItems();
			});
//			itsm.cm.ciCategoryTree.defaultShowAttributet($('#ci_add_categoryNo').val(),'ci_add_eavAttributet');
			
		}
	};
 }(); 
 //加载初始化数据
 $(document).ready(itsm.cm.configureItemEdit.init);