$package('itsm.cm');
/**  
 * @fileOverview this script is for "webapp/pages/configureItem/configureItemInfo.jsp"
 * @author jack
 * @version 1.0  
 */  
 /**  
 * @author jack  
 * @constructor configureItemInfo
 * @description this script is for "webapp/pages/configureItem/configureItemInfo.jsp"
 * @date 2010-09-29
 * @since version 1.0 
 */

$import("itsm.cm.configureItemUtil");
$import("itsm.cm.getConfig");
itsm.cm.configureItemInfo=function(){
	//加载标识
	this.loadRelevanceCIFlag="0";
	this.loadHistoryCallFlag="0";
	this.loadHistoryProblemFlag="0";
	this.loadHistoryChangeFlag="0";
	this.loadInstallSoftFlag="0";
	//变更详细页面数据列表集合
	this.configureItemInfoGrids=[];
	return{
		/**@description 配置信息tab面板*/
		//为tab点击绑定事件
		configureInfoTab:function(){
	        $('#configureItemInfoTab').tabs({
	            onSelect:itsm.cm.configureItemInfo.configureInfoTabClickEvents  
	        });
		},
		/**@description 点击tab后，根据tab标题加载不同的数据*/
		configureInfoTabClickEvents:function(title){
			if(title==i18n['relatedCI']){
				if(loadRelevanceCIFlag=="0"){
					itsm.cm.configureItemInfo.relevanceCI($('#configureCiInfoId').val());
					loadRelevanceCIFlag="1";
				}else{
				}
			}
			if(title==i18n['historyRequest']){
				if(loadHistoryCallFlag=="0"){
					itsm.cm.configureItemInfo.historyCall();
					loadHistoryCallFlag="1"
				}else{
				}
			}
	
			if(title=="历史问题"){
				if(loadHistoryProblemFlag=="0"){
					//itsm.cm.configureItemInfo.historyProblem();
					loadHistoryProblemFlag="1"
				}else{
				}
			}
			if(title==i18n['title_historyChange']){
				if(loadHistoryChangeFlag=="0"){
					itsm.cm.configureItemInfo.historyChangeList();
					loadHistoryChangeFlag="1"
				}else{
					
				}
			}
			if(title==i18n['title_configInfo']){
				
				itsm.cm.getConfig.showConfigInfo();
			}
			if(title==i18n['title_installSoft']){
				if(loadInstallSoftFlag=="0"){
					itsm.cm.getConfig.showInstallSoftware();
					loadInstallSoftFlag="1"
				}else{
				}
			}
			
		},
		
		/**@description 配置项更新*/
		configureItemUpdate:function(ciRelevanceId){
			$("#configureItemInfoRelevanceCI").jqGrid('setGridParam',{page:1,url:'cm/ciRelevance!find.action?ciRelevanceId='+ciRelevanceId}).trigger('reloadGrid');
		},
		/**@description 链接到configureItemAdd.jsp页面*/
		configureItemEdit:function(){
			var url = 'ci!findItemByIdToEditOrAdd.action';
			var ciId = $("#configureCiId").val();
			$.post('ci!existCIById.action', {'ciEditId':ciId}, function(existCI){
				if(existCI){
			        url = url + '?ciDto.ciId='+ciId;
			        itsm.common.utility.tabUtility.addTab(i18n['ci_editConfigureItem'], url, 'Edit');
				}else{
					$.messager.alert(i18n['tip'],i18n['msg_atLeastChooseOneData'],'warning');
				}
			}, "json");
		},
		
		/**@description 历史请求*/
		historyCall:function(){
			var params=$.extend({},jqGridParams,{
				caption:i18n['historyRequest'],
				url:'request!findRequests.action?requestQueryDTO.CiId='+$('#configureCiInfoId').val(),
				colNames:[i18n['number'],i18n['title'],i18n['requester'],i18n['status']],
				colModel:[
						  {name:'eno',width:120},
						  {name:'etitle',width:200},
						  {name:'createdByName',width:160,sortable:false},
						  {name:'statusName',width:155,sortable:false}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "eno"}),
				sortname:'eno',
				toolbar:[false,'top'],
				ondblClickRow:function(rowId){itsm.common.utility.tabUtility.reOpenTab("request!requestDetails.action?eno="+rowId,i18n["title_request_requestDetail"])},
				pager:'#historyCallPager'		  
			});
			$("#historyCall").jqGrid(params);
			$("#historyCall").navGrid('#historyCallPager',navGridParams);
			configureItemInfoGrids.push('#historyCall');
		},
		
		/**
		 * @description 历史变更
		 */
		historyChangeList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'change!findPagerChange.action?queryDTO.ciId='+$('#configureCiInfoId').val(),
				caption:i18n['title_changeList'],
				colNames:[i18n['title_snmp_id'],i18n['number'],i18n['title'],i18n['status'],i18n['priority'],i18n['common_createTime'],i18n['title_creator']],
				colModel:[
			   		{name:'eno',width:60,sortable:true},
			   		{name:'changeNo',width:150},
			   		{name:'etitle',width:150,formatter:itsm.cm.configureItemInfo.historyChangeTitleUrlFrm},
			   		{name:'statusName',width:120,sortable:false},
			   		{name:'priorityName',width:120,sortable:false},
			   		{name:'createTime',width:120,sortable:false},
			   		{name:'creator',width:150,sortable:false}
			   	],
			   	toolbar:false,
				jsonReader: $.extend(jqGridJsonReader, {id: "eno"}),
				sortname:'eno',
				ondblClickRow:function(rowId){itsm.cm.configureItemInfo.viewHistoryChangeInfo(rowId)},
				pager:'#historyChangePager'
			});
			$("#historyChangeGrid").jqGrid(params);
			$("#historyChangeGrid").navGrid('#historyChangePager',navGridParams);
			configureItemInfoGrids.push('#historyChangeGrid');
		},
		
		/**
		 * @description 变更标题连接
		 */
		historyChangeTitleUrlFrm:function(cellvalue, options, rowObject){
			return '<a href="javascript:itsm.cm.configureItemInfo.viewHistoryChangeInfo('+rowObject.eno+')">'+cellvalue+'</a>'
			
		},
		/**
		 * @description 变更详细
		 */
		viewHistoryChangeInfo:function(id){
			itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.eno='+id+'&random=',i18n['title_changeInfo']);
		},

			
		/**@description 关联配置项*/
		relevanceCI:function(configureCiInfoId){
			var params=$.extend({},jqGridParams,{
				caption:i18n['relatedCI'],
				url:'cm/ciRelevance!find.action?ciRelevanceId='+configureCiInfoId,
				colNames:['ID',i18n['related'],i18n['description'],i18n['isAssociated']],
				colModel:[
						  {name:'relevanceId',width:155},
						  {name:'ciRelevanceName',width:160},
						  {name:'relevanceDesc',width:160},
						  {name:'unCiRelevanceName',width:170}
						  ],
				toolbar: [true,"top"],
				jsonReader: $.extend(jqGridJsonReader, {id: "relevanceId"}),
				sortname:'relevanceId',
				pager:'#configureItemInfoRelevanceCIPager'
					
			});
			$("#configureItemInfoRelevanceCI").jqGrid(params);
			$("#configureItemInfoRelevanceCI").navGrid('#configureItemInfoRelevanceCIPager',navGridParams);
			//列表操作项
			$("#t_configureItemInfoRelevanceCI").css(jqGridTopStyles);
			$("#t_configureItemInfoRelevanceCI").append($('#ciRelevancaToolbar').html());
			configureItemInfoGrids.push('#configureItemInfoRelevanceCI');
		},
		
		//关联配置项树
		/**@description 配置项分类树结构*/
		ciRelevanceTree:function(){
			$('#ci_relevance_win').window('open');
			this.loadTreeFlag="0";
			$("#ci_relevance_tree").jstree({
				json_data: {
					ajax: {
					  type:"post",
					  url : "ciRelevance!ciReleTree.action",
				      data: {'relateForward': i18n['related'].replace(' ','_'),'relateBack':i18n['isAssociated'].replace(' ','_'),'ciRelevanceId' : $('#configureCiInfoId').val()},//types is in action
	                  dataType: 'json',
	                  cache:false
					}
				},
				"plugins" : [ "themes", "json_data" ]
				
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind('select_node.jstree',function(e, data){
				var cno=data.rslt.obj.attr('ciRelevanceId');
				alert(cno);
			});
		},
		/**@description 添加关联配置项窗口*/
		open_ci_relevance_win:function(){
			$('#unCiRelevanceId').val('');
			$('#unCiRelevanceName').val('');
			$('#relevanceDesc').val('');
			$('#ciRelevanceId').val($('#configureCiInfoId').val());
			$('#add_ci_relevance_win').window('open');
			
		},
		
		/**@description 关联配置项添加到数据库*/
		ciRelevanceSave:function(){
			if($('#unCiRelevanceId').val()!=null & $('#unCiRelevanceId').val()!=''){
				if($('#unCiRelevanceId').val()==$('#ciRelevanceId').val()){
					$.messager.alert(i18n['tip'],i18n['err_ciRelevanceErr'],'error');
				}else{
					var ci_relevance_form = $('#add_ci_relevance_win form').serialize();
					$.post('ciRelevance!ciIfRelevance.action',ci_relevance_form,function(data){
						if(!data){
							$.post('ciRelevance!save.action', ci_relevance_form, function(){
								$('#configureItemInfoRelevanceCI').trigger('reloadGrid');
								msgShow(i18n['saveSuccess'],'show');
								$('#add_ci_relevance_win').window('close');
							})
						}else{
							$.messager.alert(i18n['tip'],i18n['err_ciRelevanceErr1'],'error');
						}
					})
				}
			}else{
				msgAlert(i18n['err_ciRelevanceNotNull'],'info');
			}
			
		},
		
	    /**@description 删除关联配置项*/
		ciRelevancetool_bar_delete_aff:function()
		{
			checkBeforeDeleteGrid('#configureItemInfoRelevanceCI', itsm.cm.configureItemInfo.delCiRelevance);
		},
		delCiRelevance:function(rowIds){
			var pp = $.param({'ids':rowIds},true);
			$.post("ciRelevance!delete.action", pp, function(){
				$('#configureItemInfoRelevanceCI').trigger('reloadGrid');
			}, "json");
		},	
		
		
		/**@description 编辑配置项*/
		configureItemEditLink:function(){
			itsm.common.utility.tabUtility.reOpenTab('ci!configureItemEdit.action?ciEditId='+$('#configureCiInfoId').val()+'&categoryType='+_categoryType+'&random='+Math.random()*10+1,i18n['ci_editConfigureItem']);
		},
		
		
		
		
		//数据列表伸展
	
		configureItemInfoPanelCollapseAndExpand:function(){
			
			 $(configureItemInfoGrids).each(function(i, g) {
			      setGridWidth(g, 'configureItemInfoTab', 10);
			 });
		},
		//数据列表自动伸展
		fitConfigureItemInfoGrids:function(){
			
			$('#configureItemInfo_west,#configureItemInfo_center').panel({
				onCollapse:itsm.cm.configureItemInfo.configureItemInfoPanelCollapseAndExpand,
				onExpand:itsm.cm.configureItemInfo.configureItemInfoPanelCollapseAndExpand
			});
		},
		/**初始化数据*/
		init:function(){	
			
			
			$("#configureItemInfo_loading").hide();
			$("#configureItemInfo_panel").show();
			
			itsm.cm.configureItemInfo.configureInfoTab();
			//添加到数据库按钮
			$('#link_add_ci_relevance_ok').click(itsm.cm.configureItemInfo.ciRelevanceSave);
			$('#configureItemInfo').attr('style','height:auto;padding:0px;background:#fafafa;');
			$('#configureItemEditLink').click(itsm.cm.configureItemInfo.configureItemEditLink);
			setTimeout(itsm.cm.configureItemInfo.fitConfigureItemInfoGrids,0)
			$('#unCiRelevanceName').click(function(){
				itsm.cm.configureItemUtil.selectCIS('#unCiRelevanceName','#unCiRelevanceId');
			})
			$('#configureItemInfo_returnToList').click(function(){
				itsm.common.utility.tabUtility.addTab(i18n['ci_configureItemAdmin'],'../pages/cm/configureItem.jsp');
			});
			
			$('#configureItem_edit_but').click(function(){
				itsm.common.utility.tabUtility.addTab(i18n['ci_editConfigureItem'],'ci!configureItemEdit.action?ciEditId='+$('#configureCiInfoId').val());
			});
			
		}
	};
 }();
 /**加载初始化数据*/
 $(document).ready(itsm.cm.configureItemInfo.init);