$package('itsm.cm');

 /**  
 * @author Van  
 * @constructor Van
 * @description 选择配置项分类公告方法.
 * @date 2011-05-21
 * @since version 1.0 
 */
$import("itsm.cm.getConfig");
itsm.cm.configureItemUtil=function(){
	
	this.windowId='';//窗口ID
	this.treeId='';//树结构ID
	this.gridId='';//列表ID
	this.tableId='';//表格ID（多选时添加到列表）
	this.multiSelectId='';//点击确认选择的按钮ID
	this.loadFlag='0';//加载状态，避免Grid重复加载
	
	this.namePut='';//将配置项名称赋值到此按钮
	this.idPut='';//将配置项编号赋值到此按钮
	this.ciselect_mutiTag=true;//多选标签
	
	this.hiddenName='';
	
	
	this.rowHTML='<tr id="ref_ci_CIID">'+
	'<td align="center">CINO</td>'+
	'<td align="center"><input type="hidden" name="changeDTO.cis" value="CIID" />'+
	'<a href=javascript:itsm.common.utility.tabUtility.reOpenTab("ci!findByciId.action?ciEditId=CIID","CIDETAIL_TITLE")>CINAME</a>'+
	'</td>'+
	'<td align="center">CATEGORYNAME</td>'+
	'<td align="center">CISTATUS</td>'+
	'<td align="center"><a onclick=itsm.cm.configureItemUtil.removeRow("#ref_ci_CIID")>DELETE</a></td>'+
	'</tr>';
	
	this.problemRowHTML='<tr id="ref_ci_CIID">'+
	'<td align="center">CINO</td>'+
	'<td align="center"><input type="hidden" name="cinos" value="CIID" />'+
	'<a href=javascript:itsm.common.utility.tabUtility.reOpenTab("ci!findByciId.action?ciEditId=CIID","CIDETAIL_TITLE")>CINAME</a>'+
	'</td>'+
	'<td align="center">CATEGORYNAME</td>'+
	'<td align="center">CISTATUS</td>'+
	'<td align="center"><a onclick=itsm.cm.configureItemUtil.removeRow("#ref_ci_CIID")>DELETE</a></td>'+
	'</tr>';
	
	
	
	

	return {

		/**
		 * 单选状态
		 */
		selectCIS:function(p_namePut,p_idPut){
			
			$('#selectCI_south_btn').hide();//隐藏多选按钮
			$('#selectCI_south_msg').show();//显示提示信息
			ciselect_mutiTag=false;
			hiddenName='';
			namePut=p_namePut;
			idPut=p_idPut;
			
			itsm.cm.configureItemUtil.selectCI('#selectCI_Window','#selectCI_CICategoryTree','#selectCI_CIGrid','','#selectCI_ConfirmSelect');
			
		},
		
		
		/**
		 * @description 选择关联配置项（简单）.
		 */
		selectCISM:function(tableId){
			
			$('#selectCI_south_msg').hide();//隐藏提示信息
			$('#selectCI_south_btn').show();//显示多选按钮
			ciselect_mutiTag=true;
			hiddenName='';
			itsm.cm.configureItemUtil.selectCI('#selectCI_Window','#selectCI_CICategoryTree','#selectCI_CIGrid',tableId,'#selectCI_ConfirmSelect')
		},
		
		
		/**
		 * @description 选择关联配置项（问题）
		 */
		problemSelectCI:function(tableId){
			
			$('#selectCI_south_msg').hide();//隐藏提示信息
			$('#selectCI_south_btn').show();//显示多选按钮
			ciselect_mutiTag=true;
			hiddenName='problem';
			itsm.cm.configureItemUtil.selectCI('#selectCI_Window','#selectCI_CICategoryTree','#selectCI_CIGrid',tableId,'#selectCI_ConfirmSelect')
			
			
		},

		/**
		 * @description 选择关联配置项.
		 */
		selectCI:function(p_windowID,p_treeID,p_gridId,p_tableID,p_selectId){
	
			windowId=p_windowID;//窗口编号
			treeId=p_treeID;//树结构编号
			gridId=p_gridId;//数据列表编号
			tableId=p_tableID;//表格编号
			multiSelectId=p_selectId;//多选按钮编号

			$(windowId).window('open');
			
			$(windowId+"_Tabs").tabs();//实例化Tab页面
			itsm.cm.configureItemUtil.showCITree();//加载树结构
			
			itsm.cm.configureItemUtil.selectCIGrid();//加载配置项列表
			if(loadFlag=="0"){
				loadFlag="1";
				$(multiSelectId).click(itsm.cm.configureItemUtil.selectMultiButtonClick);//绑定
			}
			
			
			setTimeout(function(){//隐藏显示复选框

				if(ciselect_mutiTag){
					$(gridId).jqGrid('showCol', 'cb');
				}else{
					$(gridId).jqGrid('hideCol', 'cb');
				}
			},0);
			
		},
		
		/**
		 * @description 显示配置项分类树.
		 */
		showCITree:function(){
			$(treeId).jstree({
				"json_data":{
				    ajax: {url : "configuration!getConfigurationCategoryTree.action",cache:false}
				},
				plugins : ["themes", "json_data", "ui", "crrm"]
				})
				.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
				.bind('select_node.jstree',function(e,data){
					var categoryNo=data.rslt.obj.attr('cno');
					$(gridId).jqGrid('setGridParam',{page:1,url:'ci!cItemsFind.action?ciQueryDTO.categoryNo='+categoryNo}).trigger('reloadGrid');
				});
			
		},
		
		
		
		/**
		 * 动作格式化.
		 */
		CIGridFormatter:function(cell,event,data){
	
			return '<div style="padding:0px">'+
			'<a href=javascript:itsm.cm.configureItemUtil.selectMultiButtonClick() title="'+i18n['check']+'">'+
			'<img src="../images/icons/ok.png"/></a>'+
			'</div>';
		},
		
		
		
		
		
		
		
		/**
		 * @description 配置項列表.
		 */
		selectCIGrid:function(){
			if($(gridId).html()!=''){
				$(gridId).trigger("reloadGrid"); 
			}else{
				var params = $.extend({},jqGridParams,{
					url:'ci!cItemsFind.action',
					colNames:[i18n['category'],i18n['number'],i18n['name'],i18n['status'],i18n['check'],''],
					colModel:[
							  {name:'categoryName',align:'center',width:20},
							  {name:'cino',align:'center',width:30},
							  {name:'ciname',align:'center',width:30},
							  {name:'status',align:'center',width:10},
							  {name:'act',align:'center',width:10,formatter:itsm.cm.configureItemUtil.CIGridFormatter},
							  {name:'ciId',hidden:true}
							  ],
					toolbar:false,
					jsonReader: $.extend(jqGridJsonReader,{id: "ciId"}),
					sortname:'ciId',
					pager:gridId+'Pager',
					ondblClickRow:function(){
						itsm.cm.configureItemUtil.selectMultiButtonClick();
					}
				});
				$(gridId).jqGrid(params);
				$(gridId).navGrid(gridId+'Pager',navGridParams);
			}	
		},
		
		/**
		 * @description 移除行
		 */
		removeRow:function(rowId){
			
			$(tableId+' tbody '+rowId).remove();
			$(rowId).remove();
		},
		
		/**
		 * @description 添加行.
		 */
		addRow:function(rowData){
			
			if ( $(tableId+' #ref_ci_'+rowData.ciId).length==0 ) {//避免重复
				
				
				
				
				var newRowHTML='';
				
				if(hiddenName!=''){
					newRowHTML=problemRowHTML;
				}else{
					newRowHTML=rowHTML;
				}
				
				
				newRowHTML=newRowHTML.replace(/CIID/g,rowData.ciId)
				.replace(/CINO/g,rowData.cino)
				.replace(/CIDETAIL_TITLE/g,i18n['ci_configureItemInfo'].replace(/ /g,'&nbsp;'))
				.replace(/CINAME/g,rowData.ciname)
				.replace(/CATEGORYNAME/g,rowData.categoryName)
				.replace(/CISTATUS/g,rowData.status)
				.replace(/DELETE/g,i18n['deletes']); 
			
				
				
				$(newRowHTML).appendTo(tableId+' tbody');
			}	
			
		},

		/**
		 * @description 选中的配置项（多选）
		 */
		selectMultiButtonClick:function(){
			
			
			if(tableId!=''){//多选状态
				
				var rowIds = $(gridId).getGridParam('selarrrow');
				
				if(rowIds==''){
					msgAlert(i18n['msg_atLeastChooseOneData'],'info');
				}else{
					
					for(var i=0;i<rowIds.length;i++){
						
						var rowData=$(gridId).getRowData(rowIds[i]);
						itsm.cm.configureItemUtil.addRow(rowData);//循环添加行
					}
					
					tableId='';//清空结果
				}
				
			}else{//单选状态
				
				
				var rowId = $(gridId).getGridParam('selrow');
				var rowData=$(gridId).getRowData(rowId);
				
				
				$(namePut).val(rowData.ciname);
				$(idPut).val(rowData.ciId);
				
				namePut='';//还原
				idPut='';
			}
			
			
			$(windowId).window('close');//关闭选择配置项窗口
			
		}

	};
	
}();