
$package("itsm.cm");
 /**  
 * @fileOverview 获取当前电脑配置信息
 * @author yctan
 * @version 1.0  
 */  
 /**  
 * @author yctan  
 * @constructor 获取当前电脑配置信息
 * @description 获取当前电脑配置信息
 * @date 2011-4-11
 * @since version 1.0 
 */ 

itsm.cm.getConfig=function(){
	this.computerName='';
	this.OS='';
	this.OSVersion='';
	this.mainboard='';
	this.serialNumber='';
	this.CPU='';
	this.CPUGrade='';
	this.CPUSpeed='';
	this.memorySize='';
	this.memorySize1='';
	this.HDModel='';
	this.HDSize='';
	this.CDDrive='';
	this.show='';
	this.DesktopMonitor='';
	this.NetworkAdapter='';
	this.lastLogin='';
	this.networkDescription='';
	this.networkMacAddress='';
	this.networkIpAddress='';
	this.softwareStr='';
	return {
		
		
		/**
		 * @description 获取配置详细信息
		 */
		getConfigInfo:function(){
			
			//本地
			var locator = new ActiveXObject ("WbemScripting.SWbemLocator"); 
			$('#getConfigInfoLoad').text("["+i18n['titil_getLoad']+"]");
			var service = locator.ConnectServer("."); 
			
			//系统信息
			var properties = service.ExecQuery("SELECT * FROM Win32_OperatingSystem"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				computerName=p.CSName; 
				OS=p.Caption;
				OSVersion=p.Version;
			}
			// 主板
			var properties = service.ExecQuery("SELECT * FROM Win32_BaseBoard"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				mainboard=p.Manufacturer ;
				serialNumber=p.SerialNumber
			}
			
			//CPU 
			var properties = service.ExecQuery("SELECT * FROM Win32_Processor"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				CPU=p.Name 
				CPUGrade=p.Stepping
				CPUSpeed=p.MaxClockSpeed
			}
			
			//内存 
			var properties = service.ExecQuery("SELECT * FROM Win32_PhysicalMemory"); 
			var e = new Enumerator (properties); 
			memorySize=0
			memorySize1=0;
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				if(p.Capacity!=""){
					memorySize=parseInt(p.Capacity)+parseInt(memorySize)
				}
					
			}
			if(memorySize>=0){
				memorySize1=memorySize/1024/1024
			}
			//硬盘  
			var properties = service.ExecQuery("SELECT * FROM Win32_DiskDrive"); 
			var e = new Enumerator (properties); 
//			for (; !e.atEnd(); e.moveNext ())
//			{
				var p = e.item (); 
				HDModel=p.Model 
				HDSize=p.Size
				//alert(HDSize);
			//}
			if(HDSize>=0){
				HDSize1=HDSize/1000/1000
			}
			//光驱  
			var properties = service.ExecQuery("SELECT * FROM Win32_CDROMDrive"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				CDDrive=p.Caption 
			}
			//显示卡  
			var properties = service.ExecQuery("SELECT * FROM Win32_VideoController"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 	
				show=p.name 
			}
			//监视器类型  
			var properties = service.ExecQuery("SELECT * FROM Win32_DesktopMonitor"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				DesktopMonitor=p.name 
			}
			//网络适配器  
			var properties = service.ExecQuery("SELECT * FROM Win32_NetworkAdapter"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 	
				NetworkAdapter=p.Name 
			}
			var WshNetwork = new ActiveXObject("WScript.Network");
			lastLogin=WshNetwork.UserName
			
			var properties = service.ExecQuery("SELECT * FROM Win32_NetworkAdapterConfiguration"); 
			var e = new Enumerator (properties); 
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 
				networkDescription=p.Description;
				networkMacAddress=p.MACAddress;
				networkIpAddress=p.IPAddress(0);
				if(networkMacAddress!=null && networkIpAddress!=null){
					//alert(networkIpAddress);
					break;
				}
			}
			
			
			//软件安装包  
			var properties = service.ExecQuery("SELECT * FROM Win32_Product"); 
			var e = new Enumerator (properties); 
			
			for (; !e.atEnd(); e.moveNext ())
			{
				var p = e.item (); 	
				softwareStr=p.Name+"=="+p.InstallDate+"<>"+softwareStr;
			}
			var param='hardwareDTO.lastLogin='+lastLogin+
				'&hardwareDTO.computerName='+computerName+
				'&hardwareDTO.serialNumber='+serialNumber+
				'&hardwareDTO.systemName='+OS+
				'&hardwareDTO.systemVersion='+OSVersion+
				'&hardwareDTO.mainboard='+mainboard+
				'&hardwareDTO.cpu='+CPU+
				'&hardwareDTO.cpuGrade='+CPUGrade+
				'&hardwareDTO.cpuSpeed='+CPUSpeed+
				'&hardwareDTO.memorySize='+memorySize1+
				'&hardwareDTO.hardDriveModel='+HDModel+
				'&hardwareDTO.hardDriveSize='+HDSize1+
				'&hardwareDTO.cdDrive='+CDDrive+
				'&hardwareDTO.networkAdapter='+NetworkAdapter+
				'&hardwareDTO.desktopMonitor='+show+
				'&hardwareDTO.monitor='+DesktopMonitor+

				'&hardwareDTO.networkDescription='+networkDescription+
				'&hardwareDTO.networkMacAddress='+networkMacAddress+
				'&hardwareDTO.networkIpAddress='+networkIpAddress+
				
				'&softwareDTO.softwareStr='+softwareStr
			return param;
		},
		/**
		 * 保存配置信息到数据库
		 */
		saveConfigInfo:function(){
			
		    var app=navigator.appName;
		    var verStr=navigator.appVersion;
		    if (app.indexOf('Netscape') != -1) {
		    	
		      alert("友情提示：\n 使用此功能建议您使用 IE4.0 或以上版本。");
		    }else if (app.indexOf('Microsoft') != -1) {
		      if (verStr.indexOf("MSIE 3.0")!=-1 || verStr.indexOf("MSIE 4.0") != -1 || verStr.indexOf("MSIE 5.0") != -1 || verStr.indexOf("MSIE 5.1") != -1)
		        alert("友情提示：\n    您的浏览器版本太低,建议您使用 IE4.0 或以上版本。");
		      else{
		    	  	var postData=itsm.cm.getConfig.getConfigInfo();
			    	$.post('ci!saveCiConfigInfo.action',postData+'&ciEditId='+$('#configureCiInfoId').val(),function(){
						msgShow(i18n['title_getSuccess'],'show');
						itsm.cm.getConfig.showConfigInfo();
						$('#getConfigInfoLoad').text('');
			    	})	
			    }
		    }
		},
		
		configSetInput:function(value,inputId){
			if(value!=null)
				$(inputId).val(value);
			else
				$(inputId).val('');
		},
		
		/**
		 * @description 显示电脑配置信息
		 */
		showConfigInfo:function(){
			$.post('ci!getCiHardware.action','ciEditId='+$('#configureCiInfoId').val(),function(data){
				if(data!=null){
					itsm.cm.getConfig.configSetInput(data.ciHardwareId,'#ciHardwareId');
					itsm.cm.getConfig.configSetInput(data.lastLogin,'#lastLogin');
					itsm.cm.getConfig.configSetInput(data.computerName,'#computerName');
					itsm.cm.getConfig.configSetInput(data.serialNumber,'#serialNumber');
					itsm.cm.getConfig.configSetInput(data.systemName,'#systemName');
					itsm.cm.getConfig.configSetInput(data.systemVersion,'#systemVersion');
					itsm.cm.getConfig.configSetInput(data.mainboard,'#mainboard');
					itsm.cm.getConfig.configSetInput(data.cpu,'#cpu');
					itsm.cm.getConfig.configSetInput(data.cpuGrade,'#cpuGrade');
					itsm.cm.getConfig.configSetInput(data.cpuSpeed,'#cpuSpeed');
					itsm.cm.getConfig.configSetInput(data.memorySize,'#memorySize');
					itsm.cm.getConfig.configSetInput(data.hardDriveModel,'#hardDriveModel');
					itsm.cm.getConfig.configSetInput(data.hardDriveSize,'#hardDriveSize');
					itsm.cm.getConfig.configSetInput(data.cdDrive,'#cdDrive');
					itsm.cm.getConfig.configSetInput(data.networkAdapter,'#networkAdapter');
					itsm.cm.getConfig.configSetInput(data.desktopMonitor,'#desktopMonitor');
					itsm.cm.getConfig.configSetInput(data.monitor,'#monitor');
					itsm.cm.getConfig.configSetInput(data.networkDescription,'#networkDescription');
					itsm.cm.getConfig.configSetInput(data.networkMacAddress,'#networkMacAddress');
					itsm.cm.getConfig.configSetInput(data.networkIpAddress,'#networkIpAddress');
					itsm.cm.getConfig.configSetInput(data.remark,'#config_remark');

				}
			})
		},
		/**
		 * @description 显示安装软件
		 */
		
		showInstallSoftware:function(){
			var params = $.extend({},jqGridParams,{
				caption:i18n['title_installSoft'],
				url:'ci!getCiSoftware.action?ciEditId='+$('#configureCiInfoId').val(),
				colNames:['ID',i18n['title_softName'],i18n['title_installDate']],
				colModel:[
						  {name:'softwareId',index:'id',width:20},
						  {name:'softwareName',width:120},
						  {name:'installDate',width:80}
						  ],
				multiselect:false,		  
				toolbar: false,
				jsonReader: $.extend(jqGridJsonReader, {id: "softwareId"}),
				sortname:'softwareId',
				pager:'#installSoftwarePager'
			});
			$("#installSoftwareGrid").jqGrid(params);
			$("#installSoftwareGrid").navGrid('#installSoftwarePager',navGridParams);
			configureItemInfoGrids.push('#installSoftwareGrid');
		},
		
		
		/**
		 * @description 修改配置信息
		 */
		updateConfigInfo:function(){
			var param=$('#configInfoDiv form').serialize();
			$.post('ci!saveHardware.action',param,function(){
				$.post('ci!getCiHardware.action','ciEditId='+$('#configureCiInfoId').val(),function(data){
					if(data!=null){
						if(data.ciHardwareId!=null){
							$('#ciHardwareId').val(data.ciHardwareId);
						}
					}
				})
				msgShow(i18n['saveSuccess'],'show');
			})
		},
	
		init:function(){
		}
	}
}();

$(document).ready(itsm.cm.getConfig.init);

