﻿/**  
 * @author Tan & Van  
 * @constructor indexPage
 * @description "indexPage"
 * @date 2010-11-17
 * @since version 1.0 
 */ 

$import('itsm.knowledge.leftMenu');
$import('itsm.common.utility.tabUtility');
$import('itsm.request.requestStats');


var indexPage=function(){	 
	  
	
		this.expandSubMenu=function(){
			
			//展开左菜单
			$('body').layout('expand','west');
		}
	
		/**@description 统计请求*/
		this.countRequest=function(){
			setTimeout(function() 
			{  
				itsm.request.requestStats.countAllRquest();
			},500);  
		}
		
	 this.logOut=function(){
			$.messager.confirm(i18n['tip'], '<br/>'+i18n['systemExitConfirm'], function(r){
				if (r)
				{
					window.location='logout.jsp';
				}
				});
	 }
		/**@description 基础设置左菜单*/
		this.showTab=function(id)
		{
			$("#menuContent").html($('#'+id).html());
			
			var outTime=500;
			
			
			
			if(id=="003"){
				showDictionaryGroup();  
			}
			
			if(id=="006"){
				showRulePackage();
			}
			
			if(id=="002"||id=="004"){
				setTimeout(function(){$("#menuContent").html($('#'+id).html());},outTime);  
			}

			for(var i=1;i<10;i++)
			{
				if(document.getElementById("M00"+i)!=null){
					
					document.getElementById("M00"+i).className="mianstyle outfuc";
				}
				
			}
			
			if(document.getElementById("M"+id)!=null){
			
				document.getElementById("M"+id).className="mianstyle onfuc";
			}
			
		}

		 
	   /**@description 加载配置菜单 */
		this.showCIIndex=function(){
			expandSubMenu();
			
			showLeftMenu('../pages/cm/leftMenu.jsp?random='+Math.random()*10+1,'leftMenu');
			itsm.common.utility.tabUtility.addTab(i18n['ci_configureItemAdmin'],'../pages/cm/configureItem.jsp');
			
		} 

	   /**@description 加载辅助工具菜单 */
		this.showToolsIndex=function(){
			
			expandSubMenu();
			
			showLeftMenu('../pages/tools/leftMenu.jsp','leftMenu');
			
		}
		
		
	  /**@description 上传文件   */
		this.commonUploadFile=function(fileId,valueId,showId){
			var fileUrl=$('#'+fileId).val();
			var tag=true;
			var fileType=fileUrl.lastIndexOf(".");
			if(fileType==-1){
				tag=false;
			}else{
				fileType=fileUrl.substring(fileType+1,fileUrl.length);
				if(fileType=="jpg"||fileType=="gif"||fileType=="png"||fileType=="bmp"){
					tag==true;
				}else{
					tag=false;
				}
			}
			
			if(tag==false){
				msgAlert(i18n['uploadFileFormatError'],'error');
				$('#'+fileId).val("");

			}else{
				
				$.ajaxFileUpload({
					
						url:'fileUpload.action',
						secureuri:false,
						fileElementId:fileId,
						dataType: 'text',
						success: function (data, status){
							$('#'+valueId).val(data);
							$('#'+showId).html('<img src="../upload/images/'+data+'" width="30px" height="30px" />');
						}
					}
				);
				
			}
				return false;
			
		}
		
		
		

		
		  /**@description 动态加载数据字典 */
		this.showDictionaryGroup=function(){
			
				var appendHTML=$('#dataDictionaryGroupsAppendDIV').html();
				
			   	$.post("dataDictionaryGroup!findGroup.action", function(data) {
			   		$('#menuContent').html(data+appendHTML);
			   		
			     });
		}
		
	     /**@description 加载规则   */
		this.showRulePackage=function(){
			$.get("rulePackage!findRulePackage.action", function(data) {
		   		$('#menuContent').html(data+'<a href=javascript:itsm.common.utility.tabUtility.addTab("'+i18n['notitceRule'].replace(/ /g,'&nbsp;')+'","../pages/noticeRule/noticeRule.jsp")>'+i18n['notitceRule']+'</a>');
		       });
		}
	 	 /**@description 加载左菜单  */
		this.showLeftMenu=function(url,div)
		{
			$('#'+div).load(url);
		}
		 /**@description 加载报表首页  */
		this.showRrportIndex=function(){
			
			expandSubMenu();
			
			//加载左边菜单
			showLeftMenu('../pages/report/leftMenu.jsp','leftMenu');
			openTab(i18n['title_FCTRateToday'],'../pages/report!statReport.action?fileName=requestFRC_day');
			
		} 
		
		
		/**@description 加载基础设置左菜单 */
		this.showBasicSetIndex=function(){
			
			//展开左菜单
			expandSubMenu();
			
			//加载左菜单
			showLeftMenu('../pages/security/leftMenu.jsp?random='+Math.random()*10+1,'leftMenu');
			
			
			
		}

		 /**@description 加载请求首页 */
		this.showRequestIndex=function(){
			
			expandSubMenu();
			showLeftMenu('../pages/request/leftMenu.jsp?random='+Math.random()*10+1,'leftMenu');		
			refreshTab(i18n['title_allRequestList'],'../pages/request/requestMain.jsp');
			countRequest();
			
		} 
	   /**@description 帮助台门户 */
		this.helpdeskProtal=function(){
			expandSubMenu();
			
			showLeftMenu('../pages/portal/leftMenu.jsp','leftMenu');
			openTab(i18n['portal'],'../pages/portal/helpdeskPortal.jsp');
			
			
		}
		
		
	
      /**@description  读取未读信息 */
	this.showMessager=function() {
			$.post('immanage!findPager.action?manageQueryDTO.status=0&manageQueryDTO.receiveUsers='+userName,function(data){
				if(data!=null){
					
					$('#norederim').text(data.totalSize);
				}
			});	
	}

	
	 /**@description  快速创建 */
	this.fastCreateRequest=function(){
		
		 if($('#fastCreateDiv form').form('validate')){
			 
				var frm = $('#fastCreateDiv form').serialize();
				var url = 'request!saveRequest.action';
				
				startProcess();
				$.post(url,frm, function(){
					endProcess();
					
					msgShow(i18n['createSuccess'],'show');
					$('#fastCreateEtitle').val('');
					$('#fastCreateEdesc').val('');
					
					$('#requestGrid').trigger('reloadGrid');
					
				});
		 }

	}
	
	
	//清空指定ID值
	this.cleanIdValue=function(id1,id2){
		$('#'+id1).val('');
		$('#'+id2).val('');
	}
	

	//加载变更首页
	this.showChangeIndex=function(){
		expandSubMenu();
		//加载左边菜单
		showLeftMenu('../pages/change/leftMenu.jsp?random='+Math.random()*10+1,'leftMenu');
		openTab(i18n['title_changeManage'],"../pages/change/change.jsp");

	} 
	
	
	/**
	 * 加载流程图.
	 */
	this.trace = function(_piId){
	    var _url = 'upload!traceInstance.action?instanceId='+_piId;
	    refreshTab(i18n["title_request_traceInstance"],_url);
	}
	
	
	
	return{
		init:function()
		{
			
			
			
			
			setTimeout(function() 
			{  
				helpdeskProtal();
				
				showMessager();//读取IM
				
			},0);
			
			$('#requestTopMenu').click(showRequestIndex);
			
			$('#problemTopMenu').click(function(){
				
				showLeftMenu('../pages/problem/leftMenu.jsp','leftMenu');		
				refreshTab(i18n['problem_grid'],'../pages/problem/problemMain.jsp');	
				
			});//问题首页
			
			
			//知识库
			$('#knowledgeTopMenu').click(itsm.knowledge.leftMenu.showKnowledgeIndex);
			
			$('#basicSetTopMenu').click(showBasicSetIndex);
			$('#reportTopMenu').click(showRrportIndex);
			$('#CITopMenu').click(showCIIndex);
			$('#toolsTopMenu').click(showToolsIndex);
			$('#protal_link').click(helpdeskProtal);
			$('#changeTopMenu').click(showChangeIndex);
			
			
			
			
			//每5秒读取一下IM
			setInterval(function(){
				
				showMessager();
				
			},100000);
			
			
			
			var timeoutFlag="0";
			
			$(document).ajaxError(function(e, xhr, settings, exception) {
				//隐藏进程
				endProcess();
				
				if(xhr.status==606){
					
					if(timeoutFlag=="0"){
						
						$.messager.confirm(i18n['tip'],'<br/>'+i18n['common_systemTimeout'],function(r){
							if(r){
								window.location.reload();
							}
						});
						
						timeoutFlag="1";
					}
					
					
				}
				
				
				if(xhr.status==403){
					$.messager.alert(i18n['errTip'],'<br/>'+i18n['error403']+'<a href="'+i18n['system_error_contact_url']+'"  target="_blank">'+i18n['contactUs']+'</a>','error');
				};
				if(xhr.status==404){
					$.messager.alert(i18n['errTip'],'<br/>'+i18n['error404']+'<a href="'+i18n['system_error_contact_url']+'"  target="_blank">'+i18n['contactUs']+'</a>','error');
				};
				if(xhr.status==500){
					var msg=xhr.responseText;
					
					if(msg!=null && msg.indexOf("org.hibernate.exception.DataException")!=-1){
						
						msgAlert(i18n['error_data_dataToLong'],'info');
						return;
					}
					
					if(msg!=null && msg.indexOf('ApplicationException:')!=-1){
						msg=msg.substring(msg.indexOf('ApplicationException:')+22,msg.indexOf("\n"));
						msgAlert(i18n[msg],'warning');
						return;
						
					}else{
						msgAlert(i18n['error500']+'<a href="'+i18n['system_error_contact_url']+'"  target="_blank">'+i18n['contactUs']+'</a>','error');
						
						return;
					}
				};
			});
			
			
		}	
	}
 }();
 
//载入
 $(document).ready(indexPage.init);
