$package('itsm.common.utility');

/**  
 * @fileOverview 有关Tab操作包
 * @author yctan
 * @version 1.0  
 */  
 /**  
 * @author yctan  
 * @constructor 有关Tab操作包
 * @description 有关Tab操作的所有函数
 * @date 2011-04-16
 * @since version 1.0 
 */  
itsm.common.utility.tabUtility=function(){
	
	
	return {
		
		/**
		 * @description如果当前TAB存在，则关闭TAB再打开新的TAB
		 */
		reOpenTab:function(url,title){
			if ($('#itsmMainTab').tabs('exists',title))
			{
				$('#itsmMainTab').tabs('close',title);
				$('#itsmMainTab').tabs('add',{
					title:title,
					cache:"false",
		 			href:url+'&random='+Math.random()*10+1,
					closable:true
				});
			} 
			else 
			{
				$('#itsmMainTab').tabs('add',{
					title:title,
					cache:"false",
		 			href:url+'&random='+Math.random()*10+1,
					closable:true
				});
			}
			itsm.common.utility.tabUtility.tabClose();
		},
		/**
		  * @description 如果tabs存在则转到对应的TAB，如果不存在则添加tabs
		  * */
		addTab:function(title, url){
			if ($('#itsmMainTab').tabs('exists', title)){
				$('#itsmMainTab').tabs('select', title);
			} else {
				$('#itsmMainTab').tabs('add',{
					title:title,
					cache:"false",
					href:url,
					closable:true
				});
			}
			itsm.common.utility.tabUtility.tabClose();
		},
		/**
		 * @description 绑定右键菜单事件 
		 * */
		tabCloseEven:function()
		{
		    //关闭当前
		    $('#mm-tabclose').click(function(){
		        var currtab_title = $('#mm').data("currtab");
		        $('#itsmMainTab').tabs('close',currtab_title);
		    })
		    //全部关闭
		    $('#mm-tabcloseall').click(function(){
		        $('.tabs-inner span').each(function(i,n){
		            var t = $(n).text();
		            $('#itsmMainTab').tabs('close',t);
		        });   
		    });
		    //关闭除当前之外的TAB
		    $('#mm-tabcloseother').click(function(){
		        var currtab_title = $('#mm').data("currtab");
		        $('.tabs-inner span').each(function(i,n){
		            var t = $(n).text();
		            if(t!=currtab_title)
		                $('#itsmMainTab').tabs('close',t);
		        });   
		    });
		    //关闭当前右侧的TAB
		    $('#mm-tabcloseright').click(function(){
		        var nextall = $('.tabs-selected').nextAll();
		        if(nextall.length==0){
		            //msgShow('系统提示','后边没有啦~~','error');
//		            alert('后边没有啦~~');
		            return false;
		        }
		        nextall.each(function(i,n){
		            var t=$('a:eq(0) span',$(n)).text();
		            $('#itsmMainTab').tabs('close',t);
		        });
				  return false;
		    });
		    //关闭当前左侧的TAB
		    $('#mm-tabcloseleft').click(function(){
		        var prevall = $('.tabs-selected').prevAll();
		        if(prevall.length==0){
//		            alert('到头了，前边没有啦~~');
		            return false;
		        }
		        prevall.each(function(i,n){
		            var t=$('a:eq(0) span',$(n)).text();
		            $('#itsmMainTab').tabs('close',t);
		        });
		        return false;
		    });
		    
		},
		tabClose:function()
		{
			/*双击关闭TAB选项卡*/
			$(".tabs-inner").dblclick(function(){
				var subtitle = $(this).children("span").text();
				$('#itsmMainTab').tabs('close',subtitle);
			})
		
			$(".tabs-inner").bind('contextmenu',function(e){
				$('#mm').menu('show', {
					left: e.pageX,
					top: e.pageY
				});
			   
				var subtitle =$(this).children("span").text();
				$('#mm').data("currtab",subtitle);
			   
				return false;
			});
		},
		init:function(){
			
			itsm.common.utility.tabUtility.tabCloseEven();
		}
	};
}();


$(document).ready(itsm.common.utility.tabUtility.init);