$package("itsm.compass") 
/**  
 * @fileOverview "全文检索"
 * @author Van
 * @version 1.0  
 */  
 /**  
 * @author Van  
 * @constructor Van
 * @description 全文检索
 * @date 2011-06-13
 * @since version 1.0 
 */


itsm.compass.fullSearch = function() {
	
	
	//载入
	return {
		
		/**
		 * 打开窗口
		 */
		openFullsearchWindow:function(p_keyword,p_searchType){
			
			$('#fullSearchKeyWord').val(p_keyword);
			$("input[name='fullSearch_type'][value='"+p_searchType+"']").attr("checked",true);  //根据Value值设置Radio为选中状态;
			$('#index_fullSearch_window').window('open');
		},
		
		/**
		 * 同步搜索框的值
		 */
		setFullsearchValue:function(keywordId,searchTypeName){//同步值
		
			var keyWord=$(keywordId).val();
			var searchType=$("input[name='"+searchTypeName+"']:checked").val();
			$('#fullSearchKeyWord').val(keyWord);
			$("input[name='fullSearch_type'][value='"+searchType+"']").attr("checked",true);  //根据Value值设置Radio为选中状态;
			itsm.compass.fullSearch.doFullSearch();//执行搜索
		},

		/**
		 * 执行全文搜索
		 */
		doFullSearch:function(){

			var keyWord=$('#fullSearchKeyWord').val();
			var searchType=$("input[name='fullSearch_type']:checked").val();
			
			if(searchType=="request"){
				
				//打开或选择对应的页面并显示
				openTabCallback(i18n['title_allRequestList'],'../pages/request/requestMain.jsp?fullsearch=yes',function(){					
					var _url="request!analogousRequest.action";					
					var postData = $("#requestGrid").jqGrid("getGridParam", "postData");     					
					$.extend(postData,{'compassQueryDTO.alias':'RequestInfo','compassQueryDTO.queryString':keyWord});
					$('#requestGrid').jqGrid('setGridParam',{page:1,url:_url,postData:postData}).trigger('reloadGrid');
				});
			}

			if(searchType=="problem"){

				//打开或选择对应的页面并显示
				openTabCallback(i18n['problem_grid'],'../pages/problem/problemMain.jsp?fullsearch=yes',function(){					
					var _url="problem!fullSearch.action";
					var postData = $("#problemGrid").jqGrid("getGridParam", "postData");     					
					$.extend(postData, {'compassQueryDTO.alias':'Problems','compassQueryDTO.queryString':keyWord});
					$('#problemGrid').jqGrid('setGridParam',{page:1,url:_url,postData:postData}).trigger('reloadGrid');
				});	

			}

			if(searchType=="change"){

				//打开或选择对应的页面并显示
				openTabCallback(i18n['title_changeManage'],"../pages/change/change.jsp?fullsearch=yes",function(){
					var _url="change!fullSearch.action";
					var postData = $("#changeGrid").jqGrid("getGridParam", "postData");  
					$.extend(postData, {'compassQueryDTO.alias':'Changes','compassQueryDTO.queryString':keyWord});			
					$('#changeGrid').jqGrid('setGridParam',{page:1,url:_url,postData:postData}).trigger('reloadGrid');
				});
				
			}
			
		},
		
		/**
		 * 载入
		 */
		init:function(){
			
			$('#fullSearchBtn').click(itsm.compass.fullSearch.doFullSearch);
		}
		
	};
	
	
}();
	
//载入
$(document).ready(itsm.compass.fullSearch.init);