/**  
 * @author Tan  
 * @constructor Van
 * @description "updateLevelMain"
 * @date 2010-11-17
 * @since version 1.0 
 */  

$package('itsm.config.basicConfig')


itsm.config.basicConfig.currencyGrid=function(){
	
	

	return {
			
		isDefaultFormatter:function(cell,e,rowData){
			
			return rowData.isDefault=="1"?"<span style='color:#FF0000'>"+i18n['label_basicConfig_deafultCurrencyYes']+"</span>":i18n['label_basicConfig_deafultCurrencyNo'];
		},
		
		/**
		 * 加载货币列表.
		 */
		showGrid:function(){
			
			
			var params = $.extend({},jqGridParams, {	
			url:'currency!findCurrencyByPager.action',
			caption:i18n['title_basicConfig_currencyGrid'],
			colNames:[i18n['title_basicConfig_currencyName'],i18n['title_basicConfig_currencySing'],i18n['title_basicConfig_isDefaultCurrency'],'',''],
			colModel:[
					  {name:'cname',width:25,align:'center'},
					  {name:'sign',width:25,align:'center'},
					  {width:25,align:'center',sortable:false,formatter:itsm.config.basicConfig.currencyGrid.isDefaultFormatter},
					  {name:'cno',hidden:true},
					  {name:'isDefault',hidden:true}
					  ],
			jsonReader: $.extend(jqGridJsonReader, {id: "cno"}),
			sortname:'cno',
			pager:'#currencyGridPager'
			});
			$("#currencyGrid").jqGrid(params);
			$("#currencyGrid").navGrid('#currencyGridPager',navGridParams);
			//列表操作项
			$("#t_currencyGrid").css(jqGridTopStyles);
			$("#t_currencyGrid").append($('#currencyGridToolbar').html());
			
			//自适应宽度
			setGridWidth("#currencyGrid","regCenter",10);
		},
		
		openAddEditWindow:function(){
			$('#currency_cno').val('');
			resetForm('#addEditCurrencyForm');
			$('#addEditCurrencyGrid').window('open');
			
		},
		
		/**
		 * 保存货币.
		 */
		saveCurrency:function(){
			
			
			
			if($('#addEditCurrencyForm').form('validate')){
				
				var frm = $('#addEditCurrencyForm').serialize();
				var url = "currency!saveOrUpdateCurrency.action";
				
				$.post(url,frm, function(){
					
					$('#currencyGrid').trigger('reloadGrid');			
					$('#addEditCurrencyGrid').window('close');
					
					msgShow(i18n['msg_basicConfig_currencyAddEditSuccessful'],'show');
				});
			}

		},
		
		/**
		 * 编辑货币.
		 */
		editCurrencyOpenWindow:function(){
			
			resetForm('#addEditCurrencyForm');
			
			checkBeforeEditGrid('#currencyGrid',function(rowData){
				
				$('#currency_cno').val(rowData.cno);
				$('#currency_cname').val(rowData.cname);
				$('#currency_sign').val(rowData.sign);
				
				if(rowData.isDefault=='true'){
					
					$('#currency_isDefault').attr({"checked":"checked"});
				}
					
					
				

				$('#addEditCurrencyGrid').window('open');

			});
	
		},
		
		/**
		 * 删除货币单位
		 */
		deleteCurrencys:function(){
			
			
			checkBeforeDeleteGrid('#currencyGrid',function(cnos){
				
				
				var url = "currency!deleteCurrencys.action";
				var param = $.param({'cnos':cnos},true);
				
				$.post(url,param, function(){
					
					$('#currencyGrid').trigger('reloadGrid');			

					msgShow(i18n['msg_basicConfig_currencyDeleteSuccessful'],'show');
				});
				
				
			});
		},
		
		
		/**
		 * 加载.
		 */
		init:function(){
			
			$('#currencyMain_loading').hide();
			$('#currencyMain_content').show();
			
			itsm.config.basicConfig.currencyGrid.showGrid();
			
			$('#addCurrencyBtn').click(itsm.config.basicConfig.currencyGrid.openAddEditWindow);
			$('#editCurrencyBtn').click(itsm.config.basicConfig.currencyGrid.editCurrencyOpenWindow);
			$('#deleteCurrencyBtn').click(itsm.config.basicConfig.currencyGrid.deleteCurrencys);
			$('#saveCurrencyBtn').click(itsm.config.basicConfig.currencyGrid.saveCurrency);

		}
		
	};
	
	
}();

$(document).ready(itsm.config.basicConfig.currencyGrid.init);