$package('itsm.config.cab')
/**
 * CAB管理
 */


$import("itsm.security.userUtil");

itsm.config.cab.cabadmin=function(){
	this.opt;
	return {
		/**
		 * CAB列表
		 */
		cabList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'cab!findPagerCAB.action',
				caption:i18n['title_cabList'],
				colNames:[i18n['number'],i18n['name'],i18n['description'],i18n['operateItems']],
				colModel:[
			   		{name:'cabId',width:60,sortable:true},
			   		{name:'cabName',width:150},
			   		{name:'cabDesc',width:200},
			   		{name:'act',align:'center',sortable:false,formatter:itsm.config.cab.cabadmin.cabActFormatter}
			   	],		
				jsonReader: $.extend(jqGridJsonReader, {id: "cabId"}),
				sortname:'cabId',
				onSelectRow:function(rowId){itsm.config.cab.cabadmin.cabMemberListReload(rowId)},
				pager:'#cabPager'
			});
			$("#cabGrid").jqGrid(params);
			$("#cabGrid").navGrid('#cabPager',navGridParams);
			//列表操作项
			$("#t_cabGrid").css(jqGridTopStyles);
			$("#t_cabGrid").append($('#cabGridToolbar').html());
			//自适应大小
			setGridWidth("#cabGrid","regCenter",10);
		},
		
		cabActFormatter:function(cell,opt,data){
			return $('#cabActFormatterDiv').html();
		},
		/**
		 * CAB添加窗口
		 */
		openCabAddWin:function(){
			$("#cabName").val('');
			$("#cabDesc").val('');
			$("#cabId").val('');
			opt='saveCAB';
			$('#cabAddOrEditDiv').window('open');
		},
		/**
		 * CAB编辑窗口
		 */
		openCabEditWin:function(rowData) {
			
			$("#cabName").val(rowData.cabName);
			$("#cabDesc").val(rowData.cabDesc);
			$("#cabId").val(rowData.cabId);
			opt='editCAB';
			$('#cabAddOrEditDiv').window('open');
		},
		
		/**
		 * 编辑
		 */
		cab_edit_aff:function(){
			checkBeforeEditGrid('#cabGrid', itsm.config.cab.cabadmin.openCabEditWin);
		},
		
		/**
		 * CAB添加编辑保存
		 */
		
		cabAddOrEditOpt:function(){
			if($("#cabName").val()!=''){
				var _params = $('#cabAddOrEditDiv form').serialize();
				$.post('cab!'+opt+'.action', _params, function(){
					$('#cabAddOrEditDiv').window('close');
					$('#cabGrid').trigger('reloadGrid');
					msgShow(i18n['addSuccess'],'show');
				})
			}else{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['err_nameNotNull'],'error');	
			}
			
		},
		
		
		/**
		 * 删除
		 */
		cab_delete_aff:function(){
			checkBeforeDeleteGrid('#cabGrid', itsm.config.cab.cabadmin.deleteCab);
		},
		
		/**
		 * 执行删除
		 */
		deleteCab:function(rowIds) {
			var _param = $.param({'cabIds':rowIds},true);
			$.post("cab!deleteCAB.action", _param, function(){
				$('#cabGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'show');
			}, "json");
		},
		/**
		 * 查看成员
		 */
		viewCabMember:function(){
			var rowId = $('#cabGrid').getGridParam('selrow');
			if(rowId==null)
			{
				$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'show');
			}
			else
			{
				var rowData=$('#cabGrid').getRowData(rowId);
				itsm.common.utility.tabUtility.reOpenTab('../pages/config/cab/cabMember.jsp?cabId='+rowData.cabId,i18n['title_cabMember']);
			}
			
		},
		
		
		
		cabMemberListReload:function(id){
			$('#cab_cabId').val(id);
			var _url = 'cab!findCABMember.action?cabId='+id;		
			$('#cabMemberGrid').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
		},
		
		
		/**
		 * CAB成员列表
		 */
		cabMemberList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'cab!findCABMember.action?cabId=',
				caption:i18n['title_cabMember_list'],
				colNames:[i18n['number'],i18n['title_cab_approvalMember'],i18n['title_cab_delegateMember'],i18n['description'],i18n['operateItems'],'',''],
				colModel:[
			   		{name:'cabMemberId',width:60},
			   		{name:'approvalMember',width:150},
			   		{name:'delegateMember',width:200},
			   		{name:'desc',width:200},
			   		{name:'act',hidden:true,sortable:false},
			   		{name:'approvalMemberId',hidden:true},
			   		{name:'delegateMemberId',hidden:true}
			   	],	
			   	
				jsonReader: $.extend(jqGridJsonReader, {id: "cabMemberId"}),
				sortname:'cabMemberId',
				pager:'#cabMemberPager'
			});
			$("#cabMemberGrid").jqGrid(params);
			$("#cabMemberGrid").navGrid('#cabMemberPager',navGridParams);
			//列表操作项
			$("#t_cabMemberGrid").css(jqGridTopStyles);
			$("#t_cabMemberGrid").append($('#cabMemberGridToolbar').html());
			//自适应大小
			setGridWidth("#cabMemberGrid","regCenter",10);
		},
		
	
		/**
		 * CAB添加窗口
		 */
		openCabMemberAddOrEditWin:function(){

			opt='addCabMember';
			
			if($('#cab_cabId').val()==''){
				msgAlert(i18n['msg_msg_pleaseChooseCab'],'info');
			}else{
				$('#approvalMemberName').val('');
				$('#approvalMember').val('');
				$('#delegateMemberName').val('');
				$('#delegateMember').val('');
				$('#cabMemberDesc').val('');
				$('#cabMemberAddDiv').window('open');
			}	
		},
		/**
		 * CAB成员添加编辑保存
		 */
		cabMemberAddOrEditOpt:function(){
			
			if($('#approvalMemberName').val()!=''){
				var _params = $('#cabMemberAddDiv form').serialize();
				$.post('cabMember!'+opt+'.action', _params, function(){
					$('#cabMemberAddDiv').window('close');
					$('#cabMemberGrid').trigger('reloadGrid');
					msgShow(i18n['addSuccess'],'show');
				})
			}else{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['err_approvalMemberNotNull'],'error');	
			}
			
		},
		/**
		 * CABMember编辑窗口
		 */
		openCabMemberEditWin:function(rowData) {
			$("#cabMemberId").val(rowData.cabMemberId);
			$("#approvalMemberName").val(rowData.approvalMember);
			$("#approvalMember").val(rowData.approvalMemberId);
			$("#delegateMemberName").val(rowData.delegateMember);
			$("#delegateMember").val(rowData.delegateMemberId);
			$("#cabMemberDesc").val(rowData.desc);
			opt='editCabMember';
			$('#cabMemberAddDiv').window('open');
		},
		/**
		 * 编辑
		 */
		cabMember_edit_aff:function(){
			checkBeforeEditGrid('#cabMemberGrid', itsm.config.cab.cabadmin.openCabMemberEditWin);
		},
		
		/**
		 * 删除
		 */
		cabMember_delete_aff:function(){
			checkBeforeDeleteGrid('#cabMemberGrid', itsm.config.cab.cabadmin.deleteCabMember);
		},
		
		/**
		 * 执行删除
		 */
		deleteCabMember:function(rowIds) {
			var _param = $.param({'cabMemberIds':rowIds},true);
			$.post("cabMember!deleteCABMember.action", _param+'&cabId='+$('#cab_cabId').val(), function(){
				$('#cabMemberGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'show');
			}, "json");
		},
		
		
		/**
		 * 选择用户.
		 */
		cabMember_selectUser:function(userId,userName){
			itsm.security.userUtil.selectUser(userName,userId,'','loginName');
		},
		init:function(){
			showAndHidePanel("#cabManage_panel","#cabManage_loading");
			itsm.config.cab.cabadmin.cabList();
			//页面事件
			$('#cab_add_but').click(itsm.config.cab.cabadmin.openCabAddWin);
			$('#cab_edit_but').click(itsm.config.cab.cabadmin.cab_edit_aff);
			$('#cab_delete_but').click(itsm.config.cab.cabadmin.cab_delete_aff);
			$('#cab_add_opt_but').click(itsm.config.cab.cabadmin.cabAddOrEditOpt);
			
			$('#approvalMemberName').click(function(){
				itsm.security.userUtil.selectUser('#approvalMemberName','#approvalMember','','loginName')
			});
			$('#delegateMemberName').click(function(){
				itsm.security.userUtil.selectUser('#delegateMemberName','#delegateMember','','loginName')
			});
			
		}	
	}

}();

$(document).ready(itsm.config.cab.cabadmin.init);