
 /**  
 * @author Tan  
 * @constructor Van
 * @description "configureItemCategory"
 * @date 2010-11-17
 * @since version 1.0 
 */ 
$package('itsm.config.categoryManage');


$import('itsm.config.categoryManage.CICategoryTree');

itsm.config.categoryManage.CICategory=function(){
	

	
	return {
		
		/**
		 * @description 添加配置项分类.
		 * */
		saveConfigItemCategory:function() {
			var parentNo=$('#add_parentNo').val();
			var rootId = $('#configureItemCategoryTree_div').find('li').length;			
			if(parentNo==null || parentNo=='' && rootId > 0){
				msgAlert(i18n['msg_msg_pleaseChooseParent'],'error');
			}else{
					var _params = $('#addConfigurationItem form').serialize();
					var url = 'configuration!save.action';
					if(rootId>0){
						if($('#addConfigurationItemForm').form('validate')){
							$.post(url, _params,function (r) {
								itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
								$('#add_parentNo').val(parentNo);
								$('#add_category,#add_description,#addCMUploadIcon,#addCI_cname').val('');
							 	$('#add_showIconPanel').html("");	 	
								msgShow(i18n['msg_add_successful'],'show');
								
							},'json');
						}
					}else{
						if($('#addConfigurationItemForm').form('validate')){
							$.post(url, _params+"&configurationItemsDto.categoryRoot=CICategory",function (r) {
								itsm.config.categoryManage.CICategoryTree.showCICategoryTree();	
								$('#add_parentNo').val(parentNo);
								$('#add_category,#add_description,#addCMUploadIcon,#addCI_cname').val('');
							 	$('#add_showIconPanel').html("");
								msgShow(i18n['msg_add_successful'],'show');
								
							},'json');
						}	
					}
				
			
			}
			
		},
		
		 /**
		  * @description 编辑配置项分类.
		  */
		updateConfigItemCategory:function() {
			
			

			var cno=$('#edit_cno').val();
			
			if(cno==null || cno==''){
				
				msgAlert(i18n['msg_msg_pleaseChooseCategory'],'error');
				
			}else{
				if($('#editConfigurationItemForm').form('validate')){
					var _cno = $('#edit_cno').val();
					var _cname = $('#edit_cname').val();
					var _iconPath = $('#edit_iconPath').val();
					var _description = $('#edit_description').val();
					var _categoryType = $('#edit_category').val();
					
					var _url = "configuration!update.action";
					var _params = {
						"configurationItemsDto.cno" : _cno,
						"configurationItemsDto.cname" : _cname,
						"configurationItemsDto.iconPath" : _iconPath,
						"configurationItemsDto.description" : _description,
						"configurationItemsDto.categoryType" : _categoryType
					};
					
					$.post(_url,_params,function (r) {
						itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
						msgShow(i18n['msg_edit_successful'],'show');

					},'json');
		
				}
			}
		},

		/**
		 * @description  加载扩展属性下拉列表.
		 */
		loadEavsToSelect:function(select){
			$(select).html('');
			$('<option value="">--'+i18n['pleaseSelect']+'--</option>').appendTo(select);
			var url = "eav!findEavEntity.action";
			$.post(url,"rows=10000", function(res){
				if(res.data!=null){
					if(res.data.length>0){
						for(var i=0;i<res.data.length;i++){
							$("<option value='"+res.data[i].eavNo+"'>"+res.data[i].eavName+"</option>").appendTo(select);
						}
					}
				}
			});
				
		},

		init:function(){
			
			
			showAndHidePanel('#configItemCategoryContent','#configItemCategoryLoading');//隐显面板
			
			itsm.config.categoryManage.CICategoryTree.init();//加载树结构
			
			$('#cicategory_save_data').click(itsm.config.categoryManage.CICategory.updateConfigItemCategory);//绑定事件
			$('#cicategory_save_sub').click(itsm.config.categoryManage.CICategory.saveConfigItemCategory);//绑定事件
			itsm.config.categoryManage.CICategory.loadEavsToSelect("#edit_category");//加载列表
			itsm.config.categoryManage.CICategory.loadEavsToSelect("#add_category");//加载列表
			
		}
		
		
	};
	

	
	

 }();
 $(document).ready(itsm.config.categoryManage.CICategory.init);
