/**  
 * @author Tan  
 * @constructor Van
 * @description "configureItemCategory"
 * @date 2010-11-17
 * @since version 1.0 
 */ 
$package('itsm.config.categoryManage');



itsm.config.categoryManage.CICategoryTree=function(){
	
	
	return {
		
		/**
		 * 显示配置项分类树.
		 */
		showCICategoryTree:function(){
			
			$("#configureItemCategoryTree_div").jstree({
				"json_data":{
					ajax: {
						url : "configuration!getConfigurationCategoryTree.action",
						cache: false
					}
				},
				"dnd": {
					"drag_check": function() {alert(1)} 
				},
				"plugins" : [ "themes", "json_data", "ui", "crrm", "cookies","dnd","search","types","hotkeys","contextmenu"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind("delete_node.jstree", itsm.config.categoryManage.CICategoryTree.removeNode)
			.bind("select_node.jstree", itsm.config.categoryManage.CICategoryTree.selectNode)
			.bind("move_node.jstree", itsm.config.categoryManage.CICategoryTree.moveNode);
		},

		/**
		 * 选择节点.
		 */
		selectNode:function(event, data){
			var obj = data.rslt.obj;
			var _parent = data.inst._get_parent();
			var _parentNo = '';
			var _parentName = '';
			var _categoryType='';
			var icon=data.rslt.obj.attr('iconPath');
			
				
			//不允许修改父节点
			if(_parent==-1){
				$("#edit_cname").attr("disabled","true");
			}else{
				$("#edit_cname").attr("disabled","");
			}
			
			if (_parent!=-1 && _parent.attr('cno')!=null) {

				_parentNo = _parent.attr('cno');
				_categoryType=data.rslt.obj.attr('categoryType');
			}

			$('#edit_cno').val(obj.attr('cno'));
			$('#edit_cname').val(obj.attr('cname'));
			$('#edit_iconPath').val(icon);
			$('#edit_description').val(obj.attr('description'));
			$('#add_parentNo').val(obj.attr('cno'));
			$('#edit_category').val(_categoryType+"");
			
			$('#edit_showIconPanel').html("<img src='../upload/images/"+icon+"' width='30px' height='30px' />");
		},
		
		/**
		 * @description 拖拽节点
		 */
		moveNode:function (e, data) {
			
			data.rslt.o.each(function (i) {

				   var tag=data.rslt.cy;
				   
					var _cno = data.rslt.o.attr("cno");
					var _pno = data.rslt.np.attr("cno");
				   
				   if(tag==true){//复制
					   itsm.config.categoryManage.CICategoryTree.moveNode_copy(_cno,_pno);
		
				   }else{//剪切
					   itsm.config.categoryManage.CICategoryTree.moveNode_cut(_cno,_pno);
				   }
			});
		},

		 /**
		  * @description 复制树节点.
		  */
		moveNode_copy:function (_cno, _pno) {
			
			var _url = "configuration!copyCICategory.action";
			var _params = {
				"configurationItemsDto.cno" : _cno,
				"configurationItemsDto.parentNo" : _pno
			};
			$.post(_url,_params,
				function (r) {
					if(r && !r.status) {
						$.jstree.rollback(data.rlbk);  
					}else{
						itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
						msgShow(i18n['msg_operationSuccessful'],'show');
					}
				},
				'json'
			);
		},
		
		/**
		 * @description 剪切树节点.
		 */
		moveNode_cut:function (_cno, _pno) {
			
			
			var _url = "configuration!changeParent.action";
			var _params = {
				"configurationItemsDto.cno" : _cno,
				"configurationItemsDto.parentNo" : _pno
			};
			$.post(_url,_params,
				function (r) {
					if(r && !r.status) {
						$.jstree.rollback(data.rlbk);  
					}else{
						itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
						msgShow(i18n['msg_operationSuccessful'],'show');
					}
				},
				'json'
			);
		},
		
		/**
		 * @description 删除节点.
		 */
		removeNode:function (e, data) {
			var _url = "configuration!remove.action";
			var _params = {
				"configurationItemsDto.cno" : data.rslt.obj.attr("cno")
			};
			
			$.post(_url,_params,
				function (r) {
					if(r && !r.status) {
						$.jstree.rollback(data.rlbk);  
					}else{
						itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
						msgShow(i18n['msg_operationSuccessful'],'show');
					}
				},
				'json'
			);
		},
		
		init:function(){
			
			itsm.config.categoryManage.CICategoryTree.showCICategoryTree();
		}
		
	};


 }();

