 /**  
 * @author Tan  
 * @constructor Van
 * @description "eventCategory"
 * @date 2010-11-17
 * @since version 1.0 
 */ 
$package('itsm.config.categoryManage');
$import('itsm.config.categoryManage.eventCategoryTree');

itsm.config.categoryManage.eventCategory = function(){
	
	

	this.param = $('#'+_categoryCode+'CategoryDiv #eventCategoryTree [name="myTree"]').val();
	
	this.loadCategoryFlag="0";
	

	return {
		
		

			full:function(selector){
				
				return $('#'+_categoryCode+"CategoryDiv " + selector);
			},
			
			/**
			 * @description 修改分类信息.
			 */
			updateCategory:function() {
				
				var eventId=$('#eventId_'+_categoryCode).val();
				
				if(eventId==null || eventId==''){
					msgAlert(i18n['msg_msg_pleaseChooseCategory'],'error');
				}else{
					
					if(itsm.config.categoryManage.eventCategory.full('#editEventCategoryTree form').form('validate')){
					
						var editForm = itsm.config.categoryManage.eventCategory.full('#editEventCategoryTree form').serialize();
						var _url = "event!update.action";
						
						$.post(_url,editForm,
							function (r) {
							
								itsm.config.categoryManage.eventCategoryTree.showCategoryTree( itsm.config.categoryManage.eventCategory.full("#eventCategoryTree"));
								msgShow(i18n['msg_edit_successful'],'show');
							},
							'json'
						);
					}
				}
			},
			
			/**
			 * @description 新增子分类.
			 */
			addCategory:function() {
				
	
				var parentEventId=$('#parentEventId_'+_categoryCode).val();
				
				var rootId = itsm.config.categoryManage.eventCategory.full('#eventCategoryTree').find('li').length;
				
				if( (parentEventId==null || parentEventId=='') && rootId > 0){
					
					msgAlert(i18n['msg_msg_pleaseChooseParent'],'error');
					
				}else{
					
					
					if(itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree form').form('validate')){
					    var addForm = itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree form').serialize();
					    if(rootId>0){
					    	$.post('event!save.action', addForm, function(r){
					    		 itsm.config.categoryManage.eventCategoryTree.showCategoryTree( itsm.config.categoryManage.eventCategory.full("#eventCategoryTree"));
							     itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree [name="eventCategoryDto.eventName"]').val("");
								 itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree [name="eventCategoryDto.eventDescription"]').val("");
								 msgShow(i18n['msg_add_successful'],'show');
							    },'json'); 
					    }else{
					    	 $.post('event!save.action', addForm+"&eventCategoryDto.categoryRoot="+param, function(r){
					    		 itsm.config.categoryManage.eventCategoryTree.showCategoryTree( itsm.config.categoryManage.eventCategory.full("#eventCategoryTree"));
							     itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree [name="eventCategoryDto.eventName"]').val("");
								 itsm.config.categoryManage.eventCategory.full('#addEventCategoryTree [name="eventCategoryDto.eventDescription"]').val("");
								 msgShow(i18n['msg_add_successful'],'show');
							    },'json');
						    
					    }
					}
				}
				    
			},
			
			init:function(){
				
				 $("#evetCategoryLoading_"+_categoryCode).hide();
				 $("#evetCategoryContent_"+_categoryCode).show();	
				 
				 itsm.config.categoryManage.eventCategoryTree.showCategoryTree( itsm.config.categoryManage.eventCategory.full("#eventCategoryTree"));
				 
				 $("#save_data_"+_categoryCode).click(itsm.config.categoryManage.eventCategory.updateCategory);	
				 $("#save_sub_"+_categoryCode).click(itsm.config.categoryManage.eventCategory.addCategory);	
			}
		
	};
		
 }();
 
 $(document).ready(itsm.config.categoryManage.eventCategory.init);
 

