/**  
 * @author Van  
 * @constructor Van
 * @description "eventCategory"
 * @date 2010-11-17
 * @since version 1.0 
 */ 

$package('itsm.config.categoryManage');

itsm.config.categoryManage.eventCategoryTree=function(){
	
	return {
		
		 /**
		  * @description 加载分类树.
		  */
		  showCategoryTree:function(treeID) {
		
	          $(treeID).jstree({
					json_data: {
						ajax: {
						  type:"post",
						  url : "event!getCategoryTree.action",
					      data: {'types': param},//types is in action
		                  dataType: 'json',
		                  cache:false
						}
					},
				"plugins" : [ "themes", "json_data", "ui", "crrm", "cookies", "dnd", "search", "types", "hotkeys", "contextmenu"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind("delete_node.jstree",itsm.config.categoryManage.eventCategoryTree.removeNode)
			.bind("select_node.jstree",itsm.config.categoryManage.eventCategoryTree.selectNode)
			.bind("move_node.jstree", function(e,data){
				
				itsm.config.categoryManage.eventCategoryTree.moveNode(e,data,treeID);
				
			});
			
		 },
	
		  
		  
		  /**
		   * @description 删除节点.
		   */
		  removeNode:function (e, data) {
					var _url = "event!remove.action";
					var _params = { 
						"eventCategoryDto.eventId" : data.rslt.obj.attr("id")
					};
					$.post(_url,_params,
						function (r) {
							if(r && !r.status) {
								$.jstree.rollback(data.rlbk);
							}else{
								
								msgShow(i18n['msg_operationSuccessful'],'show');
							}
						},
						'json'
					);
			},
		  
			
	
		  /**
		   * @description 拖拽节点.
		   */
			moveNode :function (e, data,treeId) {
				data.rslt.o.each(function (i) {
					   var tag=data.rslt.cy;
					   var _cno = data.rslt.o.attr("id");
					   var _pno = data.rslt.np.attr("id");
					   if(tag==true){
						   
						   //复制
						   itsm.config.categoryManage.eventCategoryTree.moveNode_copy(_cno,_pno,treeId);
						   
					   }else{
						   
						   //剪切
						   itsm.config.categoryManage.eventCategoryTree.moveNode_cut(_cno,_pno,treeId);
					   }
					   
				
				});
	
			},
			
			/**
			 * @description 复制方法.
			 */
			moveNode_copy:function(_cno,_pno,treeId){
				
				 
				 var _url = "event!copyCategory.action";
					var _params = {
						"eventCategoryDto.eventId" : _cno,
						"eventCategoryDto.parentEventId" : _pno
					};
					$.post(_url,_params,
						function (r) {
							if(r && !r.status) {
								$.jstree.rollback(data.rlbk);  
							}else{
							
								itsm.config.categoryManage.eventCategoryTree.showCategoryTree(treeId);
								msgShow(i18n['msg_operationSuccessful'],'show');
							}
						},
						'json'
					);
			},
			
			 /**
			  * @description 剪切方法.
			  */
			moveNode_cut:function(_cno,_pno,treeId){
				
				var _url = "event!changeParents.action";
				var _params = {
					"eventCategoryDto.eventId" : _cno,
					"eventCategoryDto.parentEventId" : _pno
				};
				$.post(_url,_params,
					function (r) {
						if(r && !r.status) {
							$.jstree.rollback(data.rlbk);  
						}else{
							
							itsm.config.categoryManage.eventCategoryTree.showCategoryTree(treeId);
							
							msgShow(i18n['msg_operationSuccessful'],'show');
						}
					},
					'json'
				);
				
			},
		  
			 /**
			  * @description 单击节点.
			  */
			selectNode :function (e, data) {
				
				var obj = data.rslt.obj;
				var _parent = data.inst._get_parent();
				var _parentNo = null;
				//不允许修改父节点
				if(_parent==-1){
					
					$('#eventName_'+_categoryCode).attr("disabled","true");
	
				}else{
					
					$('#eventName_'+_categoryCode).attr("disabled","");
				}
				
				if (_parent!=-1 && _parent.attr('eventId')) {
					_parentNo = _parent.attr('id');
				}
				
				$('#eventId_'+_categoryCode).val(obj.attr('id'));
				$('#eventName_'+_categoryCode).val(obj.attr('cname'));
				$('#eventDescription_'+_categoryCode).val(obj.attr('description'));
				$('#parentEventId_'+_categoryCode).val(obj.attr('id'));
		 },
		 
		 
		 /**
		  * 公共模块，选择树
		  */
		 showSelectTree:function(windowId,treePanel,param,namePut,idPut){
			 
			 $(windowId).window('open');//打开窗口
			 
			   $(treePanel).jstree({
					json_data: {
						ajax: {
						  type:"post",
						  url : "event!getCategoryTree.action",
					      data: {'types': param},//types is in action
		                  dataType: 'json',
		                  cache:false
					 }
					},
					plugins : ["themes", "json_data", "ui", "crrm"]
			})
			.bind('loaded.jstree', function(e,data){data.inst.open_all(-1);})
			.bind("select_node.jstree",function(e,data){
				$(namePut).val(data.rslt.obj.attr("cname"));
				$(idPut).val(data.rslt.obj.attr("id"));
				$(windowId).window('close');//关闭窗口
			});
	 
		 },
		 //add mars 
		 /**
		  * 选择变更分类.
		  */
		 changeCategory:function(namePut,idPut){
			 
			 itsm.config.categoryManage.eventCategoryTree.showSelectTree('#change_category_select_window','#change_category_select_tree','Change',namePut,idPut);
		 },
		 
		 /**
		  * 选择问题分类.
		  */
		 problemCategory:function(namePut,idPut){
			 
			 itsm.config.categoryManage.eventCategoryTree.showSelectTree('#problem_category_select_window','#problem_category_select_tree','Problem',namePut,idPut);
		 },
		 
		 
		 /**
		  * 选择请求分类.
		  */
		 requestCategory:function(namePut,idPut){
			 
			 itsm.config.categoryManage.eventCategoryTree.showSelectTree('#request_category_select_window','#request_category_select_tree','Request',namePut,idPut);
		 },
		 
		 
		 init:function(){
			 itsm.config.categoryManage.eventCategoryTree.showCategoryTree();
		 }
	};
		

 }();
 
 

