/**  
 * @author tan  
 * @constructor dictionary
 * @description "dictionary"
 * @date 2010-11-17
 * @since version 1.0 
 */  
$package('itsm.config.dataDictionary');

itsm.config.dataDictionary.dataDictionaryGrid = function(){
	
	
	this.dcOperation='';
	

	function $dcfull(selector) {
		return $("#dataDicionaryMain_content_"+_groupCode+" " + selector);
	}
	
	
	function $groupCode(panelDIV) {
		return panelDIV+"_"+_groupCode;
	}
	
	
	return {
		
		
		/**@description 类表菜单*/
		showDataDictionaryGrid:function(){
			
			
			var params = $.extend({},jqGridParams, {	
	
				url :'dataDictionaryItems!find.action?dataDictionaryQueryDto.groupCode='+_groupCode,
				caption :i18n['dataDictionary'],
				colNames:[i18n['name'],i18n['description'],i18n['remark'],'',''],
				colModel:[
							{name:'dname',width:20,align:'center',sortable:true},
							{name:'description',align:'center',width:40,sortable:true},
							{name:'remark',align:'center',width:40,sortable:true},
							{name:'groupCode',hidden:true},	
							{name:'dcode',hidden:true}			
					    ],
				jsonReader : $.extend(jqGridJsonReader, {
					id : "dcode"
				}),
				sortname : 'dcode',
				pager : $groupCode('#dictionaryItemGridPager'),
				autowidth:true
			});
			$($groupCode('#dictionaryItemGrid')).jqGrid(params);
			$($groupCode('#dictionaryItemGrid')).navGrid($groupCode('#dictionaryItemGridPager'), navGridParams);
			//列表操作项
			$($groupCode('#t_dictionaryItemGrid')).css(jqGridTopStyles);
			$($groupCode('#t_dictionaryItemGrid')).append($dcfull('#dataDictionaryGridToolbar').html());
			//自适应宽度
			setGridWidth($groupCode('#dictionaryItemGrid'),"regCenter",10);
		},
		
		
		addDictionaryItem:function(){
				
			//清空框内内容
			$dcfull($groupCode('#addEditDictionaryWindow')+' [name="dataDictionaryItemsDto.dname"]').val("");
			$dcfull($groupCode('#addEditDictionaryWindow')+' [name="dataDictionaryItemsDto.description"]').val("");
			$dcfull($groupCode('#addEditDictionaryWindow')+' [name="dataDictionaryItemsDto.remark"]').val("");
			$dcfull($groupCode('#addEditDictionaryWindow')).window('open');
			dcOperation = 'save';
		},
		

		/**
		 * @description 保存数据字典.
		 * 
		 */
		saveDictionary:function(){		
			
			vaildateForm($groupCode('#addDataDictionaryForm'),function(){
				
				var ser = $($groupCode('#addDataDictionaryForm')).serialize();		
				var url = "dataDictionaryItems!"+dcOperation+".action";		
				$.post(url, ser, function(){
					$dcfull($groupCode('#addEditDictionaryWindow')).window('close');
					$($groupCode('#dictionaryItemGrid')).trigger('reloadGrid');			
					msgShow(i18n['saveSuccess'],'show');
				});	
			})
		},

		 /**
		  * @description 删除数据字典.
		  */
		delDictionary:function(){
			
			checkBeforeDeleteGrid($groupCode('#dictionaryItemGrid'),function(rowIds){				
				var _param = $.param({'dcode':rowIds},true);
				$.post("dataDictionaryItems!delete.action", _param, function(data){
					if(data){
						
						msgShow(i18n['msg_deleteSuccessful'],'show');
						$($groupCode('#dictionaryItemGrid')).jqGrid('setGridParam',{page:1}).trigger('reloadGrid'); 
						
					}else{
						msgAlert(i18n['systemDataNotDelete'],'info');
					}
				}, "json");		
				
			});
		},
		
		
		/**
		 * 
		 */
		openSearchWindow:function(){
			
			$dcfull('#searchDataDictionaryDiv').window('open');
		},
	
		 /**
		  * @description 编辑数据字典.
		  */
		editDictionary:function() {		
			
			checkBeforeEditGrid($groupCode('#dictionaryItemGrid'),function(data){
				
				$dcfull("#dcode").val(data.dcode);
				$dcfull("#dname").val(data.dname);
				$dcfull("#description").val(data.description);
				$dcfull("#remark").val(data.remark);
				$dcfull("#groupCode").val(data.groupNo);
			
				dcOperation = 'merge';	
				$dcfull($groupCode('#addEditDictionaryWindow')).window('open');
				
			});
		},
		
		 /**@description 搜索*/
		searchDictionary:function() {		
			
			var sdata = $dcfull('#searchDataDictionaryDiv form').getForm();
			var postData = $($groupCode('#dictionaryItemGrid')).jqGrid("getGridParam", "postData");  
	
			$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
			var _url = 'dataDictionaryItems!find.action';		
			$($groupCode('#dictionaryItemGrid')).jqGrid('setGridParam',{url:_url}).trigger('reloadGrid'); 
			
			return false;
		},
		
		
		/**
		 * 导出数据到Excel
		 */
		exportData:function(){
			
			var extype=$dcfull("#exportDataDc").val();
			if(extype=="view"){
				
				itsm.config.dataDictionary.dataDictionaryGrid.exportView();
				
			}
			if(extype=="all"){
				
				msgAlert(i18n["msg_dc_comfirmExport"],"question");
			}
		},
		
		
		exportView:function(){

			var sdata = $dcfull('#searchDataDictionaryDiv form').getForm();
			var dnData = $($groupCode('#dictionaryItemGrid')).jqGrid("getGridParam", "postData"); 
			for(i in sdata){    	 
				
				if(sdata[i]!=""&&sdata[i]!=null){ 
				   if(i=='dataDictionaryQueryDto.dname'){$('#exportDictionary_dname').val(sdata[i]); }
				   if(i=='dataDictionaryQueryDto.description')$('#exportDictionary_description').val(sdata[i]);
				}
			}
			
			$('#exportDictionary_sidx').val(dnData.sidx);
			$('#exportDictionary_sord').val(dnData.sord);
			$('#exportDictionary_page').val(dnData.page);
			$('#exportDictionary_rows').val(dnData.rows);
			$dcfull("#exportDictionaryWindow form").submit();
		},
		
		
		/**
		 * 导入数据.
		 */
		importData:function(){
			
			$dcfull('#importDataWindow').window('open');
	
		},
		
		/**
		 * @description 客户端导入数据.
		 */
		importExcel:function(){    
			
				$.ajaxFileUpload({
		            url:'dataDictionaryItems!importData.action?groupNo='+_groupCode,
		            secureuri:false,
		            fileElementId:'importFile_'+_groupCode, 
		            dataType:'json',
		            success: function(data,status){
		             	$dcfull('#importDataWindow').window('close');
		             	$($groupCode('#dictionaryItemGrid')).trigger('reloadGrid'); 
		            	if(data=="-2"){
	
		            		msgAlert(i18n['msg_dc_fileNotExists'],'error');
							
						}else if(data=="-1"){
	
							msgAlert(i18n['msg_dc_fileNotExists'],'error');
							
						}else if(data=="0"){
							
							msgShow(i18n['msg_dc_noEffect'],'show');
							
						}else{
							
							msgShow(i18n['msg_dc_importSuccess'].replace('N',data),'show');
						}
		            }
		        });
		},
		
		
		init:function(){
			
			$($groupCode("#dataDicionaryMain_loading")).hide();
			$($groupCode("#dataDicionaryMain_content")).show();
			
			
			itsm.config.dataDictionary.dataDictionaryGrid.showDataDictionaryGrid();//加载数据列表
			$dcfull('#saveDataDictionaryBtn').click(itsm.config.dataDictionary.dataDictionaryGrid.saveDictionary);//绑定事件
			$dcfull('#searchDataDictionaryBtn').click(itsm.config.dataDictionary.dataDictionaryGrid.searchDictionary);//绑定事件
			
//			$dcfull('#dictionaryItemGrid_add').click(itsm.config.dataDictionary.dataDictionaryGrid.addDictionaryItem);//绑定事件
//			$dcfull('#dictionaryItemGrid_edit').click(itsm.config.dataDictionary.dataDictionaryGrid.editDictionary);//绑定事件
//			$dcfull('#dictionaryItemGrid_delete').click(itsm.config.dataDictionary.dataDictionaryGrid.delDictionary);//绑定事件
//			$dcfull('#dictionaryItemGrid_search').click(function(){
//				$dcfull('#searchDataDictionaryDiv').window('open');
//			});//绑定事件
		
			$dcfull('#exportDataDc').change(itsm.config.dataDictionary.dataDictionaryGrid.exportData);//导出
			$dcfull('#importDataDc').change(itsm.config.dataDictionary.dataDictionaryGrid.importData);//导入
			$dcfull('#importDataDictionaryBtn').click(itsm.config.dataDictionary.dataDictionaryGrid.importExcel);//导出
			
		}
	};
	
}();
$(document).ready(itsm.config.dataDictionary.dataDictionaryGrid.init);
