 /**  
 * @fileOverview "dictionaryGroup"
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor dictionaryGroup
 * @description "dictionaryGroup"
 * @date 2010-11-17
 * @since version 1.0 
 */ 
var dictionaryGroup = function(){
	 
	/**
	 * @description 数据字典分组列表
	 * */
	this.show_grid=function()
	{		
		$('#dataDictionaryGroupsGrid').jqGrid({				
			url:'dataDictionaryGroup!find.action',	//返回PageDTO的URL	
			mtype:'post',
			datatype:'json',			
			autowidth:true, 
			height:'auto',
			colNames:[i18n['number'],i18n['name']],
			colModel:[
					{name:'groupNo',index:'groupNo',width:80,sorttype:'Long',sortable:true},					
					{name:'groupName',index:'groupName',width:100,edittype:'select',editable:'true'}			
			    ],
			    viewrecords:true,
			    multiselect: true,
			    caption:'数据字典分组列表',
			    jsonReader: {
					root: "data",
					records: "totalSize",
					page: "page",
					total: "total",
					repeatitems : false,
					id: "groupNo"			
		     },		    	     
		     rowNum:10,
		     rowList:[10,20,30],
		     toolbar: [true,"top"],
		     pager:'#dataDictionaryGroupsPager',
		     hidegrid:false
		})
		.navGrid('#dataDictionaryGroupsPager',{"edit":false,"add":false,"del":false,"search":false,"view":false,"refresh":true,"refreshtext":i18n['refresh']});
		
		
		$('#t_dataDictionaryGroupsGrid')
		.css("padding-top","5px")
		.css("padding-bottom","10px")
		.css("border-top","none")
		.css("background","#eee")
		.css("text-align","left");


		$('#t_dataDictionaryGroupsGrid').append($('#dataDictionaryGroupsToolbar').html());
		
		
		
	}	
	
	
	this.addDictionaryItem=function(){
		
		$('#addDataDictionaryGroupDiv').window('open');
		operator = 'saveGroup';
	}
	
	
	this.searchDictionaryItem=function(){
		
		$('#searchDataDictionaryGroupDiv').window('open');
	}
	
	this.operator;
	
	 /**
	  * @description 新增
	  * */
	this.saveDictionaryGroups = function(){		
		var bb = $('#addDataDictionaryGroupDiv form').serialize();
		var url = "dataDictionaryGroup!"+operator+".action";
		var _groupNo=$('#add_groupNo').val();
		$.post(url, bb, function(){
			$('#addDataDictionaryGroupDiv').window('close');
			$('#dataDictionaryGroupsGrid').trigger('reloadGrid');
			
			
			//清空框内内容
			$('#addDataDictionaryGroupDiv [name="ddgDto.groupNo"]').val("");
			$('#addDataDictionaryGroupDiv [name="ddgDto.groupName"]').val("");
		});	

	}
	
	
	   /**
	    * @description 删除
	    * */
	this.delDictionaryGroups = function()
	{		
		var rowIds = $('#dataDictionaryGroupsGrid').jqGrid('getGridParam','selarrrow');
		
	
		
		if(rowIds==""){
			
			$.messager.alert(i18n['tip'],'<br/>'+i18n['selectDeleteDataTip'],'info');
		}
		else{
			
			var _param = $.param({'dcode':rowIds},true);
			
			//条件的判断是否删除
			    if(_param != null && _param != '') 
			    {
			    	
			    	$.messager.confirm(i18n['tip'], '<br/>'+i18n['deleteComfirm'], function(r){
						if (r)
						{
							
							$.post("dataDictionaryItems!delete.action", _param, function(){
								$('#dataDictionaryGroupsGrid').trigger('reloadGrid');
							}, "json");		
							
						}
			    	});
			    	
			   }
			
		}
			
			
		
		
		
	}

	 /**
	  * @description 编辑
	  * */
	this.editDictionaryGroups = function() {		
		
		operator = 'merge';	
		
		var rowId = $('#dataDictionaryGroupsGrid').jqGrid('getGridParam','selarrrow');
		if(rowId=='') {
			$.messager.alert(i18n['tip'],'<br>'+i18n['selectEditDataTip'],'info');
		} else {			
			var data = $('#dataDictionaryGroupsGrid').getRowData(rowId);
			
			$full("#dcode").val(data.dcode);
			$full("#dname").val(data.dname);
			$full("#description").val(data.description);
			$full("#remark").val(data.remark);
			$full("#groupNo").val(data.groupNo);
			$full("#dflag").val(data.dflag);		
			$full("#addDataDictionaryDiv").window('open');
	   }
	}
	
	 /**
	  * @description 搜索
	  * */
	this.searchDictionaryGroups = function() {		
		var sdata = $('#searchDataDictionaryGroupDiv form').getForm();
		var postData = $('#dataDictionaryGroupsGrid').jqGrid("getGridParam", "postData");  
		$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
		var _url = 'dataDictionaryGroup!find.action';		
		$('#dataDictionaryGroupsGrid').jqGrid('setGridParam',{url:_url})
		.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
		return false;
	}
	
	
	
	
	//载入 
	return {
		init: function() 
		{	
			//加载数据列表
			show_grid();
			
			//创建事件
			$('#link_dataDictionary_add_ok').click(saveDictionaryGroups);
			$('#link_dataDictionary_search_ok').click(searchDictionaryGroups);
					
		}
	}
}();
$(document).ready(dictionaryGroup.init);
