$package('itsm.config.eav')
/**  
 * @fileOverview 扩展属性主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 扩展属性主函数
 * @description 扩展属性主函数
 * @date 2010-11-17
 * @since version 1.0 
 */  
itsm.config.eav.eavCi = function(){
	var eavNo;
	this.operator;
	return { 
		/**@description 扩展属性*/
		eavCi_grid:function(){		
			var params = $.extend({},jqGridParams,{	
				url:'eav!findEavEntity.action',
				caption:i18n['extendedAttribute']+i18n['managerment'],
				colNames:[i18n['name'],i18n['description'],''],
				colModel:[{name:'eavName',width:40,align:'center'},
						{name:'desc',width:60,align:'center',sortable:false},
						{name:'eavNo',hidden:true}
				    ],
				jsonReader: $.extend(jqGridJsonReader, {id: "eavNo"}),
				sortname:'eavNo',
				pager:'#eavCiPager',
				onSelectRow:itsm.config.eav.eavCi.reloadEavAttrs
				});
				$("#eavCiList").jqGrid(params);
				$("#eavCiList").navGrid('#eavCiPager',navGridParams);
				//列表操作项
				$("#t_eavCiList").css(jqGridTopStyles);
				$("#t_eavCiList").append($('#eavCiToolbar').html());
				
				//自适应宽度
				setGridWidth("#eavCiList","regCenter",10);
		},
	
		 /**@description 添加属性*/
		addEav:function(){
			operator="saveEavEntity"
			resetForm('#addEavCiDivForm');
			$('#addEavCiDiv').window('open');
		},
		
		
		/**@description 保存属性*/
		saveEav:function(){		
			if($('#addEavCiDivForm').form('validate')){
				var _params = $('#addEavCiDiv form').serialize();
				$.post('eav!'+operator+'.action', _params, function(){
					msgShow(i18n['saveSuccess'],'show');
					$('#eavCiList').trigger('reloadGrid');
					$('#add_eavName').val('');
					$('#add_entityDesc').val('');
					$('#addEavCiDiv').window('close');
				});
			}
		},
		editEav:function(){
			checkBeforeEditGrid("#eavCiList",itsm.config.eav.eavCi.editEav_opt);
		},
		
		editEav_opt:function(rowsData){
			operator="updateEavEntity"
			$('#add_eavNo').val(rowsData.eavNo);
			$('#add_eavName').val(rowsData.eavName);
			$('#add_entityDesc').val(rowsData.desc);
			$('#addEavCiDiv').window('open');
		},
		
		deleteEav:function(){
			checkBeforeDeleteGrid("#eavCiList",itsm.config.eav.eavCi.deleteEav_opt);
		},
		
		deleteEav_opt:function(rowIds){
			var _params = $.param({'eavNos':rowIds},true);
			$.post('eav!deleteEavEntity.action', _params, function(){
				
				msgShow(i18n['deleteSuccess'],'show');
				$('#eavCiList').trigger('reloadGrid');
			})
		},
	
		 /**@description 扩展属性列表 */
		eavAttrsList:function(){	
			var params = $.extend({},jqGridParams, {	
				url:'attrs!find.action?attrsQueryDTO.eavNo=0',
				caption:i18n['extendedAttribute']+i18n['list'],
				colNames:[i18n['name'],i18n['type'],i18n['length'],'',''],
				colModel:[
						{name:'attrAsName',width:50,align:'center'},
						{name:'attrType',width:30,align:'center'},
						{name:'length',width:20,align:'center'},
						{name:'attrNo',hidden:true},
						{name:'attrName',hidden:true}
				    ],
				jsonReader: $.extend(jqGridJsonReader, {id: "attrNo"}),
				sortname:'attrNo',
				pager:'#eavAttrsPager',
				onSelectRow:itsm.config.eav.eavCi.voidMethod
				});
			
				$("#eavAttrsList").jqGrid(params);
				$("#eavAttrsList").navGrid('#eavAttrsPager',navGridParams);
				//列表操作项
				$("#t_eavAttrsList").css(jqGridTopStyles);
				$("#t_eavAttrsList").append($('#eavAttrsToolbar').html());
				
				//自适应宽度
				setGridWidth("#eavAttrsList","regCenter",10);
		},	
		
		voidMethod:function(){
			
		},
		
	
		
		/**@description 根据ID刷新扩展属性 */
		reloadEavAttrs:function(id){
			eavNo=id;
			var _url = 'attrs!find.action?attrsQueryDTO.eavNo='+id;	
			$('#eavAttrsList').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
		},
		
		 /**@description 新增扩展属性 */
		openAttrsDiv:function(){
			if(eavNo==null || eavNo==""){
				msgAlert(i18n['msg_chooseEav'],'info');	
			}else{
				$('#addAttrDiv').window('open');			
			}
		},
		
		 /**@description 新增 扩展属性  */
		saveAttrs:function(){	
			if($('#addAttrForm').form('validate')){
				var form = $('#addAttrDiv form').serialize();
				form=form+"&attributesDTO.eavNo="+eavNo
				$.post('attrs!save.action', form, function(){
					$('#addAttrDiv').window('close');
					$('#eavAttrsList').trigger('reloadGrid');
					msgShow(i18n['saveSuccess'],'show');
					$('#add_attrName').val('');
					$('#add_attrAsName').val('');
					$('#add_length').val('0');

				});
			}
		},
		
		 /**@description 编辑扩展属性 */
		openEditAttrsDiv:function(){
			checkBeforeEditGrid("#eavAttrsList",itsm.config.eav.eavCi.editAttrsMethod);
		},
		
		   /**@description 编辑扩展属性Method */
		editAttrsMethod:function(rowData){
			$('#edit_attrNo').val(rowData.attrNo);
			$('#edit_attrName').val(rowData.attrName)
			$('#edit_attrAsName').val(rowData.attrAsName)
			$('#edit_attrType').val(rowData.attrType)
			$('#edit_length').val(rowData.length)
			$('#editAttrDiv').window('open');
		},

		/**@description 编辑 扩展属性  */
		editSaveAttrs:function(){		
			if($('#editAttrForm').form('validate')){
				var _params = $('#editAttrDiv form').serialize();
				_params=_params+"&attributesDTO.eavNo="+eavNo
				$.post('attrs!update.action', _params, function(){
					$('#editAttrDiv').window('close');
					$('#eavAttrsList').trigger('reloadGrid');
					msgShow(i18n['editSuccess'],'show');
					$('#edit_attrName').val('');
					$('#edit_attrAsName').val('');
					$('#edit_length').val('0');
				});
			}
		},
		
		/**@description 删除属性   */
		deleteEavAttrs:function(){
			checkBeforeDeleteGrid("#eavAttrsList",itsm.config.eav.eavCi.deleteEavAttrsMethod);
		},
		
		 /**@description  删除 */
		deleteEavAttrsMethod:function(rowIds){
			var pp = $.param({'attrsIds':rowIds},true);
			$.post("attrs!delete.action", pp, function(data){
					$('#eavAttrsList').trigger('reloadGrid');
					msgShow(i18n['deleteSuccess'],'show');
			}, "json");
		},
		init: function() 
		{	
			showAndHidePanel("#eavCi_panel","#eavCi_loading");
			//扩展名
			itsm.config.eav.eavCi.eavCi_grid();
			
					
		}
	}
}();
$(document).ready(itsm.config.eav.eavCi.init);
