$package('itsm.config.serviceDirectory')
/**  
 * @fileOverview 服务目录管理主函数
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor 服务目录管理主函数
 * @description 服务目录管理主函数
 * @date 2010-11-17
 * @since version 1.0 
 */  

itsm.config.serviceDirectory.serviceDirectoryAdmin=function(){
	this.opt;
	return {
		/**
		 * 服务目录列表
		 */
		serviceDirectoryList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'sd!findPagerServiceDirectory.action',
				caption:i18n['title_service_directory'],
				colNames:[i18n['number'],i18n['name'],i18n['description'],i18n['operateItems']],
				colModel:[
			   		{name:'serviceDirectoryId',width:60,sortable:true},
			   		{name:'serviceDirectoryName',width:150},
			   		{name:'serviceDirectoryDesc',width:200,sortable:false},
			   		{name:'act',align:'center',sortable:false,formatter:itsm.config.serviceDirectory.serviceDirectoryAdmin.sdActFormatter}
			   	],		
				jsonReader: $.extend(jqGridJsonReader, {id: "serviceDirectoryId"}),
				sortname:'serviceDirectoryId',
				onSelectRow:function(rowId){itsm.config.serviceDirectory.serviceDirectoryAdmin.subServiceListReload(rowId)},
				pager:'#serviceDirectoryPager'
			});
			$("#serviceDirectoryGrid").jqGrid(params);
			$("#serviceDirectoryGrid").navGrid('#serviceDirectoryPager',navGridParams);
			//列表操作项
			$("#t_serviceDirectoryGrid").css(jqGridTopStyles);
			$("#t_serviceDirectoryGrid").append($('#serviceDirectoryGridToolbar').html());
			//自适应大小
			setGridWidth("#serviceDirectoryGrid","regCenter",10);
		},
		
		sdActFormatter:function(cell,opt,data){
			return $('#serviceDirectoryActFormatterDiv').html();
		},
		/**
		 * 服务目录添加窗口
		 */
		openSdAddWin:function(){
			$("#serviceDirectoryId").val('');
			$("#serviceDirectoryName").val('');
			$("#serviceDirectoryDesc").val('');
			opt='saveServiceDirectory';
			$('#serviceDirectoryAddOrEditDiv').window('open');
		},
		/**
		 * 服务目录编辑窗口
		 */
		openSdEditWin:function(rowData) {
			$("#serviceDirectoryName").val(rowData.serviceDirectoryName);
			$("#serviceDirectoryDesc").val(rowData.serviceDirectoryDesc);
			$("#serviceDirectoryId").val(rowData.serviceDirectoryId);
			opt='editServiceDirectory';
			$('#serviceDirectoryAddOrEditDiv').window('open');
		},
		
		/**
		 * 编辑
		 */
		sd_edit_aff:function(){
			checkBeforeEditGrid('#serviceDirectoryGrid', itsm.config.serviceDirectory.serviceDirectoryAdmin.openSdEditWin);
		},
		
		/**
		 * 服务目录添加编辑保存
		 */
	
		sdAddOrEditOpt:function(){
			if($("#serviceDirectoryName").val()!=''){
				var _params = $('#serviceDirectoryAddOrEditDiv form').serialize();
				$.post('sd!'+opt+'.action', _params, function(){
					$('#serviceDirectoryAddOrEditDiv').window('close');
					$('#serviceDirectoryGrid').trigger('reloadGrid');
					msgShow(i18n['addSuccess'],'show');
				})
			}else{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['err_nameNotNull'],'error');	
			}
		},
		
		
		/**
		 * 删除
		 */
		sd_delete_aff:function(){
			checkBeforeDeleteGrid('#serviceDirectoryGrid',itsm.config.serviceDirectory.serviceDirectoryAdmin.deleteSd);
		},
		
		/**
		 * 执行删除
		 */
		deleteSd:function(rowIds) {
			var _param = $.param({'ids':rowIds},true);
			$.post("sd!deleteServiceDirectory.action", _param, function(){
				$('#serviceDirectoryGrid').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'show');
			}, "json");
		},
		/**
		 * 查看服务
		 */
		viewSubService:function(){
			var rowId = $('#serviceDirectoryGrid').getGridParam('selrow');
			if(rowId==null)
			{
				$.messager.alert(i18n['msg_msg'],'<br/>'+i18n['msg_atLeastChooseOneData'],'info');
			}
			else
			{
				var rowData=$('#serviceDirectoryGrid').getRowData(rowId);
				itsm.common.utility.tabUtility.reOpenTab('../pages/config/serviceDirectory/subService.jsp?serviceDirectoryId='+rowData.serviceDirectoryId,i18n['title_adminSubService']);
			}
		},
		
		subServiceListReload:function(id){
			$('#subServiceId_serviceDirectoryId').val(id);
			var _url = 'sd!findPageSubService.action?ssqDto.serviceDirectoryId='+id;		
			$('#subServiceGrid').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
		},
		
		/**
		 * 服务列表
		 */
		subServiceList:function(){
			var params = $.extend({},jqGridParams, {	
				url:'sd!findPageSubService.action',
				caption:i18n['title_subService'],
				colNames:[i18n['number'],i18n['name'],i18n['description'],i18n['operateItems']],
				colModel:[
			   		{name:'subServiceId',width:60},
			   		{name:'subServiceName',width:150},
			   		{name:'subServiceDesc',width:200},
			   		{name:'act',hidden:true}
			   	],		
				jsonReader: $.extend(jqGridJsonReader, {id: "subServiceId"}),
				sortname:'subServiceId',
				pager:'#subServicePager'
			});
			$("#subServiceGrid").jqGrid(params);
			$("#subServiceGrid").navGrid('#subServicePager',navGridParams);
			//列表操作项
			$("#t_subServiceGrid").css(jqGridTopStyles);
			$("#t_subServiceGrid").append($('#subServiceGridToolbar').html());
			//自适应大小
			setGridWidth("#subServiceGrid","regCenter",10);
		},
		
		
		
		/**
		 * 服务添加窗口
		 */
		openSubServiceAddOrEditWin:function(){
			opt='saveSubService';
			if($('#subServiceId_serviceDirectoryId').val()!=''){
				$('#subServiceName').val('');
				$('#subServiceDesc').val('');
				$('#subServiceAddDiv').window('open');
			}else{
				
				msgAlert(i18n['msg_msg_pleaseChooseDirectory'],'info');
			}
			
		},
		/**
		 * 服务添加编辑保存
		 */
		subServiceAddOrEditOpt:function(){
			if($('#subServiceName').val()!=''){
				var _params = $('#subServiceAddDiv form').serialize();
				$.post('subService!'+opt+'.action', _params, function(){
					$('#subServiceAddDiv').window('close');
					$('#subServiceGrid').trigger('reloadGrid');
					msgShow(i18n['addSuccess'],'show');
				})
			}else{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['err_nameNotNull'],'error');	
			}
			
		},
		/**
		 * 服务编辑窗口
		 */
		openSubServiceEditWin:function(rowData) {
			$("#subServiceId").val(rowData.subServiceId);
			$("#subServiceName").val(rowData.subServiceName);
			$("#subServiceDesc").val(rowData.subServiceDesc);
			opt='editSubService';
			$('#subServiceAddDiv').window('open');
		},
		/**
		 * 编辑
		 */
		subService_edit_aff:function(){
			checkBeforeEditGrid('#subServiceGrid', itsm.config.serviceDirectory.serviceDirectoryAdmin.openSubServiceEditWin);
		},
		
		/**
		 * 删除
		 */
		subService_delete_aff:function(){
			checkBeforeDeleteGrid('#subServiceGrid', itsm.config.serviceDirectory.serviceDirectoryAdmin.deleteSubService);
		},
		
		/**
		 * 执行删除
		 */
		deleteSubService:function(rowIds) {
			var _param = $.param({'ids':rowIds},true);
			$.post("subService!deleteSubService.action", _param+"&sdId="+$('#subServiceId_serviceDirectoryId').val(), function(){
				msgShow(i18n['deleteSuccess'],'show');
				$('#subServiceGrid').trigger('reloadGrid');
			}, "json");
		},
	
		init:function(){
			showAndHidePanel("#serviceDirectoryManage_panel","#serviceDirectoryManage_loading");
			itsm.config.serviceDirectory.serviceDirectoryAdmin.serviceDirectoryList();
			//页面事件
			$('#serviceDirectory_add_but').click(itsm.config.serviceDirectory.serviceDirectoryAdmin.openSdAddWin);
			$('#serviceDirectory_edit_but').click(itsm.config.serviceDirectory.serviceDirectoryAdmin.sd_edit_aff);
			$('#serviceDirectory_delete_but').click(itsm.config.serviceDirectory.serviceDirectoryAdmin.sd_delete_aff);
			$('#serviceDirectory_add_opt_but').click(itsm.config.serviceDirectory.serviceDirectoryAdmin.sdAddOrEditOpt);
		}	
	}

}();

$(document).ready(itsm.config.serviceDirectory.serviceDirectoryAdmin.init);