/**  
 * @author Van  
 * @constructor updateLevelMain
 * @description "updateLevelMain"
 * @date 2010-11-17
 * @since version 1.0 
 */  
$package('itsm.config.updateLevel')
$import("itsm.security.userUtil");

itsm.config.updateLevel.updateLevelGrid = function() {
	

	this.operationTag;
	
	
	return{
		
		
		 /**
		  * @description 动作格式化 
		  */
		updateLevelGridActionFormatter:function(){
			
			return actionFormat('1','1')
			.replace('[edit]','itsm.config.updateLevel.updateLevelGrid.editUpdateLevel_openWindow()')
			.replace('[delete]','itsm.config.updateLevel.updateLevelGrid.deleteUpdateLevelInLine()');

		},
		
		 /**
		  * @description 升级级别列表   
		  */
		showUpdateLevelGrid:function(){
			
			var params = $.extend({},jqGridParams, {	
				url:'updatelevel!findAllLevels.action',
				caption:i18n['escalateLevel']+i18n['list'],
				colNames:[i18n['levelName'],i18n['escalateTo'],i18n['operateItems'],'',''],
				colModel:[
						  {name:'ulName',width:100,align:'center'},
						  {name:'approvalName',width:80,align:'center',sortable:false},
						  {name:'act', width:80,align:'center',sortable:false,formatter:itsm.config.updateLevel.updateLevelGrid.updateLevelGridActionFormatter},
						  {name:'ulId',hidden:true},
						  {name:'approvalNo',hidden:true}
						  ],
				jsonReader: $.extend(jqGridJsonReader, {id: "ulId"}),
				sortname:'ulId',
				pager:'#updateLevelGridPager'
				});
				$("#updateLevelGrid").jqGrid(params);
				$("#updateLevelGrid").navGrid('#updateLevelGridPager',navGridParams);
				//列表操作项
				$("#t_updateLevelGrid").css(jqGridTopStyles);
				$("#t_updateLevelGrid").append($('#updateLevelGridToolbar').html());
				
				//自适应宽度
				setGridWidth("#updateLevelGrid","regCenter",10);
		},
			
		
		
		


		 /**
		  * @description 新增升级级别  
		  */
		addUpdateLevel_openWindow:function(){
			
			$('#updateLevelWindow').window('open');
			
			operationTag="save";
			
		},
		
		
		/**
		 * 保存升级级别.
		 */
		saveUpdateLevel:function(){
			
			if($('#updateLevelForm').form('validate')){
				var frm = $('#updateLevelWindow form').serialize();
				var url = "updatelevel!"+operationTag+".action";
				
				$.post(url,frm, function(){
					
					$('#updateLevelGrid').trigger('reloadGrid');
					$('#updateLevelWindow').window('close');

					$('#updateLevel_ulName').val('');
					$('#updateLevel_approvalName').val('');
					$('#updateLevel_approvalNo').val('');
					
					msgShow(i18n['msg_operationSuccessful'],'show');
				});
			}
		},
		
		
		

		 /**
		  * @description 编辑升级级别  
		  */
		editUpdateLevel_openWindow:function(){
			
			checkBeforeEditGrid("#updateLevelGrid",function(rowData){
				
				 $('#updateLevel_uiId').val(rowData.ulId);
				 $('#updateLevel_ulName').val(rowData.ulName);
				 $('#updateLevel_approvalName').val(rowData.approvalName);
				 $('#updateLevel_approvalNo').val(rowData.approvalNo);
				 $('#updateLevelWindow').window({'title':i18n['edit']+i18n['escalateLevel']});
				 $('#updateLevelWindow').window('open');

				 operationTag="merge";
				
			});
		},

		 /**
		  * @description 删除升级级别
		  */
		deleteUpdateLevels:function(){
			
			checkBeforeDeleteGrid("#updateLevelGrid",function(rowIds){
				
				var param = $.param({'ulIds':rowIds},true);
				$.post("updatelevel!delete.action", param, function(data){
					
					if(data){
						msgShow(i18n['deleteSuccess'],'show');
						$('#updateLevelGrid').trigger('reloadGrid');
					}else{
						
						msgAlert(i18n['systemDataNotDelete'],'info');
					}
					
				}, "json");
				
			});
		},
		
		
		 /**
		  * @description 删除升级级别InLine
		  */
		deleteUpdateLevelInLine:function(){
			
			checkBeforeDeleteGridInLine("#updateLevelGrid",function(rowId){
				
				var param = $.param({'ulIds':rowId},true);
				$.post("updatelevel!delete.action", param, function(data){
					
					if(data){
						msgShow(i18n['deleteSuccess'],'show');
						$('#updateLevelGrid').trigger('reloadGrid');
					}else{
						
						msgAlert(i18n['systemDataNotDelete'],'info');
					}
					
				}, "json");
				
			});
		},

		
		/**
		 * @description 搜索升级级别 
		 */
		searchUpdateLevel_openWindow:function(){
			
			$('#searchUpdateLevelGrid').window('open');
		},
		
		/**
		 * 进行搜索操作.
		 */
		searchUpdateLevel:function(){
			
			var _url = 'updatelevel!findAllLevels.action';	
			var sdata = $('#searchUpdateLevelGrid form').getForm();
			var postData = $('#updateLevelGrid').jqGrid("getGridParam", "postData");       
			$.extend(postData, sdata);
			$('#updateLevelGrid').jqGrid('setGridParam',{url:_url}).trigger('reloadGrid');

		},
		

		/**
		 * 载入.
		 */
		init:function(){
			
			$("#updateLevelMain_loading").hide();
			$("#updateLevelMain_content").show();
			itsm.config.updateLevel.updateLevelGrid.showUpdateLevelGrid(); 
			$('#updateLevel_approvalName').click(function(){
				
				itsm.security.userUtil.selectUser('#updateLevel_approvalName','#updateLevel_approvalNo','','loginName');
			});
			$('#addUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.addUpdateLevel_openWindow);//添加升级级别
			$('#saveUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.saveUpdateLevel);//保存
			$('#editUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.editUpdateLevel_openWindow);
			$('#deleteUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.deleteUpdateLevels);
			$('#searchUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.searchUpdateLevel_openWindow);
			$('#doSearchUpdateLevelBtn').click(itsm.config.updateLevel.updateLevelGrid.searchUpdateLevel);
		}
		
		
		
	};
	

}();


//载入
$(document).ready(itsm.config.updateLevel.updateLevelGrid.init);
