$package('itsm.config.visit') 
/**  
 * @fileOverview "visitManage"
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor visitManage
 * @description "visitManage"
 * @date 2010-11-17
 * @since version 1.0 
 */  
itsm.config.visit.visitManage = function(){
	var visitNo=0;
	return { 
		useStatusForma:function(cellvalue, options){
			if(cellvalue)
				return i18n['enable']
			else
				return i18n['disable']
		},
		
		typeForma:function(cellvalue, options){
			if(cellvalue=='text'){
				return i18n['text']
			}
			if(cellvalue=='checkbox'){
				return i18n['checkbox']
			}
			if(cellvalue=='radio'){
				return i18n['radio']
			}	
		},

		/**@description 回访事项列表*/
		showVisitGrid:function()
		{	
			var params = $.extend({},jqGridParams, {	
				url:'visit!visitFindPager.action',
				caption:i18n['returnItem']+i18n['list'],
				colNames:[i18n['number'],i18n['name'],i18n['type'],i18n['sort'],i18n['status'],'',''],
				colModel:[
						{name:'visitNo',width:80},					
						{name:'visitName',width:100},
						{name:'visitItemType',width:100,formatter:itsm.config.visit.visitManage.typeForma},
						{name:'visitOrder',width:100},
						{name:'useStatus',width:100,formatter:itsm.config.visit.visitManage.useStatusForma},
						{name:'visitItemType',hidden:true},
						{name:'useStatus',hidden:true}
				    ],
				jsonReader: $.extend(jqGridJsonReader, {id: "visitNo"}),
				sortname:'visitNo',
				pager:'#visitPager',
				onSelectRow:itsm.config.visit.visitManage.reloadVisitItem
				});
				$("#visitList").jqGrid(params);
				$("#visitList").navGrid('#visitPager',navGridParams);
				//列表操作项
				$("#t_visitList").css(jqGridTopStyles);
				$("#t_visitList").append($('#visitToolbar').html());
				
				//自适应宽度
				setGridWidth("#visitList","regCenter",10);
		},	

		/**@description 新增回访事项窗口*/
		addvisit_win:function(){
			$('#add_visitName').val('');
			$('#addvisit_win').window('open');
		},
		
		addvisit_opt:function(){		
			if($('#addvisitForm').form('validate')){
				var _params = $('#addvisit_win form').serialize();
				$.post('visit!visitSave.action', _params, function(){
					$('#addvisit_win').window('close');
					$('#visitList').trigger('reloadGrid');
					msgShow(i18n['addSuccess'],'info');
				})
			}
		},
		/**@description 编辑回访事项 */
		editvisit_win:function(){
			checkBeforeEditGrid("#visitList",itsm.config.visit.visitManage.editvisitFillData);
		},
		
		  /**@description 编辑回访事项填充数据  */
		editvisitFillData:function(rowData){
			$('#visitNo').val(rowData.visitNo);
			$('#visitName').val(rowData.visitName);
			$('#visitOrder').val(rowData.visitOrder);
			$('#visitItemType').val(rowData.visitItemType);
			if(rowData.useStatus=='false'){
				$('#visitState1').attr("checked",'false')
			}else
			{
				$('#visitState').attr("checked",'ture')
			}
			
			$('#editvisit_win').window('open');
		},
		
		  /**@description 编辑回访事项Do  */
		editvisit_opt:function(){		
			if($('#editvisitForm').form('validate')){
				var _params = $('#editvisit_win form').serialize();
				$.post('visit!visitUpdate.action', _params, function(){
					$('#editvisit_win').window('close');
					$('#visitList').trigger('reloadGrid');
					msgShow(i18n['editSuccess'],'show');
				});
			}
		},
		
		
		
		  /**@description 删除回访事项*/
		deletevisit_opt:function(){
			checkBeforeDeleteGrid("#visitList",itsm.config.visit.visitManage.deletevisitMethod);
		},
		
		/**@description 删除回访事项Method*/
		deletevisitMethod:function(rowIds){
			var pp = $.param({'ids':rowIds},true);
			$.post("visit!visitDelete.action", pp, function(){
				$('#visitList').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'show');
			}, "json");
		},

		 /**@description 回访选项值列表*/
		showVisitItemGrid:function()
		{		
			var params = $.extend({},jqGridParams, {	
				url:'visit!visitItemFindPager.action',
				caption:i18n['returnOptionValue'],
				colNames:[i18n['number'],i18n['name']],
				colModel:[
						{name:'visitItemNo',width:80,sorttype:'Long',sortable:true},					
						{name:'visitItemName',width:100,edittype:'select',sortable:false}
				    ],
				jsonReader: $.extend(jqGridJsonReader, {id: "visitItemNo"}),
				sortname:'visitItemNo',
				pager:'#visitItemPager',
				onSelectRow:itsm.config.visit.visitManage.voidMethod
				});
				$("#visitItemList").jqGrid(params);
				$("#visitItemList").navGrid('#visitItemPager',navGridParams);
				//列表操作项
				$("#t_visitItemList").css(jqGridTopStyles);
				$("#t_visitItemList").append($('#visitItemToolbar').html());
				
				//自适应宽度
				setGridWidth("#visitItemList","regCenter",10);
		},
	    /**@description 根据ID刷新扩展属性*/
		reloadVisitItem:function(id){
			visitNo=id;
			var _url = 'visit!visitItemFindPager.action?visitNo='+id;		
			$('#visitItemList').jqGrid('setGridParam',{url:_url})
				.trigger('reloadGrid',[{"page":"1"}]).jqGrid('setGridParam',{url:_url});
			return false;
		},
		
		 /**@description 新增回访选项值窗口*/
		addVisitItem_win:function(){
			if(visitNo==null||visitNo=="0"){
				msgAlert(i18n['msg_chooseVisit'],'info');
			}else{
				$('#edit_visitItemName').val('');
				$('#addVisitItem_win').window('open');
			}
		},
		addVisitItem_opt:function(){	
				if($('#addVisitItemForm').form('validate')){
					var _params = $('#addVisitItem_win form').serialize();
					$.post('visit!visitItemSave.action', _params+"&visitItemDTO.visitNo="+visitNo, function(){
						$('#addVisitItem_win').window('close');
						$('#visitItemList').trigger('reloadGrid');
						msgShow(i18n['addSuccess'],'show');
					})
				}
		},
		
		
		 /**@description 编辑回访事项*/
		editVisitItem_win:function(){
			checkBeforeEditGrid("#visitItemList",itsm.config.visit.visitManage.editVisitItemFillData);
		},
		
		
		 /**@description 编辑回访事项填充数据*/
		editVisitItemFillData:function(rowData){
			$('#visitItemNo').val(rowData.visitItemNo);
			$('#visitItemName').val(rowData.visitItemName);
			$('#editVisitItem_win').window('open');
		},
		
		editVisitItem_opt:function(){	
			if($('#editVisitItemForm').form('validate')){
				var _params = $('#editVisitItem_win form').serialize();
				$.post('visit!visitItemUpdate.action', _params+"&visitItemDTO.visitNo="+visitNo, function(){
					$('#editVisitItem_win').window('close');
					$('#visitItemList').trigger('reloadGrid');
					msgShow(i18n['editSuccess'],'show');
				});
			}
		},
		
		 /**@description 删除回访事项*/
		deleteVisitItem_opt:function(){
			checkBeforeDeleteGrid("#visitItemList",itsm.config.visit.visitManage.deleteVisitItemMethod);
		},
		
		  /**@description 删除回访事项*/
		deleteVisitItemMethod:function(rowIds){
			var pp = $.param({'ids':rowIds},true);
			$.post("visit!visitItemDelete.action", pp+"&visitNo="+visitNo, function(){
				$('#visitItemList').trigger('reloadGrid');
				msgShow(i18n['deleteSuccess'],'show');
				
			}, "json");
			
		},

	
		init: function() 
		{	
		    showAndHidePanel("#visitManage_panel","#visitManage_loading");
		    itsm.config.visit.visitManage.showVisitGrid();
			//showVisitItemGrid();

		}
	}
}();
$(document).ready(itsm.config.visit.visitManage.init);
