﻿ /**  
 * @fileOverview sinba for demo/categories.jsp
 * @author sinba
 * @version 1.0  
 */  
 /**  
 * @author sinba  
 * @constructor categories
 * @description sinba for demo/categories.jsp
 * @date 2010-11-17
 * @since version 1.0 
 */  
var categories = function() {
	this.show_tree = function() {
		$("#catoryTreeDIV").jstree({
			json_data: {
				ajax: {url : "category!getCategoryTree.action"}
			},
			"dnd": {
				"drag_check": function() {alert(1)} 
			},
			plugins : ["themes", "json_data", "ui", "crrm", "contextmenu", "dnd"]

		})
		.bind("create.jstree", addCategory)
		.bind("remove.jstree", removeCategory)
		.bind("rename.jstree", renameCategory)
		.bind("select_node.jstree", selectCategory)
		.bind("move_node.jstree", moveCategory);

	}

	this.addCategory = function (e, data) {
		var _url = "category!save.action";
		var _params = {
			"categoryDto.cname" : data.rslt.name,
			"categoryDto.parentNo" : data.rslt.parent.attr("id")
		};
		$.post(_url,_params,
			function (r) {
				if(r && !r.status) {
					$.jstree.rollback(data.rlbk);  
				}
			},
			'json'
		);
	}

	this.removeCategory = function (e, data) {
		var _url = "category!remove.action";
		var _params = {
			"categoryDto.cno" : data.rslt.obj.attr("id")
		};
		$.post(_url,_params,
			function (r) {
				if(r && !r.status) {
					$.jstree.rollback(data.rlbk);  
				}
			},
			'json'
		);
	}
	
	this.renameCategory = function (e, data) {
		var _newName = data.rslt.new_name;
		var _url = "category!update.action";
		var _params = {
			"categoryDto.cno" : data.rslt.obj.attr("id"),
			"categoryDto.cname" : _newName
		};
		$.post(_url,_params,
			function (r) {
				if(r && !r.status) {
					$.jstree.rollback(data.rlbk);  
				}
			},
			'json'
		);
	}

	this.moveCategory = function (e, data) {
		var _cno = data.rslt.o.attr("id");
		var _pno = data.rslt.np.attr("id");
		var _url = "category!changeParent.action";
		var _params = {
			"categoryDto.cno" : _cno,
			"categoryDto.parentNo" : _pno
		};
		$.post(_url,_params,
			function (r) {
				if(r && !r.status) {
					$.jstree.rollback(data.rlbk);  
				}
			},
			'json'
		);
	}

	this.selectCategory = function (e, data) {
		var obj = data.rslt.obj;
		var _parent = data.inst._get_parent();
		var _parentNo = null;
		var _parentName = null;
		
		if (_parent!=-1 && _parent.attr('id')) {
			_parentNo = _parent.attr('id');
			_parentName = _parent.attr('cname');
		}
		$('#editCategoryDiv [name="categoryDto.cno"]').val(obj.attr('id'));
		$('#editCategoryDiv [name="categoryDto.cname"]').val(obj.attr('cname'));
		$('#editCategoryDiv [name="categoryDto.description"]').val(obj.attr('description'));
		$('#editCategoryDiv [name="categoryDto.parentNo"]').val(_parentNo);
		$('#editCategoryDiv [name="categoryDto.parentName"]').val(_parentName);
	}

	this.updateCategory = function() {
		var _cno = $('#editCategoryDiv [name="categoryDto.cno"]').val();
		var _cname = $('#editCategoryDiv [name="categoryDto.cname"]').val();
		var _description = $('#editCategoryDiv [name="categoryDto.description"]').val();
		alert(_cno + " " + _cname + " " + _description);
		var _url = "category!update.action";
		var _params = {
			"categoryDto.cno" : _cno,
			"categoryDto.cname" : _cname,
			"categoryDto.description" : _description
		};
		$.post(_url,_params,
			function (r) {
				$('#catoryTreeDIV').jstree('refresh',-1);
			},
			'json'
		);
	}
	
	// 载入
	return {
		init : function() {
			// 加载数据列表
			show_tree();
			$('#link_ok_category').click(updateCategory);
		}
	}

}();
// 载入
$(document).ready(categories.init);
