﻿ /**  
 * @fileOverview for demo/companys.jsp
 * @author sinba
 * @version 1.0  
 */  
 /**  
 * @author sinba  
 * @constructor companys
 * @description for demo/companys.jsp
 * @date 2010-11-17
 * @since version 1.0 
 */  
var companys = function() 
{
	/**@description 列表菜单*/
	this.show_grid=function()
	{	
		$('#grid').jqGrid({
			url:'company!find.action',	//查询返回pageDTO的URL
//			editurl:'company!save.action',
			mtype:'post',
			datatype: "json",
			height: 250, width: 500,
		   	colNames:['cno','cname','xz'],
		   	colModel:[
		   		{name:'cno',index:'cno', width:60, sorttype:"int"},
		   		{name:'cname',index:'cname', width:100},
		   		{name:'xz',index:'xz', width:100}
		   	],
		   	multiselect: true,
		   	caption: "Companys Management",
	        jsonReader: {
				root: "data",
				records: "totalSize",
				page: "page",
				total: "total",
	            repeatitems: false,
	            id: "cno"
	        },
			rowNum:10,
		   	rowList:[10,20,30],
		   	pager: '#pager'
		})
		.navGrid('#pager',{edit:false,add:false,del:false,search:false})
		.navButtonAdd('#pager',{  
			caption:"Add",
			buttonicon:"ui-icon-plus",   
			onClickButton: function(){
				$('#addCompanyDiv').window('open');
				operator = 'save';
			},   
			position:"last"  
		})
		.navButtonAdd('#pager',{  
			caption:"Del",   
			buttonicon:"ui-icon-trash",   
			onClickButton: delCompany,   
			position:"last"  
		})
		.navButtonAdd('#pager',{  
			caption:"Edit",   
			buttonicon:"ui-icon-gear",   
			onClickButton: editCompany,   
			position:"last"  
		})
		.navButtonAdd('#pager',{  
			caption:"Search",   
			buttonicon:"ui-icon-search",   
			onClickButton: function() {
				$('#searchCompanyDiv').window('open');
			},   
			position:"last"  
		}); 
		//处理分页
	}
	
	this.operator;
	/**@description 新增公司*/
	this.addCompany = function() {
		var bb = $('#addCompanyDiv form').serialize();
		var url = 'company!'+operator+'.action';
		$.post(url, bb, function(){
			$('#addCompanyDiv').window('close');
			$('#grid').trigger('reloadGrid');
		});
	}
	
	/**@description 删除公司 */
	this.delCompany = function() {
		var rowIds = $("#grid").getGridParam("selarrrow");
		var pp = $.param({'ids':rowIds},true);
		$.post("company!delete.action", pp, function(){
			$('#grid').trigger('reloadGrid');
		}, "json");
	}

	/**@description 编辑公司 */
	this.editCompany = function() {
		operator = 'merge';
		var rowId = $("#grid").getGridParam("selrow");
		var data = $("#grid").getRowData(rowId);

		$('#cno').val(data.cno);
		$('#cname').val(data.cname);
		$('#xz').val(data.xz);
		$('#addCompanyDiv').window('open');
	}
	
	/**@description 搜索公司 */
	this.searchCompany = function() {
		var sdata = $('#searchCompanyDiv form').getForm();
		var postData = $("#grid").jqGrid("getGridParam", "postData");       
		$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值
		
		var _url = 'company!find.action';		
		$('#grid').jqGrid('setGridParam',{url:_url})
			.trigger('reloadGrid').jqGrid('setGridParam',{url:_url});
		return false;
	}

	/**@description 搜索公司 */
	this.compassSearchCompany = function() {
		var sdata = $('#companyCompassSearchForm').getForm();
		//alert($.toJSON(sdata));
		var postData = $("#grid").jqGrid("getGridParam", "postData");       
		$.extend(postData, sdata);  //将postData中的查询参数覆盖为空值

		var _url = 'company!search.action';		
		$('#grid').jqGrid('setGridParam',{url:_url})
			.trigger('reloadGrid').jqGrid('setGridParam',{url:_url});
		return false;
	}

	//载入
	return {
		init: function() 
		{
			//加载数据列表
			show_grid();
			//alert(123);
			jQuery("#grid")

			//创建事件
			$('#link_add_ok').click(addCompany);
			$('#link_add_cancel').click(function(){
				$('#addCompanyDiv').window('close');
			});

			$('#link_search_ok').click(searchCompany);
			$('#link_search_cancel').click(function(){
				$('#searchCompanyDiv').window('close');
			});
			
			$('#link_compass_search_ok').click(compassSearchCompany);
		}
	}

}();
//载入
$(document).ready(companys.init);

