﻿$package('itsm.jbpm') 
/**  
 * @fileOverview for jbpm/ProcessDefined.jsp
 * @author amy
 * @version 1.0  
 */  
 /**  
 * @author amy  
 * @constructor processDefined
 * @description for jbpm/ProcessDefined.jsp
 * @date 2010-10-13
 * @since version 1.0 
 */  
itsm.jbpm.processDefined = function() 
{
	return {
		/**
		 * @description cellValue:单元格的值；options:字体样式等；row:一行的数据
		 * */
		optFormatter:function(cellValue,options,row) {
			return '<a href=javascript:itsm.jbpm.processDefined.showProcessInstances("'+row.id+'")'+ 
			' title="'+i18n['flowExample']+'">'+i18n['flowExample']+'</a>&nbsp;&nbsp;'+
			'<a href=javascript:itsm.jbpm.processDefined.showPicture("'+row.id+'") title="'+i18n['look']+i18n['flowChart']+'">'+i18n['look']+i18n['flowChart']+'</a>';
		},
		load_processDefined_list:function(){
			var params = $.extend({},jqGridParams, {	
				url:'upload!findProcessDefinitions.action',
				caption:i18n['flow'],
				colNames:['ID','Key',i18n['name'],i18n['version'],i18n['description'],i18n['operateItems']],
				colModel:[
						  {name:'id',width:100},
						  {name:'key',width:100},
						  {name:'name',width:100},
						  {name:'version',width:50},
						  {name:'description',width:100},
						  {name:'act',width:230,formatter:itsm.jbpm.processDefined.optFormatter}
					  ],
			   jsonReader: {
					root:"processPageDto.data",
					records:"processPageDto.totalSize",
					page:"processPageDto.page",
					total:"processPageDto.total",
					repeatitems: false
				},	  
				sortname:'id',
				pager:'#processDefinedPager'
				});
			
				$("#processDefinedGrid").jqGrid(params);
				$("#processDefinedGrid").navGrid('#processDefinedPager',navGridParams);
				//列表操作项
				$("#t_processDefinedGrid").css(jqGridTopStyles);
				$("#t_processDefinedGrid").append($('#processToolbar').html());
				
				//自适应宽度
				setGridWidth("#processDefinedGrid","regCenter",10);
			
	

		
		},
		/**
		 * @description open add window
		 * */
		add_openwindow:function()
		{
			$('#addProcess').window('open');
		},
		
		/**
		 * @description close add window
		 * */
		add_closewindow:function()
		{	
			$('#addProcess').window('close');
		},
		/**
		 * @descriptionopen the search window
		 * */
		search_openwindow:function()
		{		
			$('#searchProcess').window('open');
		},
	
		/**
		 * @description close the search window
		 * */
		search_closewindow:function()
		{		
			$('#searchProcess').window('close');
		},
		/**
		 * @descriptionadd process
		 * */
		add_processDefined:function()
		{
			$.ajaxFileUpload({
	            url:'upload!deployProcess.action',
	            secureuri:false,
	            fileElementId:'jpdlFile',
				dataType: 'json',  
	            success: function(data, status){
	            	$('#addProcess').window('close');
	            	$('#processDefinedGrid').trigger('reloadGrid');
	            	
	            	msgShow(i18n['msg_process_delpoySuccess'],'show');
	            }
	        });
		},
	
		/**
		 * @description show picture
		 * */
		showPicture:function(id){
			var rowsId = jQuery("#processDefinedGrid").jqGrid('getGridParam','selrow');
			if(rowsId=='')
			{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['plaseSelectOptInfo'],'info');
			}
			else
			{
			    var _param = $.param({'processId':id},true);
			    var _url = '../pages/jbpm/traceInstance.jsp?processId='+id;
			    
			    refreshTab(i18n['flowChart'],_url);
			   
			}
		},
		
		/**
		 * @description delete process
		 * */
		toolbar_delete:function()
		{
	        var s = jQuery("#processDefinedGrid").jqGrid('getGridParam','selarrrow');
			if(s=='')
			{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['selectDeleteDataTip'],'info');
			}
			else
			{
				$.post('upload!showProcessInstances.action','processId='+s,function(res){
					if(res.data==null || res.data==''){
						$.messager.confirm(i18n['tip'],i18n['deleteComfirm'],function(r){
							if(r){
								var _param = $.param({'deploymentId':s},true);
								var _url = 'upload!undeployProcess.action';
							    $.post(_url,_param, function(){
									$('#processDefinedGrid').trigger('reloadGrid');
									
									msgShow(i18n['msg_deleteSuccessful'],'show');
									
								},'json');
							}
						});
					}else{
						$.messager.alert(i18n['tip'],'<br/>'+i18n['error_jbpm_notAllowDelete'],'error');
					}
				})
				
			}
		},
		/**
		 * @description show Process Instances
		 * */
		showProcessInstances:function(id){
			var rowIds = jQuery("#processDefinedGrid").jqGrid('getGridParam','selrow');
			if(rowIds=='')
			{
				$.messager.alert(i18n['tip'],'<br/>'+i18n['plaseSelectOptInfo'],'info');
			}
			else
			{
			    var _url = '../pages/jbpm/processInstances.jsp?processId='+id;
			    itsm.common.utility.tabUtility.reOpenTab(_url,i18n['flowExample']+" ");
			}
		},
		init: function() 
		{
			itsm.jbpm.processDefined.load_processDefined_list();

			$('#link_jbpm_deploy_ok').click(itsm.jbpm.processDefined.add_processDefined);
			$('#link_add_cancel').click(itsm.jbpm.processDefined.add_closewindow);
			
			$('#link_search_ok').click(itsm.jbpm.processDefined.search_openwindow);
			$('#link_search_cancel').click(itsm.jbpm.processDefined.search_closewindow);
		}
	}
  
}();

$(document).ready(itsm.jbpm.processDefined.init());

