﻿$package('itsm.jbpm') 
/**  
 * @fileOverview for showProcessHistories.html
 * @author amy
 * @version 1.0  
 */  
 /**  
 * @author amy  
 * @constructor historys
 * @description for showProcessHistories.html
 * @date 2010-10-14
 * @since version 1.0 
 */
itsm.jbpm.historys = function() 
{
	return {
		format:function(cellvalue){	
			var str = "";
	        var hour = 0;
	        var minute = 0;
	        var second = 0;
	        second = cellvalue / 1000;
	        if (second > 60) {
	            minute = second / 60;
	            second = second % 60;
	        }
	        if (minute > 60) {
	            hour = minute / 60;
	            minute = minute % 60;
	        }
	        var strHour = parseInt(hour);
	        var strMinute = parseInt(minute);	
	        var strSecond = parseInt(second);
	        return (strHour + i18n['hours'] + strMinute +i18n['minutes']
	                + strSecond + i18n['second']);
		},
		
		urlProcessInstanceId:function(cellvalue){
			return "<a href=javascript:itsm.jbpm.historys.showProcessImg('"+cellvalue+"')>"+i18n['title_request_traceInstance']+"</a>"
		},
		/**
		 * @description 查看流程图
		 */
		showProcessImg:function(id){
			 var _url = 'upload!traceInstance.action?instanceId='+id;
			 itsm.common.utility.tabUtility.reOpenTab(_url,i18n['title_request_traceInstance']);
		},
		/**
		 * @description 加载数据列表
		 * */
		load_processHistories_list:function()
		{
			var params = $.extend({},jqGridParams, {	
				url:'upload!showHistories.action',
				caption:i18n['flowExample'],
				colNames:[i18n['title_jbpm_processId'],i18n['title_jbpm_instanceId'],i18n['status'],i18n['title_startTime'],i18n['title_endTime'],i18n['title_jbpm_duration'],i18n['title_jbpm_endActivityName'],i18n['title_jbpm_currentActivityName'],i18n['title_request_traceInstance']],
				colModel:[
						  {name:'processDefinitionId',index:'processDefinitionId',width:100},
						  {name:'processInstanceId',index:'processInstanceId',width:100,align:'left'},
						  {name:'state',index:'state',width:50,sortable:false,align:'center'},
						  {name:'startTime',index:'startTime',width:100,align:'center',formatter:timeFormatter},
						  {name:'endTime',index:'endTime',width:100,sortable:false,align:'center',formatter:timeFormatter},
						  {name:'duration',index:'duration',width:100,align:'center',editable:true,formatter:itsm.jbpm.historys.format},
						  {name:'endActivityName',index:'endActivityName',width:150,sortable:false,align:'center'},
						  {name:'endActivityName',width:100,sortable:false,align:'center',hidden:true},
						  {name:'processInstanceId',width:150,sortable:false,align:'center',formatter:itsm.jbpm.historys.urlProcessInstanceId}
					  ],
				toolbar:false,	  	  
				jsonReader: $.extend(jqGridJsonReader, {id: "processDefinitionId"}),
				sortname:'processDefinitionId',
				pager:'#historyProcessPage'
				});
			
				$("#historyProcessGrid").jqGrid(params);
				$("#historyProcessGrid").navGrid('#historyProcessPage',navGridParams);
				//列表操作项
				$("#t_historyProcessGrid").css(jqGridTopStyles);
				$("#t_historyProcessGrid").append($('#toolbar').html());
				
				//自适应宽度
				setGridWidth("#historyProcessGrid","regCenter",10);				
			
		},
		/**
		 * @description open the search window
		 * */
		search_openwindow:function(){		
			$('#searchProcessHistorie').window('open');
		},
	
		/**close the search window*/
		search_closewindow:function(){		
			$('#searchProcessHistorie').window('close');
		},
		
		/**
		 * @description 历史流程搜索
		 */
		searchHistoryProcess:function(){
			var sdata = $('#searchProcessHistorie form').getForm();
			var postData = $("#historyProcessGrid").jqGrid("getGridParam", "postData");     
			$.extend(postData, sdata);
			$('#historyProcessGrid').jqGrid('setGridParam',{page:1,url:'upload!showHistories.action'}).trigger('reloadGrid');
		},

		init: function() 
		{
			//加载数据列表
			itsm.jbpm.historys.load_processHistories_list();
		}
	}
  
}();



//载入
$(document).ready(itsm.jbpm.historys.init());

