$package('itsm.jbpm')

/**  
 * @fileOverview for jbpm/ProcessInstances.jsp
 * @author amy
 * @version 1.0  
 */  
 /**  
 * @author amy  
 * @constructor processInstances
 * @description for jbpm/ProcessInstances.jsp
 * @date 2010-11-10
 * @since version 1.0 
 */
itsm.jbpm.processInstances = function() {
	var parentDivPrefix = "#show_"+_processId+" ";
	return {
		$full:function(selector) {
			return $(parentDivPrefix + selector);
		},
		/** 
		 * @description cellValue:单元格的值；options:字体样式等；row:一行的数据
		 * */
		operateFormatter:function(cellValue, options, row) {
			return '<a href="javascript:trace(\''+row.id+'\')" title="'+i18n['tracking']+'">'+i18n['tracking']+'</a>';
		},
		load_processInstances_list:function(){
			var params = $.extend({},jqGridParams, {	
				url:'upload!showProcessInstances.action?processId='+_processId,
				caption:i18n['flowExample'],
				colNames:['ID',i18n['flow']+'ID','Key',i18n['status'],i18n['priority'],i18n['operateItems']],
				colModel:[
	  					  {name:'id',index:'id',width:150},
						  {name:'processDefinitionId',index:'processDefinitionId',width:100},
						  {name:'key',index:'key',width:100},
						  {name:'state',index:'state',width:50},
						  {name:'priority',index:'priority',width:100},
						  {name:'operate',width:100,formatter:itsm.jbpm.processInstances.operateFormatter}
					  ],
				toolbar:false,	  	  
				jsonReader: $.extend(jqGridJsonReader, {id: "id"}),	  
				sortname:'id',
				pager:'#processInstancesPager'
				});
			
				$("#processInstancesGrids").jqGrid(params);
				$("#processInstancesGrids").navGrid('#processDefinedPager',navGridParams);
				//自适应宽度
				setGridWidth("#processDefinedGrid","regCenter",10);

		},
		/**
		 * @description show trace picture
		 * */
		trace:function(_piId){
		    var _url = 'upload!traceInstance.action?instanceId='+_piId;
		    itsm.common.utility.tabUtility.addTab(i18n['flowChart']+i18n['tracking'],_url);
		},
 
		init: function() 
		{
			itsm.jbpm.processInstances.load_processInstances_list();
		}
  	}
  
}();
//载入
//$(document).ready(processInstances.init);
$(document).ready(itsm.jbpm.processInstances.init());
