 
$package('itsm.jbpm') 
/**  
 * @fileOverview 我的流程任务主函数
 * @author amy
 * @version 1.0  
 */  
 /**  
 * @author amy  
 * @constructor 我的流程任务主函数
 * @description 我的流程任务主函数
 * @date 2010-11-10
 * @since version 1.0 
 */
itsm.jbpm.showMyTask=function(){
	
	return {
		/**
		 *@description  cellValue:单元格的值；options:字体样式等；row:一行的数据
		 */
		operateFormatter:function(cellValue, options, row) {
			return '<a href=javascript:trace("'+row.executionId+'")>'+i18n['tracking']+'</a>';
		},
		
		titleUrlFrm:function(cellvalue, options, rowObject){
			return '<a href="JavaScript:requestDetails('+rowObject.variables.dto.eno+','+rowObject.id+')">'+cellvalue+'</a>'
		},
		
		/**
		 * @description 数据列表行格式化.
		 */
		titleUrlFrm1:function(cellvalue, options, rowObject){
			var executionId=rowObject.executionId;
			if(executionId.indexOf('Changes')>=0){
				return "<a href=javascript:itsm.common.utility.tabUtility.reOpenTab('change!changeInfo.action?queryDTO.changeId="+rowObject.variables.dto.changeId+"&queryDTO.taskId="+rowObject.id+"&queryDTO.assignee="+rowObject.assignee+"','"+i18n['title_changeInfo']+"')>"+cellvalue+":"+rowObject.variables.dto.changeTitle+"</a>"
			}	
			else	
				return '<a href="JavaScript:requestDetails1('+rowObject.variables.dto.eno+','+rowObject.id+')">'+cellvalue+"："+rowObject.variables.dto.etitle+'</a>'
		},
		
		/**
		 * @description 转到请求详细页面.
		 */
		requestDetails1:function(gr,taskId){
			refreshTab(i18n['title_request_requestDetail'],'request!requestDetails.action?eno='+gr+'&taskId='+taskId);
		},
		load_processInstances_list:function(){
			
			var params = $.extend({},jqGridParams, {	
				url:'upload!showMyTasks.action',
				caption:i18n['caption_request_taskGrid'],
				colNames:['',i18n['common_name'],i18n['common_title'],'','',i18n['common_createTime'],i18n['title_process_taskExpirationTime'],'','','formResourceName','executionId','progress',i18n['description'],'eno',i18n['common_action']],
				colModel:[
	  					  {name:'id',hidden:true},
						  {name:'name',index:'name',width:100},
						  {name:'variables.dto.etitle',width:100,formatter:itsm.jbpm.showMyTask.titleUrlFrm1},
						  {name:'activityName',hidden:true},
						  {name:'description',hidden:true},
						  {name:'createTime',width:100,formatter:itsm.jbpm.showMyTask.timeFormatter},
						  {name:'duedate',width:150,formatter:itsm.jbpm.showMyTask.timeFormatter},
						  {name:'priority',hidden:true},
						  {name:'assignee',hidden:true},
						  {name:'formResourceName',hidden:true},
						  {name:'executionId',hidden:true},
						  {name:'progress',hidden:true},
						  {name:'remark',index:'remark',width:100},
						  {name:'variables.dto.eno',hidden:true},
						  {name:'operate',width:100,align:'center',formatter:itsm.jbpm.showMyTask.operateFormatter}
					  ],
				toolbar:false,	  
				jsonReader: $.extend(jqGridJsonReader, {id: "id"}),
				sortname:'id',
				pager:'#MyTasksPager'
				});
			
				$("#MyTasksGrid").jqGrid(params);
				$("#MyTasksGrid").navGrid('#MyTasksPager',navGridParams);
				//列表操作项
				$("#t_MyTasksGrid").css(jqGridTopStyles);
				$("#t_MyTasksGrid").append($('#toolbar').html());
				
				//自适应宽度
				setGridWidth("#MyTasksGrid","regCenter",10);	
		},
		/**
		 *@description  show trace picture
		 */
		trace:function(_id){
			    var _url = 'upload!traceInstance.action?instanceId='+_id;
			    itsm.common.utility.tabUtility.addTab(i18n['flow']+i18n['tracking'],_url);
		},
		
		
		/**
		 * @description review Process
		 * */
		reviewProcess:function(_id){
		    var _url = 'upload!viewApply.action?taskId='+_id;
		    itsm.common.utility.tabUtility.addTab(i18n['look']+i18n['flow'],_url);
		},
		/**
		 * @description review Process
		 * */
		reviewProcess1:function(_id){
		    var _url = 'request!findRequestById.action?taskId='+_id;
		    itsm.common.utility.tabUtility.addTab(i18n['look']+i18n['flow'],_url);
		},
		


		init:function() 
		{
			itsm.jbpm.showMyTask.load_processInstances_list();
		}
  
  		
	}
  
}();
//载入
//$(document).ready(processInstances.init);
$(document).ready(itsm.jbpm.showMyTask.init());
