/**  
 * @author Van  
 * @constructor addKnowledge
 * @description "addKnowledge"
 * @date 2010-11-17
 * @since version 1.0 
 */
$package('itsm.knowledge');
$import('itsm.knowledge.leftMenu');
$import('itsm.knowledge.knowledgeTree');

itsm.knowledge.addKnowledge = function() {	
	
		
	return {
		/**
		 * 加载树结构.
		 */
		selectKnowledgeCategory:function(){
			
			$('#addKnowledge_CategoryDiv').window('open');
			
			
			//加载树结构
			itsm.knowledge.knowledgeTree.showKnowledgeTree('#addKnowledge_CategoryDiv',function(e,data){
				 
				var categoryName=data.rslt.obj.attr('cname');
				var id=data.rslt.obj.attr('id');
				$('#addKnowledge_Category').val(categoryName);
				$('#addKnowledge_categoryNo').val(id);
				
				itsm.knowledge.addKnowledge.closeSelectCategroyWindow();
				
			});
		},

		/**
		 * @description 关闭选择分类窗口.
		 */
		closeSelectCategroyWindow:function(){
			
			$('#addKnowledge_CategoryDiv').window('close');
		},
		
		/**
		 * 保存新增.
		 */
		
		saveKnowledge:function(){
			
			var title=$.trim($('#addKnowledge_title').val());
			var content=$.trim($('#addKnowledgeCon').val());
			if(title==''||content=='' ){
				msgAlert(i18n['knowTitleAndContentNotNull'],'info');
			}else{
				$('#addKnowledge_Content').val($('#addKnowledgeCon').val());
				var _param = $('#addKnowledgePanel form').serialize();
				var _url='knowledgeInfo!saveKnowledgeInfo.action';
				
				
				//进程状态
				startProcess();
				$.post(_url,_param,function(){
					
					//进程状态
					endProcess();
					
					//清空内容
					$('#addKnowledge_title').val("");
					$('#addKnowledge_categoryNo').val("");
					$('#addKnowledge_Category').val("");
					$('#addKnowledge_keyWords').val("");
					$('#addKnowledge_Content').val("");
					$('#addKnowledgeCon').val("");
					$('#addKnowledge_uploadedAttachments').html("");
					$('#addKnowledge_attachments').val("");
					
					itsm.knowledge.leftMenu.showKnowledgeIndex();
					$('#knowledgeGrid').trigger('reloadGrid');
					
					
					msgShow(i18n['addSuccess'],'show');
					
				});
			}
		},
		init:function(){
			
			$("#addKnowledge_loading").hide();
			$("#addKnowledge_contentPanel").show();
			
			$('#addKnowledge_Category').click(itsm.knowledge.addKnowledge.selectKnowledgeCategory);
			$('#addKnowledge_Category').blur(itsm.knowledge.addKnowledge.closeSelectCategroyWindow);
			$('#saveKnowledgeBtn').click(itsm.knowledge.addKnowledge.saveKnowledge);
			
			//实例化附加上传
			setTimeout(function(){
				getUploader('#addKnowledge_uploadAttachments','#addKnowledge_attachments','#addKnowledge_olduploadedAttachments','');	
			},0);
			
			$('#add_backToKnowledgeIndex').click(itsm.knowledge.leftMenu.showKnowledgeIndex);
			lazyInitEditor('#addKnowledgeCon');
		}
		
	};
	
	


}();

//载入
$(document).ready(itsm.knowledge.addKnowledge.init);