/**  
 * @author Van  
 * @constructor editKnowledge
 * @description "editKnowledge"
 * @date 2010-11-17
 * @since version 1.0 
 */
$package('itsm.knowledge');

$import('itsm.knowledge.leftMenu');
$import('itsm.knowledge.knowledgeTree');


itsm.knowledge.editKnowledge = function() 
{	
	
	
	
	return {
		
		
		/**
		 * @description 查找知识信息
		 */
		findKnowledgeById:function(){
			
			var url = 'knowledgeInfo!findKnowledgeById.action?kid='+id;
			$.post(url,function(res)
			{
				$('#editKnowledge_kid').val(res.kid);
				$('#editKnowledge_title').val(res.title);
				if(res.categoryNo!=null){
					$('#editKnowledge_categoryNo').val(res.categoryNo);
				}
				
				if(res.categoryName!=null){
					$('#editKnowledge_Category').val(res.categoryName);
				}
				
				$('#editKnowledge_keyWords').val(res.keyWords==null?'':res.keyWords);
				$('#editKnowledge_Content').val(res.content);
				$('#editKnowledgeCon').val(res.content);
				var arr=res.attachments;
				if(arr!=null){
				for(var i=0;i<arr.length;i++){
					var file=arr[i].url;
					var fileName=file.substring(file.lastIndexOf("/")+1);
					var fileFix=fileName.substring(fileName.indexOf("."));
					
					var iconUrl="<img src='../images/attachicons/";
					if(fileFix==".rar"){
						iconUrl=iconUrl+"rar.gif'";
					}
					if(fileFix==".zip"){
						iconUrl=iconUrl+"zip.gif'";
					}
					
					if(fileFix==".gif"||fileFix==".jpg"||fileFix==".bmp"||fileFix==".png"){
						iconUrl=iconUrl+"image.gif'";
					}
					
					if(fileFix==".doc"||fileFix==".docx"||fileFix==".xls"||fileFix==".ppt"){
						iconUrl=iconUrl+"msoffice.gif'";
					}
					
					if(fileFix==".pdf"){
						iconUrl=iconUrl+"pdf.gif'";
					}
					
					if(fileFix==".swf"){
						iconUrl=iconUrl+"flash.gif'";
					}
					
					else{
						
						iconUrl=iconUrl+"unknown.gif'";
					}
					
					iconUrl=iconUrl+" width='14px' height='14px'/>&nbsp;";	
					$('#editKnowledge_oldAttachments').append("<div id='knowledgeAttachment_ID_"+arr[i].aid+"'>"+iconUrl+"<a href='attachment!download.action?downloadAttachmentId="+arr[i].aid+"' target='_blank'>"+fileName+"</a>&nbsp;&nbsp;<a href=javascript:itsm.knowledge.editKnowledge.deleteAttachement('"+id+"','"+arr[i].aid+"')>"+i18n['deletes']+"</a></div>");

				}
				
				}

				
			});
			
		},
		
		/**
		 * @description 删除附件
		 */
		deleteAttachement:function(kid,aid){
			
			
			
			var _url = "knowledgeInfo!deleteAttachment.action?kid="+kid+"&aid="+aid;
			$.post(_url,function(){
				
				//根据ID移除DIV
				$('div#knowledgeAttachment_ID_'+aid).remove(); //删除匹配元素
				
				//删除附件文件
				$.post("attachment!delete.action?downloadAttachmentId="+aid,function(){
					
				});
				
			});
			
		},
		
		/**
		 * @description 编辑知识
		 */
		doEditKnowledge:function(){
			
			var title=$.trim($('#editKnowledge_title').val());
			var content=$.trim($('#editKnowledgeCon').val());
			if(title==''||content=='' ){
				msgAlert(i18n['knowTitleAndContentNotNull'],'info');
			}else{
				$('#editKnowledge_Content').val($('#editKnowledgeCon').val());
				var _params=$('#editKnowledgePanel form').serialize();
				var _url = "knowledgeInfo!updateKnowledgeInfo.action";
				
				//进程状态
				startProcess();
				$.post(_url,_params,function(){
					
					//进程状态
					endProcess();

					closeTab(i18n['knowledge_editKnowledge']);

					itsm.knowledge.leftMenu.showKnowledgeIndex();
					
					
					
					$('#knowledgeGrid').trigger('reloadGrid');
					
					
					
					msgShow(i18n['editSuccess'],'show');
					
				});
				
			}
		},

		
		
		/**
		 * @description 加载知识库分类.
		 */
		selectKnowledgeCategory:function(){
			
			$('#editKnowledge_CategoryDiv').window('open');
			
			
			//加载树结构
			itsm.knowledge.knowledgeTree.showKnowledgeTree('#editKnowledge_CategoryDiv',function(e,data){
				 
				var categoryName=data.rslt.obj.attr('cname');
				var id=data.rslt.obj.attr('id');
				$('#editKnowledge_Category').val(categoryName);
				$('#editKnowledge_categoryNo').val(id);
				
				itsm.knowledge.editKnowledge.selectKnowledgeCategory_CloseWindow();
				
			});
			
		},
		
		
		/**
		 * @description 关闭选择分类
		 */
		selectKnowledgeCategory_CloseWindow:function(){
			
			$('#editKnowledge_CategoryDiv').window('close');
		},
		
		
		/**
		 * 加载
		 */
		init: function() {
		
			
			$("#editKnowledge_loading").hide();
			$("#editKnowledge_contentPanel").show();
			
			$('#editKnowledge_Category').click(itsm.knowledge.editKnowledge.selectKnowledgeCategory);
			$('#editKnowledge_Category').blur(itsm.knowledge.editKnowledge.selectKnowledgeCategory_CloseWindow);
			lazyInitEditor('#editKnowledgeCon');
			
			itsm.knowledge.editKnowledge.findKnowledgeById();
			
			//实例化附加上传
			setTimeout(function(){
				getUploader('#editKnowledge_uploadAttachments','#editKnowledge_attachments','#editKnowledge_oldAttachments','');
			},0);

			$('#editKnowledgeBtn').click(itsm.knowledge.editKnowledge.doEditKnowledge);
			$('#edit_backToKnowledgeIndex').click(itsm.knowledge.leftMenu.showKnowledgeIndex);			
		}
		
	};
	
	
}();

//载入
$(document).ready(itsm.knowledge.editKnowledge.init);



