/**  
 * @author Van  
 * @constructor knowledge
 * @description "knowledge"
 * @date 2010-11-17
 * @since version 1.0 
 */
$package('itsm.knowledge');
$import('itsm.knowledge.knowledgeDetail');
$import('itsm.knowledge.leftMenu');
$import('itsm.knowledge.knowledgeTree');




itsm.knowledge.knowledgeGrid = function () {


    return {

        /**
         * @description 动作格式化
         */
        knowledgeGridFormatter:function () {

            return $('#knowledgeGridACT').html();
        },
        /**
         * @description 标题格式化
         */
        knowledgeGridTitleFormatter: function (cell, opt, data) {

            return "<a href=javascript:itsm.knowledge.knowledgeDetail.showKnowledgeDetail('" + data.kid + "')>" + cell + "</a>";
        },
        /**
         * @description 加载列表
         */
        showKnowledgeGrid: function () {

            var params = $.extend({},jqGridParams, {
                url: 'knowledgeInfo!findAllKnowledges.action',
                caption: i18n['title_request_knowledgeGrid'],
                colNames: [i18n['number'], i18n['title'], i18n['category'], i18n['time'], '', i18n['operateItems']],
                colModel: [{
                    name: 'kid',
                    hidden: true
                }, {
                    name: 'title',
                    width: 120,
                    formatter: itsm.knowledge.knowledgeGrid.knowledgeGridTitleFormatter
                }, {
                    name: 'categoryName',
                    width: 70,
                    align: 'center',
                    sortable: false
                }, {
                    name: 'addTime',
                    width: 120,
                    align: 'center',
                    formatter: timeFormatter
                }, {
                    name: 'keyWords',
                    hidden: true
                }, {
                    name: 'act',
                    width: 80,
                    align: 'center',
                    sortable: false,
                    formatter: itsm.knowledge.knowledgeGrid.knowledgeGridFormatter
                }],
                jsonReader: $.extend(jqGridJsonReader, {
                    id: "kid"
                }),
                sortname: 'kid',
                ondblClickRow:function(rowId){itsm.knowledge.knowledgeDetail.showKnowledgeDetail(rowId)},
                pager: '#knowledgeGridPager'
            });
            $("#knowledgeGrid").jqGrid(params);
            $("#knowledgeGrid").navGrid('#knowledgeGridPager', navGridParams);
            //列表操作项
            $("#t_knowledgeGrid").css(jqGridTopStyles);
            $("#t_knowledgeGrid").append($('#knowledgeGridToolbar').html());
            //自适应宽度
            setGridWidth("#knowledgeGrid", "regCenter", 218);
       
            
            
        },

        /**
         * @description 转到新增知识页面
         */
        showAddKnowledge: function () {

            openTab(i18n['title_request_newKnowledge'], '../pages/knowledge/addKnowledge.jsp');
        },

        /**
         * @description 转到知识详细页面
         */
        showKnowledge:function(){
        	 checkBeforeEditGrid("#knowledgeGrid", function (rowData) {
        		 itsm.knowledge.knowledgeDetail.showKnowledgeDetail(rowData.kid);
             });
        },
        
        /**
         * @description 转到编辑知识页面
         */
        showEditKnowledge: function () {

            checkBeforeEditGrid("#knowledgeGrid", function (rowData) {

                refreshTab(i18n['knowledge_editKnowledge'], "../pages/knowledge/editKnowledge.jsp?id=" + rowData.kid);

            });
        },
        /**
         * @description 删除知识
         */

        deleteKnowledge: function () {

            checkBeforeDeleteGrid("#knowledgeGrid", function (rowIds) {


                var _param = $.param({
                    'nos': rowIds
                }, true);
                $.post("knowledgeInfo!removeKnowledgeItems.action", _param, function () {

                    $('#knowledgeGrid').trigger('reloadGrid');

                    msgShow(i18n['msg_deleteSuccessful'], 'show');
                    
    				itsm.knowledge.leftMenu.showHotKnowledges();
    				itsm.knowledge.leftMenu.showNewKnowledges();
                    

                }, "json");


            });

        },

        /**
         * @description 行内删除
         */
        deleteKnowledge_inLine: function () {

            checkBeforeDeleteGridInLine("#knowledgeGrid", function (rowId) {

                var _param = $.param({
                    'nos': rowId
                }, true);
                $.post("knowledgeInfo!removeKnowledgeItems.action", _param, function () {
                    $('#knowledgeGrid').trigger('reloadGrid');
                    msgShow(i18n['msg_deleteSuccessful'], 'show');
                    
                    itsm.knowledge.leftMenu.showHotKnowledges();
    				itsm.knowledge.leftMenu.showNewKnowledges();
                    
                }, "json");

            });
        },
        /**
         * @description 打开搜索框
         */
        search_konwledge_openwindow: function () {

            $('#knowledgeSearchDiv').window('open');
        },
        /**
         * @description 关闭搜索框
         */
        search_konwledge_closewindow: function () {

            $('#knowledgeSearchDiv [name="knowledgeQueryDto.category"]').val("");
            $('#knowledgeSearchDiv [name="knowledgeQueryDto.addTime"]').val("");
            $('#knowledgeSearchDiv [name="knowledgeQueryDto.knTitle"]').val("");
            $('#knowledgeSearchDiv').window('close');
        },
        /**
         * @description 搜索
         */
        doSearchKnowledge: function () {

            var sdata = $('#knowledgeSearchDiv form').getForm();
            var postData = $("#knowledgeGrid").jqGrid("getGridParam", "postData");
            $.extend(postData, sdata); //将postData中的查询参数覆盖为空值		
            var _url = 'knowledgeInfo!findAllKnowledges.action';

            $('#knowledgeGrid').jqGrid('setGridParam', {
                url: _url,
                page: 1
            }).trigger('reloadGrid');

        },
        /**
         * 搜索关联知识.
         */
        init_usefullKnowledge: function () {

            if (keyWord != "") {

                $('#knowledgeQueryDto_keyWord').val(keyWord);
                var sdata = $('#knowledgeSearchDiv form').getForm();
                var postData = $("#knowledgeGrid").jqGrid("getGridParam", "postData");
                $.extend(postData, sdata); //将postData中的查询参数覆盖为空值		
                var _url = 'knowledgeInfo!findAllKnowledges.action';
                $("#knowledgeGrid").jqGrid('setGridParam',{page:1,url:_url}).trigger('reloadGrid');
               
            }
        },
        /**
         * @description 查找，打开下拉树.
         * 
         */
        showKnowledgeCategory: function () {

        	itsm.knowledge.knowledgeTree.selectKnowledgeCategory('#search_select_knowledgeCategory_window','#search_select_knowledgeCategory_tree','#search_knCategory','');
        },
       
        
        /**
         * 导出知识库.
         */
        exportKnowledgeData: function () {

            if ($('#exportKnowledge').val() == 'view') {

                var sdata = $('#knowledgeSearchDiv form').getForm();
                var postData = $("#knowledgeGrid").jqGrid("getGridParam", "postData");
                $.extend(postData, sdata); //将postData中的查询参数覆盖为空值		
                var _url = 'knowledgeInfo!exportKnowledgeFromExcel.action';


                $.post(_url, postData, function (data) {

                    msgShow(i18n['msg_dc_dataExportSuccessful'], 'show');

                }, "json");
            }
        },


        /**
         * 打开导入数据窗口.
         */
        importKnowledgeData_openWindow: function () {

            $('#importKnowledgeDataWindow').window('open');
        },

        /**
         * 导入数据.
         */
        importKnowledgeData: function () {


            var form = $('#importKnowledgeDataWindow form').serialize();
            var url = "knowledgeInfo!importKnowledgeFromExcel.action";

            $.post(url, form, function (data) {

                $('#importKnowledgeDataWindow').window('close');

                msgShow(i18n['msg_dc_dataImportSuccessful'], 'show');

            }, "json");
        },

        
 	
    	//获取事件
    	fitKnowledgeGrids:function(){
    		
    		$('#knowledgeCategoryDiv').panel({
    			onCollapse:function(){ setGridWidth('#knowledgeGrid', 'regCenter', 46);},
    			onExpand:function(){setGridWidth('#knowledgeGrid', 'regCenter', 218);}
    		});
    	},
    	
    	/**
    	 * 加载知识分类树结构.
    	 */
    	showKnowledgeTreeView:function(){
    	
    		
	        //加载树结构
	       	 itsm.knowledge.knowledgeTree.showKnowledgeTree('#knowledgeCategoryTree',function(e,data){
	       		 
	    		var _name=data.rslt.obj.attr('cname');
	   			if(_name == i18n['knowledge_knowledgeCategorys']){
	   				_name="";
	   			}
	   			else{
	   				var postData = $("#knowledgeGrid").jqGrid("getGridParam", "postData");      
	   				$.extend(postData, {'knowledgeQueryDto.category': _name} );  
	   				var _url = 'knowledgeInfo!findAllKnowledges.action';
	   				$('#knowledgeGrid').jqGrid('setGridParam',{url:_url,page:1}).trigger('reloadGrid');
	   			}
	   			
	           });
    		
    	},

        
        /**
         * 加载.
         */
        init: function () {

        	
        	$("#knowledge_loading").hide();
        	$("#knowledge_contentPanel").show();
        	
        	//加载右边树菜单
        	itsm.knowledge.knowledgeGrid.showKnowledgeTreeView();
        	

            //动态创建事件
            itsm.knowledge.knowledgeGrid.showKnowledgeGrid();
            $('#search_knCategory').click(itsm.knowledge.knowledgeGrid.showKnowledgeCategory);
            $('#knowledge_search_ok').click(itsm.knowledge.knowledgeGrid.doSearchKnowledge);
            setTimeout(function () {
                itsm.knowledge.knowledgeGrid.init_usefullKnowledge();
                
                itsm.knowledge.knowledgeGrid.fitKnowledgeGrids();

            }, 0);


        }


    };


}();

//载入
$(document).ready(itsm.knowledge.knowledgeGrid.init);