/**  
 * @author Van  
 * @constructor knowledgeLeftMenu
 * @description "knowledgeLeftMenu"
 * @date 2010-11-17
 * @since version 1.0 
 */

$package('itsm.knowledge');

$import('itsm.knowledge.knowledgeDetail');

itsm.knowledge.leftMenu = function() 
{	



	//公开方法调用
	return {
		
		/**
		 *@description 显示热门，最新知识
		 */
		showHotKnowledges:function(){
			
			var url = 'knowledgeInfo!findPopularKnowledge.action';
			var hotHTML="";
			$.post(url,function(res)
			{
				for(var i=0;i<res.length;i++){
					hotHTML+=i+1+"、<a href=javascript:itsm.knowledge.knowledgeDetail.showKnowledgeDetail('"+res[i].kid+"')>"+res[i].title+"</a><br/>";
				}
				$('#hotKnowledge').html(hotHTML);
				
			});
			
		},
		/**
		 * @description 显示热门，最新知识
		 */
		showNewKnowledges:function(){
			
			var url = 'knowledgeInfo!findNewKnowledge.action';
			var hotHTML="";
			$.post(url,function(res)
			{
				for(var i=0;i<res.length;i++){
					hotHTML+=i+1+"、<a href=javascript:itsm.knowledge.knowledgeDetail.showKnowledgeDetail('"+res[i].kid+"')>"+res[i].title+"</a><br/>";
				}
				$('#newKnowledge').html(hotHTML);
				
			});
			
		},
		
		
		 /**
		  * @description 加载知识库首页.
		  */
		showKnowledgeIndex:function(){
					
			
			showLeftMenu('../pages/knowledge/leftMenu.jsp','leftMenu');
			openTab(i18n['title_request_knowledgeGrid'],'../pages/knowledge/knowledgeMain.jsp');

			setTimeout(function(){  
				itsm.knowledge.leftMenu.showHotKnowledges();
				itsm.knowledge.leftMenu.showNewKnowledges();
			},500);  

			
		},
		
		
		/**
		 * @description 门户首页-热门知识.
		 */
		showKnowledgePortal:function(tableID){
			
			var url="knowledgeInfo!findNewKnowledge.action";
			
			$.post(url,function(data){
				
				
				if(data!=null && data!=''){
					
					$(tableID).empty();
					
					var count=0;
					$.each(data,function(i,item){
						
	
						$(tableID).append("<tr><td style='width:5px'><img src='../images/numbers/"+(i+1)+".gif' /></td><td style='padding-left:10px;'><a href=javascript:itsm.knowledge.knowledgeDetail.showKnowledgeDetail('"+item.kid+"')>"+item.title+"</a></td><td>"+item.clickRate+"</td></tr>");
						count++;
						
						if(count>7){
							
							return false;
						}
						
					});
				}
					
			});
		}
		
		
		
		
	
	}


}();



