/**  
 * @author Tan  
 * @constructor Van
 * @description "noticeRule"
 * @date 2010-11-17
 * @since version 1.0 
 */
 $import("itsm.security.userUtil");
 
 var noticeRule = function(){
	 
	this.useStatusForma=function(cellvalue, options){
		if(cellvalue)
			return "启用"
		else
			return "禁用"
	}
	/**通知规则列表*/
	this.noticeRule_grid=function()
	{		
		$('#noticeRuleList').jqGrid({				
			url:'noticeRule!findPager.action',
			mtype:'post',
			datatype:'json',			
			autowidth:true, 
			height:'auto',
			colNames:[i18n['number'],i18n['name'],i18n['code'],i18n['status'],''],
			colModel:[
					{name:'noticeRuleId',width:80,sorttype:'Long',sortable:true},					
					{name:'noticeRuleName',width:100,edittype:'select',sortable:false},
					{name:'noticeRuleNo',width:100,edittype:'select',sortable:false},	
					{name:'useStatus',width:100,sortable:false,formatter:useStatusForma},
					{name:'useStatus',width:30,hidden:true}
			    ],
			    viewrecords:true,
			    multiselect: true,
			    caption:i18n['notitceRule']+i18n['managerment'],
			    jsonReader: {
					root: "data",
					records: "totalSize",
					page: "page",
					total: "total",
					repeatitems : false,
					id: "noticeRuleId"			
		     },		    	     
		     rowNum:10,
		     rowList:[10,20,30],
		     toolbar: [true,"top"],
		     pager:'#noticeRulePager',
		     hidegrid:false
		})
		.navGrid('#noticeRulePager',{"edit":false,"add":false,"del":false,"search":false,"view":false,"refresh":true,"refreshtext":'刷新'});
		$('#t_noticeRuleList')
		.css("padding-top","5px")
		.css("padding-bottom","10px")
		.css("border-top","none")
		.css("background","#eee")
		.css("text-align","left");
		$('#t_noticeRuleList').append($('#noticeRuleToolbar').html());
	}	
	
	
	
	
	//新增通知规则窗口
	this.addNoticeRule_win=function(){
		$('#addNoticeRule_win').window('open');
	}
	this.addNoticeRule_opt = function(){		
		var _params = $('#addNoticeRule_win form').serialize();
		$.post('noticeRule!noticeRuleSave.action', _params, function(){
			$('#addNoticeRule_win').window('close');
			msgShow(i18n['saveSuccess'],'show');	
			$('#noticeRuleList').trigger('reloadGrid');
		})
	}
	
	
	//编辑扩展属性
	this.editNoticeRule_win=function(){
		var rowId=$("#noticeRuleList").getGridParam("selrow");
		if(rowId==null)
		{
			$.messager.alert(i18n['tip'],'<br/>'+i18n['selectEditDataTip'],'info');
		}else
		{
			var data = $("#noticeRuleList").getRowData(rowId);
			$('#noticeRuleId').val(data.noticeRuleId);
			$('#noticeRuleName').val(data.noticeRuleName);
			$('#noticeRuleNo').val(data.noticeRuleNo);
			if(data.useStatus=='false'){
				$('#noticeRuleState1').attr("checked",'false')
			}else
			{
				$('#noticeRuleState').attr("checked",'ture')
			}
			
			$('#editNoticeRule_win').window('open');
		}
	}
	this.editNoticeRule_opt = function(){		
		var _params = $('#editNoticeRule_win form').serialize();
		$.post('noticeRule!noticeRuleUpdate.action', _params, function(){
			$('#editNoticeRule_win').window('close');
				msgShow(i18n['editSuccess'],'show');
			$('#noticeRuleList').trigger('reloadGrid');
		})
	}
	
	//删除属性
	this.deleteNoticeRule_opt=function(){
		var rowIds=$("#noticeRuleList").getGridParam("selarrrow");
		if(rowIds=="")
		{
			$.messager.alert(i18n['tip'],'<br/>'+i18n['selectDeleteDataTip'],'info');
		}else
		{
			$.messager.confirm(i18n['tip'],i18n['deleteComfirm'], function(r){
				if (r){
					var pp = $.param({'ids':rowIds},true);
					$.post("noticeRule!noticeRuleDelete.action", pp, function(){
					
						msgShow(i18n['deleteSuccess'],'show');
						$('#noticeRuleList').trigger('reloadGrid');
					}, "json");
				}
			});
		}
	}
	
	
	//更新保存
	this.noticeRule_opt = function(id){
		var _params = $("#"+id+" form").serialize();
		$.post('noticeRule!noticeRuleUpdate.action', _params, function(){
			
			msgShow(i18n['editSuccess'],'show');
		
		});
	}
	
	//给值
	this.setValues=function(){
		$.post('noticeRule!findPager.action',"rows=10000",function(data){
			var notice=data.data;
			for(var i=0;i<notice.length;i++){
				if(notice[i].useStatus){
					$('#'+notice[i].noticeRuleNo+'_check').attr("checked",'ture')
				}
				if(notice[i].technician!=null)
					$('#'+notice[i].noticeRuleNo+'_technician').val(notice[i].technician)
				else
					$('#'+notice[i].noticeRuleNo+'_technician').val('')
			}
		})
	}
	

	
	
	//选择技术员
	this.selectNoticeUser=function(userName){
		itsm.security.userUtil.selectUserMulti(userName,'','loginName');
	}

	//载入
	return {
		init: function() 
		{	
			
			$("#noticeRule_loading").hide();
			$("#noticeRule_panel").show();
			
			
			setValues();
		}
	}
}();
$(document).ready(noticeRule.init);
