 /**  
 * @fileOverview "noticeRuleManage"
 * @author tan
 * @version 1.0  
 */  
 /**  
 * @author tan  
 * @constructor noticeRuleManage
 * @description "noticeRuleManage"
 * @date 2010-11-17
 * @since version 1.0 
 */
 var noticeRuleManage = function(){
	 
	this.useStatusForma=function(cellvalue, options){
		return cellvalue ? "启用" : "禁用";
	}
	/**
	 * @description 通知规则列表
	 * @return {Num} result 结果 
	 * */
	this.noticeRule_grid=function()
	{		
		$('#noticeRuleList').jqGrid({				
			url:'noticeRule!findPager.action',
			mtype:'post',
			datatype:'json',			
			autowidth:true, 
			height:'auto',
			colNames:['编号','名称','编码','状态',''],
			colModel:[
					{name:'noticeRuleId',width:80,sorttype:'Long',sortable:true},					
					{name:'noticeRuleName',width:100,edittype:'select',sortable:false},
					{name:'noticeRuleNo',width:100,edittype:'select',sortable:false},	
					{name:'useStatus',width:100,sortable:false,formatter:useStatusForma},
					{name:'useStatus',width:30,hidden:true}
			    ],
			    viewrecords:true,
			    multiselect: true,
			    caption: '通知规则管理',
			    jsonReader: {
					root: "data",
					records: "totalSize",
					page: "page",
					total: "total",
					repeatitems : false,
					id: "noticeRuleId"			
		        },		    	     
		     rowNum:10,
		     rowList:[10,20,30],
		     toolbar: [true,"top"],
		     pager:'#noticeRulePager',
		     hidegrid:false
		})
		.navGrid('#noticeRulePager',{"edit":false,"add":false,"del":false,"search":false,"view":false,"refresh":true,"refreshtext":'刷新'});
		$('#t_noticeRuleList')
		.css("padding-top","5px")
		.css("padding-bottom","10px")
		.css("border-top","none")
		.css("background","#eee")
		.css("text-align","left");
		$('#t_noticeRuleList').append($('#noticeRuleToolbar').html());
	}	
	
	
	
	
	/**
	 * @description 新增通知规则窗口
	 * @return {Num} result 结果 
	 * */
	this.addNoticeRule_win=function(){
		$('#addNoticeRule_win').window('open');
	}
	this.addNoticeRule_opt = function(){		
		var _params = $('#addNoticeRule_win form').serialize();
		$.post('noticeRule!noticeRuleSave.action', _params, function(){
			$('#addNoticeRule_win').window('close');
			
			msgShow(i18n['saveSuccess'],'show');	
			
			$('#noticeRuleList').trigger('reloadGrid');
		})
	}
	
	
	/**
	 * @description 编辑扩展属性
	 * @return {Num} result 结果 
	 * */
	this.editNoticeRule_win=function(){
		var rowId=$("#noticeRuleList").getGridParam("selrow");
		if(rowId==null)
		{
			$.messager.alert('提示信息','<br/>请选择要编辑的行！','info');
		}else
		{
			var data = $("#noticeRuleList").getRowData(rowId);
			$('#noticeRuleId').val(data.noticeRuleId);
			$('#noticeRuleName').val(data.noticeRuleName);
			$('#noticeRuleNo').val(data.noticeRuleNo);
			if(data.useStatus=='false'){
				$('#noticeRuleState1').attr("checked",'false')
			}else
			{
				$('#noticeRuleState').attr("checked",'ture')
			}
			
			$('#editNoticeRule_win').window('open');
		}
	}
	this.editNoticeRule_opt = function(){		
		var _params = $('#editNoticeRule_win form').serialize();
		$.post('noticeRule!noticeRuleUpdate.action', _params, function(){
			$('#editNoticeRule_win').window('close');
			
			msgShow(i18n['editSuccess'],'show');
		
			
			$('#noticeRuleList').trigger('reloadGrid');
		})
	}
	
	/**
	 * @description 删除属性
	 * @return {Num} result 结果 
	 * */
	this.deleteNoticeRule_opt=function(){
		var rowIds=$("#noticeRuleList").getGridParam("selarrrow");
		if(rowIds=="")
		{
			$.messager.alert('提示信息','<br/>请选择要删除的行！','info');
		}else
		{
			$.messager.confirm('删除提示', '是否真的删除选中的行?', function(r){
				if (r){
					var pp = $.param({'ids':rowIds},true);
					$.post("noticeRule!noticeRuleDelete.action", pp, function(){
						msgShow(i18n['deleteSuccess'],'show');
						$('#noticeRuleList').trigger('reloadGrid');
					}, "json");
				}
			});
		}
	}
	
	
	
	//载入
	return {
		init: function() 
		{	
			noticeRule_grid();	

		}
	}
}();
$(document).ready(noticeRuleManage.init);
