/**  
 * @author Van  
 * @constructor Van
 * @description 用户在线日志.
 * @date 2010-11-17
 * @since version 1.0 
 */
$package('itsm.onlinelog');
$import("itsm.security.userUtil");

itsm.onlinelog.userOnlineLog = function(){
	
	
	return {
		
		/**
		 * @description 创建在线列表
		 */
		 showUserOnlineGrid:function(){
				var params = $.extend({},jqGridParams, {	
					url:'useronlinelog!findPager.action',
					caption:i18n['userOnline']+i18n['list'],
					colNames:['ID',i18n['user'],i18n['onlineTime'],i18n['offlineTime'],i18n['onlineTotal']],
					colModel:[
							  {name:'id',hidden:true},
							  {name:'userName',align:'center',width:120,sortable:true},
							  {name:'onlineTime',width:70,align:'center',sortable:true,formatter:timeFormatter},
							  {name:'offlineTime',width:120,align:'center',sortable:true,formatter:timeFormatter},
							  {name:'period',hidden:true}
							  
							  ],
					jsonReader: $.extend(jqGridJsonReader, {id: "id"}),
					sortname:'id',
					pager:'#userOnlineGridPager'
				});
				$("#userOnlineGrid").jqGrid(params);
				$("#userOnlineGrid").navGrid('#userOnlineGridPager',navGridParams);
				//列表操作项
				$("#t_userOnlineGrid").css(jqGridTopStyles);
				$("#t_userOnlineGrid").append($('#userOnlineGridToolbar').html());
				//自适应宽度
				setGridWidth("#userOnlineGrid","regCenter",9);
		},

		/**
		 * @description 选择用户
		 */
		selectUserOnlineUserOpenWinow:function(){
			itsm.security.userUtil.selectUser('#useronlinelog_keyWord','','','loginName');
		},
		/**
		 * @description 搜索在线用户
		 */
		searchUserOnline_do:function(){		
			
			//获得表单对象
			var sdata = $('#searchUserOnlineLog form').getForm();		
			var postData = $('#userOnlineGrid').jqGrid('getGridParam', 'postData');       
			$.extend(postData, sdata);		
			var _url = 'useronlinelog!findPager.action';	
			$('#userOnlineGrid').jqGrid('setGridParam',{url:_url,page:1}).trigger('reloadGrid');
		},
		
		/**
		 * @description 刷新在线用户用户列表
		 */
		refreshUserOnlineLogjqGrid:function(){
			
			$('#useronlinelog_keyWord').val("");
			$('#onlineTime').val("");
			$('#onlineEndTime').val("");
			$('#offlineTime').val("");
			$('#offlineEndTime').val("");
	
			//获得表单对象
			var sdata = $('#searchUserOnlineLog form').getForm();		
			var postData = $('#userOnlineGrid').jqGrid('getGridParam', 'postData');       
			$.extend(postData, sdata); 
			var _url = 'useronlinelog!findPager.action';	
			
			$('#userOnlineGrid').jqGrid('setGridParam',{url:_url,page:1}).trigger('reloadGrid');
		},
		init:function(){
			
						
			$("#UserOnlineLog_loading").hide();
			$("#UserOnlineLog_content").show();
			itsm.onlinelog.userOnlineLog.showUserOnlineGrid();

			$('#userOnlineGrid_search').click(function(){
				$('#searchUserOnlineLog').window('open');
			});
			
			
			$('#useronlinelog_keyWord').click(itsm.onlinelog.userOnlineLog.selectUserOnlineUserOpenWinow);
			
			$('#userOnlineGrid_doSearch').click(itsm.onlinelog.userOnlineLog.searchUserOnline_do);
			
		}
		
	};
	
	
 }();
 
 
//载入
 $(document).ready(itsm.onlinelog.userOnlineLog.init);
