 /**  
 * @author Van  
 * @constructor Van
 * @description 用户操作日志.
 * @date 2010-11-17
 * @since version 1.0 
 */

$package('itsm.onlinelog');

$import("itsm.security.userUtil");

itsm.onlinelog.userOptLog=function(){
	
	
	 return {
		 

		 showUserOptLogGrid:function(){
				var params = $.extend({},jqGridParams, {	
					url:'useroptlog!findPager.action',
					caption:i18n['userOptLog'],
					colNames:[i18n['user'],i18n['operateItems'],i18n.resource, i18n['resource']+'ID',i18n['date'],''],
					colModel:[
							  
							  {name:'userName',width:20,align:'center'},
							  {name:'methodName',width:30,align:'center'},
							  {name:'resourceName',width:20,align:'center'},
							  {name:'resourceId',width:20,align:'center'},
							  {name:'time',width:30,align:'center',formatter:timeFormatter},
							  {name:'id',hidden:true}
							  ],
					jsonReader: $.extend(jqGridJsonReader, {id: "id"}),
					sortname:'id',
					pager:'#userOptGridPager'
				});
				$("#userOptGrid").jqGrid(params);
				$("#userOptGrid").navGrid('#userOptGridPager',navGridParams);
				//列表操作项
				$("#t_userOptGrid").css(jqGridTopStyles);
				$("#t_userOptGrid").append($('#userOptGridToolbar').html());
				//自适应宽度
				setGridWidth("#userOptGrid","regCenter",9);
		},
	
		 /**
		  * @description 搜索操作日志
		  */
		searchUserOptLog_do:function(){				
			
			//获得表单对象
			var sdata = $('#searchUserOptLog form').getForm();		
			var postData = $('#userOptGrid').jqGrid('getGridParam', 'postData');       
			$.extend(postData, sdata);
			var _url ="useroptlog!findPager.action";	
			$('#userOptGrid').jqGrid('setGridParam',{url:_url,page:1}).trigger('reloadGrid');
	
		},
		
		refreshUserOptLogjqGrid:function(){
			$('#user_Name').val("");
			$('#method_Name').val("");
			$('#startTime').val("");
			$('#endTime').val("");
			//获得表单对象
			var sdata = $('#searchUserOptLog form').getForm();		
			var postData = $('#userOptGrid').jqGrid('getGridParam', 'postData');       
			$.extend(postData, sdata); 
			var _url ="useroptlog!findPager.action";	
			$('#userOptGrid').jqGrid('setGridParam',{url:_url,page:1}).trigger('reloadGrid');
		},
			
		
		init:function(){
			
			 $("#UserOptLog_loading").hide();
			 $("#UserOptLog_content").show();
			 
			 
			 itsm.onlinelog.userOptLog.showUserOptLogGrid();//加载列表
			 
			 $("#userOptGrid_search").click(function(){
				 $('#searchUserOptLog').window('open');
			 });
			 
			 //选择用户
			 $('#user_Name').click(function(){
				 
				 itsm.security.userUtil.selectUser('#user_Name','','','loginName');
				 
			 });

			 
			 $("#userOptGrid_doSearch").click(itsm.onlinelog.userOptLog.searchUserOptLog_do);
		}
		
	 };

 }();

//载入
 $(document).ready(itsm.onlinelog.userOptLog.init);
